#!/usr/local/bin/perl
# index.cgi
# Display sshd option categories

require './sshd-lib.pl';

# Check if config file exists
if (!-r $config{'sshd_config'}) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);
	print &text('index_econfig', "<tt>$config{'sshd_config'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{"index"});
	exit;
	}

# Check if sshd exists
if (!&has_command($config{'sshd_path'})) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);
	print &text('index_esshd', "<tt>$config{'sshd_path'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{"index"});
	exit;
	}

# Check if sshd is the right version
$out = `$config{'sshd_path'} -h 2>&1`;
if ($out =~ /(sshd\s+version\s+([0-9\.]+))/i ||
    $out =~ /(ssh\s+secure\s+shell\s+([0-9\.]+))/i) {
	# Classic commercial SSH
#	if ($2 >= 3) {
#		&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);
#		print &text('index_eversion2',
#			    "<tt>$config{'sshd_path'}</tt>", "$2"),"<p>\n";
#		&ui_print_footer("/", $text{"index"});
#		exit;
#		}
	$version{'type'} = 'ssh';
	$version{'number'} = $2;
	$version{'full'} = $1;
	}
elsif ($out =~ /(OpenSSH.([0-9\.]+))/i) {
	# OpenSSH .. assume all versions are supported
	$version{'type'} = 'openssh';
	$version{'number'} = $2;
	$version{'full'} = $1;
	}
elsif ($out =~ /(Sun_SSH_([0-9\.]+))/i) {
	# Solaris 9 SSH is actually OpenSSH 2.x
	$version{'type'} = 'openssh';
	$version{'number'} = 2.0;
	$version{'full'} = $1;
	}
elsif (($out = $config{'sshd_version'}) && ($out =~ /(Sun_SSH_([0-9\.]+))/i)) {
	# Probably Solaris 10 SSHD that didn't display version.  Use it.
	$version{'type'} = 'openssh';
	$version{'number'} = 2.0;
	$version{'full'} = $1;
 }
else {
	# Unknown version
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1);
	print &text('index_eversion', "<tt>$config{'sshd_path'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name",
		    "<tt>$config{'sshd_path'} -h</tt>",
		    "<pre>$out</pre>"),"<p>\n";
	&ui_print_footer("/", $text{"index"});
	exit;
	}
&write_file("$module_config_directory/version", \%version);

&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("ssh", "man", "doc", "google"), undef, undef,
	&text('index_version', $version{'full'}));

# Display icons for options
foreach $i ('users', 'net', 'access', 'misc') {
	push(@links, "edit_$i.cgi");
	push(@titles, $text{$i.'_title'});
	push(@icons, "images/$i.gif");
	}
if (-r $config{'client_config'}) {
	push(@links, "list_hosts.cgi");
	push(@titles, $text{'hosts_title'});
	push(@icons, "images/hosts.gif");
	}
push(@links, "edit_sync.cgi");
push(@titles, $text{'sync_title'});
push(@icons, "images/sync.gif");
&icons_table(\@links, \@titles, \@icons, scalar(@links));

# Check if sshd is running
$pidfile = &get_pid_file();
if (&check_pid_file($pidfile)) {
	# Running .. offer to apply changes
	print "<hr>\n";
	print "<form action=apply.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	if ($config{'restart_cmd'}) {
		print "<td>",&text('index_applymsg2',
			"<tt>$config{'restart_cmd'}</tt>"),"</td>\n";
		}
	else {
		print "<td>$text{'index_applymsg'}</td>\n";
		}
	print "</tr></table></form>\n";
	}
else {
	# Not running .. offer to start
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td>\n";
	print "</tr></table></form>\n";
	}
close(PID);

&ui_print_footer("/", $text{"index"});

