# iface-monitor.pl
# Check if a network interface is up or down

sub get_iface_status
{
&foreign_require("net", "net-lib.pl");
local @act = &net::active_interfaces();
local $a;
foreach $a (@act) {
	if ($a->{'fullname'} eq $_[0]->{'iface'} &&
	    $a->{'up'}) {
		return { 'up' => 1 };
		}
	}
return { 'up' => 0 };
}

sub show_iface_dialog
{
&foreign_require("net", "net-lib.pl");
print "<tr> <td><b>$text{'iface_iface'}</b></td>\n";
print "<td><select name=iface>\n";
local ($i, %done);
foreach $i (sort { $a->{'fullname'} cmp $b->{'fullname'} }
		 (&net::boot_interfaces(), &net::active_interfaces())) {
	next if ($done{$a->{'fullname'}}++);
	printf "<option value=%s %s>%s (%s)\n",
		$i->{'fullname'},
		$_[0]->{'iface'} eq $i->{'fullname'} ? 'selected' : '',
		$i->{'fullname'}, &net::iface_type($i->{'fullname'});
	}
print "</select></td>\n";
}

sub parse_iface_dialog
{
&depends_check($_[0], "net");
$_[0]->{'iface'} = $in{'iface'};
}

