# Check if some lm_sensors value is too high

sub get_sensors_status
{
return { 'up' => 1 } if (!&has_command("sensors"));
local @sens = &get_sensors_values();
local ($sens) = grep { $_->{'name'} eq $_[0]->{'name'} } @sens;
return { 'up' => 1 } if (!$sens);
if ($_[0]->{'mode'} == 0) {
	return $sens->{'alarm'} ? { 'up' => 0 } : { 'up' => 1 };
	}
elsif ($_[0]->{'mode'} == 1) {
	return $sens->{'value'} < $_[0]->{'min'} ? { 'up' => 0 }
						 : { 'up' => 1 };
	}
elsif ($_[0]->{'mode'} == 2) {
	return $sens->{'value'} > $_[0]->{'max'} ? { 'up' => 0 }
						 : { 'up' => 1 };
	}
}

sub show_sensors_dialog
{
if (!&has_command("sensors")) {
	print "<tr> <td colspan=4>$text{'sensors_cmd'}</td> </tr>\n";
	}
elsif (@sens = &get_sensors_values()) {
	print "<tr> <td><b>$text{'sensors_name'}</b></td>\n";
	print "<td colspan=3>",&ui_select("name", $_[0]->{'name'},
		[ map { [ $_->{'name'}, &text('sensors_cur', $_->{'name'}, $_->{'value'}, $_->{'units'}) ] } @sens ]),"</td> </tr>\n";

	print "<tr> <td><b>$text{'sensors_value'}</b></td>\n";
	print "<td colspan=3>",&ui_radio("mode", $_[0]->{'mode'} || 0,
		[ [ 0, $text{'sensors_value0'} ],
		  [ 1, &text('sensors_value1',
			     &ui_textbox("min", $_[0]->{'min'}, 8)) ],
		  [ 2, &text('sensors_value2',
			     &ui_textbox("max", $_[0]->{'max'}, 8)) ] ]),
	      "</td> </tr>\n";
	}
else {
	print "<tr> <td colspan=4>$text{'sensors_none'}</td> </tr>\n";
	}
}

sub parse_sensors_dialog
{
&has_command("sensors") || &error($text{'sensors_cmd'});
local @sens = &get_sensors_values();
@sens || &error($text{'sensors_none'});
$_[0]->{'name'} = $in{'name'};
$_[0]->{'mode'} = $in{'mode'};
$_[0]->{'max'} = $in{'max'};
$_[0]->{'min'} = $in{'min'};
if ($in{'mode'} == 1) {
	$in{'min'} =~ /^[0-9\.\+\-]+$/ || &error($text{'sensors_emin'});
	}
elsif ($in{'mode'} == 2) {
	$in{'max'} =~ /^[0-9\.\+\-]+$/ || &error($text{'sensors_emax'});
	}
}

# get_sensors_values()
# Returns a list of lm_sensors names, values and maxes
sub get_sensors_values
{
if (!defined(@get_sensors_cache)) {
	local @rv;
	open(SENS, "sensors |");
	while(<SENS>) {
		if (/^([^:]+):\s+([0-9\.\+\-]+)\s*(\S+)\s+\(min\s+=\s+([0-9\.\+\-]+)\s*(\S+),\s+max\s+=\s+([0-9\.\+\-]+)/) {
			# Value with min and max
			push(@rv, { 'name' => $1,
				    'value' => $2,
				    'units' => $3,
				    'min' => $4,
				    'max' => $6 });
			$rv[$#rv]->{'alarm'} = 1 if (/ALARM/);
			}
		elsif (/^([^:]+):\s+([0-9\.\+\-]+)\s*(\S+)\s+\(min\s+=\s+([0-9\.\+\-]+)\s*(\S+),\s+div\s+=\s+([0-9\.\+\-]+)/) {
			# Value with min only
			push(@rv, { 'name' => $1,
				    'value' => $2,
				    'units' => $3,
				    'min' => $4,
				    'div' => $6 });
			$rv[$#rv]->{'alarm'} = 1 if (/ALARM/);
			}
		elsif (/^([^:]+):\s+([0-9\.\+\-]+)\s*(\S+)\s+\((limit|high)\s+=\s+([0-9\.\+\-]+)\s*(\S+)/) {
			# Value with max only
			push(@rv, { 'name' => $1,
				    'value' => $2,
				    'units' => $3,
				    'max' => $5 });
			$rv[$#rv]->{'alarm'} = 1 if (/ALARM/);
			}
		}
	close(SENS);
	@get_sensors_cache = @rv;
	}
return @get_sensors_cache;
}

