#!/usr/local/bin/perl
# create-user.pl
# Adds a new mailbox, based on command-line parameters

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/create-user.pl";
require './virtual-server-lib.pl';
$< == 0 || die "create-user.pl must be run as root";

# Parse command-line args
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--domain") {
		$domain = shift(@ARGV);
		}
	elsif ($a eq "--user") {
		$username = lc(shift(@ARGV));
		}
	elsif ($a eq "--pass") {
		$pass = shift(@ARGV);
		}
	elsif ($a eq "--real") {
		$real = shift(@ARGV);
		}
	elsif ($a eq "--ftp") {
		$ftp++;
		}
	elsif ($a eq "--noemail") {
		$noemail++;
		}
	elsif ($a eq "--extra") {
		local $extra = shift(@ARGV);
		push(@extra, $extra);
		}
	elsif ($a eq "--quota") {
		$quota = shift(@ARGV);
		}
	elsif ($a eq "--mail-quota") {
		$mquota = shift(@ARGV);
		}
	}

# Make sure all needed args are set
$domain && $username && $pass || &usage();
if ($config{'home_quotas'}) {
	$quota =~ /^\d+$/ || &usage();
	}
if ($config{'mail_quotas'} && $config{'home_quotas'} ne $config{'mail_quotas'}) {
	$mquota =~ /^\d+$/ || &usage();
	}
$d = &get_domain_by("dom", $domain);
$d || die("Virtual server $domain does not exist");
$username =~ /^[^ \t:]+$/ || die($text{'user_euser'});
$real =~ /^[^:]*$/ || die($text{'user_ereal'});
foreach $e (@extra) {
	$e = lc($e);
	if ($e =~ /^([^\@ \t]+$)$/) {
		$e = "$e\@$d->{'dom'}";
		}
	if ($e !~ /^(\S+)\@(\S+)$/) {
		die(&text('user_eextra1', $e));
		}
	local ($eu, $ed) = ($1, $2);
	local $edom = &get_domain_by("dom", $ed);
	$edom && $edom->{'mail'} || die(&text('user_eextra2', $ed));
	}

# Build taken lists
&build_taken(\%taken, \%utaken);

# Construct user object
$user->{'uid'} = &allocate_uid(\%taken);
$user->{'gid'} = $d->{'gid'};
$user->{'real'} = $real;
$user->{'shell'} = $ftp ? $config{'ftp_shell'} : $config{'shell'};
$user->{'home'} = "$d->{'home'}/$config{'homes_dir'}/$username";
$user->{'passmode'} = 3;
$user->{'plainpass'} = $pass;
$user->{'pass'} = &useradmin::encrypt_password($pass);
$user->{'extraemail'} = \@extra;
if ($utaken{$username} || $config{'append'}) {
	$user->{'user'} = &userdom_name($username, $d);
	}
else {
	$user->{'user'} = $username;
	}
$user->{'email'} = "$username\@$d->{'dom'}" if (!$noemail);

# Check for a clash in this domain
if ($utaken{$user->{'user'}} ||
    &check_clash($username, $d->{'dom'})) {
	die($text{'user_eclash'});
	}

# Check if any extras clash
foreach $e (@extra) {
	$e =~ /^(\S+)\@(\S+)$/;
	if (&check_clash($1, $2)) {
		die(&text('user_eextra4', $e));
		}
	}

# Check if the name is too long
if ($lerr = &too_long($user->{'user'})) {
	die($lerr);
	}

# Create the user and virtusers and alias
&create_user($user, $d);

# Create his homedir
system("mkdir -p '$user->{'home'}'");
system("chown $user->{'uid'}:$user->{'gid'} '$user->{'home'}'");
system("chmod 755 '$user->{'home'}'");

# Copy files into homedir
&copy_skel_files($config{'mail_skel'}, $user);

# Send an email upon creation
@erv = &send_user_email($d, $user);

# Set quotas
if ($config{'home_quotas'}) {
	&set_quota($user->{'user'}, $config{'home_quotas'}, $quota);
	}
if ($config{'mail_quotas'} && $config{'home_quotas'} ne $config{'mail_quotas'}) {
	&set_quota($user->{'user'}, $config{'mail_quotas'}, $quota);
	}

print "User $user->{'user'} created successfully\n";

sub usage
{
print "Adds a new mailbox user to an existing Virtualmin domain.\n";
print "\n";
print "usage: create-user.pl    --domain domain.name\n";
print "                         --user new-username\n";
print "                         --pass password-for-new-user\n";
if ($config{'home_quotas'}) {
	print "                         --quota quota-in-blocks\n";
	}
if ($config{'mail_quotas'} && $config{'mail_quotas'} ne $config{'home_quotas'}) {
	print "                         --mail-quota quota-in-blocks\n";
	}
print "                        [--real real-name-for-new-user]\n";
print "                        [--ftp]\n";
print "                        [--noemail]\n";
print "                        [--extra email.address\@some.domain]\n";
exit(1);
}
