#!/usr/local/bin/perl
# edit_domain.cgi
# Display details of a domain for editing

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
&header($text{'edit_title'}, "");
#&domain_title($d);
print "<hr>\n";

print "<form action=save_domain.cgi method=post>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_domain'}</b></td>\n";
print "<td><tt>$d->{'dom'}</tt></td>\n";

print "<td><b>$text{'edit_user'}</b></td>\n";
print "<td><tt>$d->{'user'}</tt></td> </tr>\n";

print "<tr> <td><b>$text{'edit_ip'}</b></td>\n";
print "<td><tt>$d->{'ip'}</tt></td>\n";

print "<td><b>$text{'edit_virt'}</b></td>\n";
if ($d->{'iface'}) {
	# Got a virtual IP
	print "<td><tt>$d->{'iface'}</tt></td> </tr>\n";
	print "<input type=hidden name=virt value=1>\n";
	}
elsif ($config{'all_namevirtual'}) {
	# Always name-based, but IP can be changed
	print "<input name=ip size=15 value='$d->{'ip'}'></td> </tr>\n";
	}
else {
	# Show option to add
	print "<td><input type=radio name=virt value=0 checked> ",
	      "$text{'edit_virtnone'}\n";
	print "<input type=radio name=virt value=1> ",
	      "$text{'edit_virtalloc'}\n";
	print "<input name=ip size=15></td> </tr>\n";
	}

print "<tr> <td><b>$text{'edit_owner'}</b></td>\n";
print "<td colspan=3><input name=owner size=50 value='",
	&html_escape($d->{'owner'}),"'></td> </tr>\n";

print "<tr> <td><b>$text{'edit_email'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=email_def value=1 %s> %s\n",
	$d->{'email'} ? "" : "checked", $text{'edit_email_def'};
printf "<input type=radio name=email_def value=0 %s>\n",
	$d->{'email'} ? "checked" : "";
print "<input name=email size=50 value='",
	&html_escape($d->{'email'}),"'></td> </tr>\n";

print "<tr> <td><b>$text{'edit_passwd'}</b></td> <td colspan=3>\n";
print "<input type=radio name=passwd_def value=1 checked> $text{'edit_lv'}\n";
print "<input type=radio name=passwd_def value=0> $text{'edit_set'}\n";
print "<input type=password name=passwd size=20></td> </tr>\n";

print "<tr> <td><b>$text{'form_mailboxlimit'}</b></td> <td colspan=2>\n";
printf "<input type=radio name=mailboxlimit_def value=1 %s> %s\n",
	$d->{'mailboxlimit'} ? "" : "checked", $text{'form_unlimit'};
printf "<input type=radio name=mailboxlimit_def value=0 %s> %s\n",
	$d->{'mailboxlimit'} ? "checked" : "", $text{'form_atmost'};
print "<input name=mailboxlimit value='$d->{'mailboxlimit'}' size=4></td></tr>\n";

if ($config{'home_quotas'}) {
	print "<tr> <td><b>$text{'edit_quota'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=quota_def value=1 %s> %s\n",
		$d->{'quota'} ? "" : "checked", $text{'form_unlimit'};
	printf "<input type=radio name=quota_def value=0 %s>\n",
		$d->{'quota'} ? "checked" : "";
	print &quota_input("quota", $d->{'quota'}, $config{'home_quotas'}),
	      "</td> </tr>\n";

	@users = &list_domain_users($d);
	($duser) = grep { $_->{'user'} eq $d->{'user'} } @users;
	print "<tr> <td><b>$text{'edit_uquota'}</b></td> <td colspan=3>\n";
	printf "<input type=radio name=uquota_def value=1 %s> %s\n",
		$d->{'uquota'} ? "" : "checked", $text{'form_unlimit'};
	printf "<input type=radio name=uquota_def value=0 %s>\n",
		$d->{'uquota'} ? "checked" : "";
	print &quota_input("uquota", $d->{'uquota'}, $config{'home_quotas'}),
	      "</td> </tr>\n";

	print "<tr> <td><b>$text{'edit_mailquota'}</b></td> <td colspan=3>\n";
	local $mailquota = 0;
	local $homequota = 0;
	foreach $u (@users) {
		if ($u->{'user'} ne $d->{'user'}) {
			$homequota += $u->{'uquota'};
			$mailquota += $u->{'umquota'};
			}
		}
	print &text('edit_qon', &quota_show($homequota, $config{'home_quotas'}), $config{'home_quotas'}),"\n";
	local $mq = $config{'mail_quotas'} &&
		    $config{'mail_quotas'} ne $config{'home_quotas'};
	if ($mq) {
		print " , ",&text('edit_qon', &quota_show($mailquota, $config{'mail_quotas'}), $config{'mail_quotas'}),"\n";
		}
	print "</td> </tr>\n";

	print "<tr> <td><b>$text{'edit_userquota'}</b></td> <td colspan=3>\n";
	print &text('edit_qon', &quota_show($duser->{'uquota'}, $config{'home_quotas'}), $config{'home_quotas'}),"\n";
	if ($mq) {
		print " , ",&text('edit_qon', &quota_show($duser->{'umquota'}, $config{'mail_quotas'}), $config{'mail_quotas'}),"\n";
		}
	print "</td> </tr>\n";
	}

# Show buttons for turning features on and off (if allowed)
print "<tr> <td colspan=4><hr></td> </tr>\n";
if ($d->{'disabled'}) {
	print "<tr> <td colspan=4 align=center>&nbsp;<br><font color=#ff0000>",
	      "<b>$text{'edit_disabled'}</b></font><br>&nbsp;</td> </tr>\n";
	}
else {
	$i = 0;
	foreach $f (@opt_features) {
		print "<tr>\n" if ($i%2 == 0);
		print "<td><b>",$text{'edit_'.$f},"</b></td>\n";
		if ($config{$f} || !defined($config{$f})) {
			printf"<td><input type=radio name=$f value=1 %s> %s\n",
				$d->{$f} ? "checked" : "", $text{'yes'};
			printf"<input type=radio name=$f value=0 %s> %s</td>\n",
				$d->{$f} ? "" : "checked", $text{'no'};
			}
		else {
			print "<td><i>$text{'form_unavail'}</i></td>\n";
			}
		print "</tr>\n" if ($i++%2 == 1);
		}

	print "</tr>\n";
	}

print "</table></td></tr></table>\n";
print "<table width=100%><tr>\n";
print "<td><input type=submit value='$text{'edit_save'}'></td>\n";
print "</form>\n";

if ($d->{'disabled'}) {
	print "<form action=enable_domain.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<td align=center><input type=submit ",
	      "value='$text{'edit_enable'}'></td>\n";
	print "</form>\n";
	}
else {
	print "<form action=disable_domain.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<td align=center><input type=submit name=disable ",
	      "value='$text{'edit_disable'}'></td>\n";
	print "</form>\n";
	}

print "<form action=delete_domain.cgi>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<td align=right><input type=submit name=delete ",
      "value='$text{'edit_delete'}'></td>\n";
print "</form></tr>\n";

if ($d->{'mail'}) {
	print "<tr>\n";
	print "<form action=list_users.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<td><input type=submit value='$text{'edit_users'}'></td></form>\n";

	print "<td></td>\n";

	print "<form action=list_aliases.cgi>\n";
	print "<input type=hidden name=dom value='$in{'dom'}'>\n";
	print "<td align=right><input type=submit value='$text{'edit_aliases'}'></td></form>\n";
	print "</tr>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

