
$feature_depends{'ftp'} = [ 'virt' ];

sub require_proftpd
{
return if ($require_proftpd++);
&foreign_require("proftpd", "proftpd-lib.pl");
}

# setup_ftp(&domain)
# Setup a virtual FTP server for some domain
sub setup_ftp
{
&$first_print($text{'setup_proftpd'});
&require_proftpd();

# Get the template
local @dirs = &proftpd_template($config{'proftpd_config'}, $_[0]);

# Add the directives
local $conf = &proftpd::get_config();
local $l = $conf->[@$conf - 1];
&lock_file($l->{'file'});
local $lref = &read_file_lines($l->{'file'});
local @lines = ( "<VirtualHost $_[0]->{'ip'}>" );
push(@lines, @dirs);
push(@lines, "</VirtualHost>");
push(@$lref, @lines);
&flush_file_lines();
&unlock_file($l->{'file'});

# Create directory for FTP root
local ($fdir) = ($config{'ftp_dir'} || 'ftp');
local $ftp = "$_[0]->{'home'}/$fdir";
if (!-d $ftp) {
	&system_logged("mkdir '$ftp' 2>/dev/null");
	&system_logged("chmod 755 '$ftp'");
	&system_logged("chown $_[0]->{'uid'}:$_[0]->{'ugid'} '$ftp'");
	}

&$second_print($text{'setup_done'});
&restart_proftpd();
undef(@proftpd::get_config_cache);
}

# delete_ftp(&domain)
# Delete the virtual server from the ProFTPd config
sub delete_ftp
{
&require_proftpd();
local $conf = &proftpd::get_config();
&$first_print($text{'delete_proftpd'});
local ($virt, $vconf) = &get_proftpd_virtual($_[0]->{'ip'});
if ($virt) {
	&lock_file($virt->{'file'});
	local $lref = &read_file_lines($virt->{'file'});
	splice(@$lref, $virt->{'line'}, $virt->{'eline'} - $virt->{'line'} + 1);
	&flush_file_lines();
	&unlock_file($virt->{'file'});

	&$second_print($text{'setup_done'});
	&restart_proftpd();
	undef(@proftpd::get_config_cache);
	}
else {
	&$second_print($text{'delete_noproftpd'});
	}
}

# modify_ftp(&domain, &olddomain)
# If the server has changed IP address, update the ProFTPd virtual server
sub modify_ftp
{
local $rv = 0;
&require_proftpd();
local $conf = &proftpd::get_config();
local ($virt, $vconf) = &get_proftpd_virtual($_[1]->{'ip'});
return 0 if (!$virt);
&lock_file($virt->{'file'});
if ($_[0]->{'ip'} ne $_[1]->{'ip'}) {
	&$first_print($text{'save_proftpd'});
	local $lref = &read_file_lines($virt->{'file'});
	$lref->[$virt->{'line'}] = "<VirtualHost $_[0]->{'ip'}>";
	&flush_file_lines();
	$rv++;
	&$second_print($text{'setup_done'});
	}
&unlock_file($virt->{'file'});
&restart_proftpd() if ($rv);
return $rv;
}

# disable_ftp(&domain)
# Disable FTP for this server by adding a deny directive
sub disable_ftp
{
&$first_print($text{'disable_proftpd'});
&require_proftpd();
local ($virt, $vconf, $anon, $aconf) = &get_proftpd_virtual($_[0]->{'ip'});
if ($anon) {
	&lock_file($anon->{'file'});
	local @limit = &proftpd::find_directive_struct("Limit", $aconf);
	local ($login) = grep { $_->{'words'}->[0] eq "LOGIN" } @limit;
	if (!$login) {
		local $lref = &read_file_lines($anon->{'file'});
		splice(@$lref, $anon->{'eline'}, 0,
		       "<Limit LOGIN>", "DenyAll", "</Limit>");
		&flush_file_lines();
		}
	&unlock_file($anon->{'file'});
	&$second_print($text{'setup_done'});
        &restart_proftpd();
	}
else {
	&$second_print($text{'delete_noproftpd'});
	}
}

# enable_ftp(&domain)
# Enable FTP for this server by removing the deny directive
sub enable_ftp
{
&$first_print($text{'enable_proftpd'});
&require_proftpd();
local ($virt, $vconf, $anon, $aconf) = &get_proftpd_virtual($_[0]->{'ip'});
if ($virt) {
	&lock_file($anon->{'file'});
	local @limit = &proftpd::find_directive_struct("Limit", $aconf);
	local ($login) = grep { $_->{'words'}->[0] eq "LOGIN" } @limit;
	if ($login) {
		local $lref = &read_file_lines($anon->{'file'});
		splice(@$lref, $login->{'line'},
		       $login->{'eline'} - $login->{'line'} + 1);
		&flush_file_lines();
		}
	&unlock_file($anon->{'file'});
	&$second_print($text{'setup_done'});
        &restart_proftpd();
	}
else {
	&$second_print($text{'delete_noproftpd'});
	}
}

# proftpd_template(text, &domain)
# Returns a suitably substituted ProFTPd template
sub proftpd_template
{
local $dirs = $_[0];
$dirs =~ s/\t/\n/g;
$dirs = &substitute_template($dirs, $_[1]);
local @dirs = split(/\n/, $dirs);
return @dirs;
}

# check_proftpd_template()
# Returns an error message if the default ProFTPd directives don't look valid
sub check_proftpd_template
{
local ($d, $gotuser, $gotgroup);
local @dirs = split(/\t+/, $config{'proftpd_config'});
foreach $d (@dirs) {
	$d =~ s/#.*$//;
	if ($d =~ /^\s*User\s+(\S+)$/i) {
		defined(getpwnam($1)) || return &text('fcheck_euserex', $1);
		$gotuser++;
		}
	elsif ($d =~ /^\s*Group\s+(\S+)$/i) {
		defined(getgrnam($1)) || return &text('fcheck_egroupex', $1);
		$gotgroup++;
		}
	}
$gotuser || return $text{'fcheck_euser'};
$gotgroup || return $text{'fcheck_egroup'};
return undef;
}

# restart_proftpd()
# Tell ProFTPd to re-read its config file. Does nothing if run from inetd
sub restart_proftpd
{
&require_proftpd();
local $conf = &proftpd::get_config();
local $st = &proftpd::find_directive("ServerType", $conf);
if (lc($st) ne "inetd") {
	&$first_print($text{'setup_proftpdpid'});
	local $pidfile = $proftpd::config{'pid_file'};
	local $rv = 0;
	if (open(PID, $pidfile) && <PID> =~ /(\d+)/ && kill(0, $1)) {
		&kill_logged('HUP', $1);
		&$second_print($text{'setup_notrun'});
		}
	else {
		&$second_print($text{'setup_done'});
		$rv = 1;
		}
	close(PID);
	return $rv;
	}
}

# get_proftpd_virtual(ip)
# Returns the list of configuration directives and the directive for the
# virtual server itself for some domain
sub get_proftpd_virtual
{
&require_proftpd();
local $conf = &proftpd::get_config();
local $v;
foreach $v (&proftpd::find_directive_struct("VirtualHost", $conf)) {
	if ($v->{'words'}->[0] eq $_[0]) {
		# Found it! Looks for 
		local $a = &proftpd::find_directive_struct("Anonymous", $v->{'members'});
		if ($a) {
			return ($v, $v->{'members'}, $a, $a->{'members'});
			}
		else {
			return ($v, $v->{'members'});
			}
		}
	}
return ();
}

# check_ftp_clash(&domain)
# Returns 1 if a ProFTPd server already exists for some domain
sub check_ftp_clash
{
local ($cvirt, $cconf) = &get_proftpd_virtual($_[0]->{'ip'});
return $cvirt ? 1 : 0;
}

# backup_ftp(&domain, file)
# Save the virtual server's ProFTPd config as a separate file
sub backup_ftp
{
&$first_print($text{'backup_proftpdcp'});
local ($virt, $vconf) = &get_proftpd_virtual($_[0]->{'ip'});
local $lref = &read_file_lines($virt->{'file'});
local $l;
open(FILE, ">$_[1]");
foreach $l (@$lref[$virt->{'line'} .. $virt->{'eline'}]) {
	print FILE "$l\n";
	}
close(FILE);
&$second_print($text{'setup_done'});
return 1;
}

# restore_ftp(&domain, file)
# Update the virtual server's ProFTPd configuration from a file. Does not
# change the actual <Virtualhost> lines!
sub restore_ftp
{
&$first_print($text{'restore_proftpdcp'});
local ($virt, $vconf) = &get_proftpd_virtual($_[0]->{'ip'});
local $srclref = &read_file_lines($_[1]);
local $dstlref = &read_file_lines($virt->{'file'});
&lock_file($virt->{'file'});
splice(@$dstlref, $virt->{'line'}+1, $virt->{'eline'}-$virt->{'line'}-1,
       @$srclref[1 .. @$srclref-2]);
&flush_file_lines();
&unlock_file($virt->{'file'});
&$second_print($text{'setup_done'});

&restart_proftpd();
return 1;
}



1;

