sub require_mysql
{
return if ($require_mysql++);
&foreign_require("mysql", "mysql-lib.pl");
%mconfig = &foreign_config("mysql");
}

# setup_mysql(&domain)
# Create a new MySQL database, user and permissions
sub setup_mysql
{
&$first_print($text{'setup_mysql'});
&require_mysql();
$_[0]->{'mysql_user'} = &mysql_user($_[0]);
local $user = $_[0]->{'mysql_user'};
&mysql::execute_sql_logged($mysql::master_db, "create database $_[0]->{'db'}");
local @hosts = split(/\s+/, $config{'mysql_hosts'});
@hosts = ( 'localhost' ) if (!@hosts);
local $h;
foreach $h (@hosts) {
	&mysql::execute_sql_logged($mysql::master_db, "insert into user (host, user, password) values ('$h', '$user', password('$_[0]->{'pass'}'))");
	&mysql::execute_sql_logged($mysql::master_db, "insert into db (host, db, user, select_priv, insert_priv, update_priv, delete_priv, create_priv, drop_priv, grant_priv, references_priv, index_priv, alter_priv) values ('$h', '$_[0]->{'db'}', '$user', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'Y')");
	}
&mysql::execute_sql_logged($mysql::master_db, 'flush privileges');
&$second_print($text{'setup_done'});
}

# delete_mysql(&domain)
# Delete a mysql database, the domain's mysql user and all permissions for both
sub delete_mysql
{
&$first_print($text{'delete_mysql'});
&require_mysql();
local $user = &mysql_user($_[0]);
&mysql::execute_sql_logged($mysql::master_db, "drop database $_[0]->{'db'}");
&mysql::execute_sql_logged($mysql::master_db, "delete from user where user = '$user'");
&mysql::execute_sql_logged($mysql::master_db, "delete from db where user = '$user' or db = '$_[0]->{'db'}'");
&mysql::execute_sql_logged($mysql::master_db, 'flush privileges');
&$second_print($text{'setup_done'});
}

# modify_mysql(&domain, &olddomain)
# Changes the mysql user's password if needed
sub modify_mysql
{
&require_mysql();
local $user = &mysql_user($_[0]);
if ($_[0]->{'pass'} ne $_[1]->{'pass'}) {
	&$first_print($text{'save_mysqlpass'});
	if (&mysql_user_exists($_[0])) {
		&mysql::execute_sql_logged($mysql::master_db, "update user set password = password('$_[0]->{'pass'}') where user = '$user'");
		&mysql::execute_sql_logged($master_db, 'flush privileges');
		&$second_print($text{'setup_done'});
		return 1;
		}
	else {
		&$first_print($text{'save_nomysql'});
		}
	}
return 0;
}

# disable_mysql(&domain)
# Modifies the mysql user for this domain so that he cannot login
sub disable_mysql
{
&$first_print($text{'disable_mysqluser'});
&require_mysql();
local $user = &mysql_user($_[0]);
if ($oldpass = &mysql_user_exists($_[0])) {
	&mysql::execute_sql_logged($mysql::master_db, "update user set password = '*LK*' where user = '$user'");
	&mysql::execute_sql_logged($master_db, 'flush privileges');
	$_[0]->{'disabled_oldmysql'} = $oldpass;
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'save_nomysql'});
	}
}

# enable_mysql(&domain)
# Puts back the original password for the mysql user so that he can login again
sub enable_mysql
{
&$first_print($text{'enable_mysql'});
&require_mysql();
local $user = &mysql_user($_[0]);
if (&mysql_user_exists($_[0])) {
	if ($_[0]->{'disabled_oldmysql'}) {
		&mysql::execute_sql_logged($mysql::master_db, "update user set password = '$_[0]->{'disabled_oldmysql'}' where user = '$user'");
		delete($_[0]->{'disabled_oldmysql'});
		}
	else {
		&mysql::execute_sql_logged($mysql::master_db, "update user set password = password('$_[0]->{'pass'}') where user = '$user'");
		}
	&mysql::execute_sql($master_db, 'flush privileges');
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'save_nomysql'});
	}

}

# mysql_user_exists(&domain)
# Returns his password if a mysql user exists for the domain's user, or undef
sub mysql_user_exists
{
&require_mysql();
local $user = &mysql_user($_[0]);
local $u = &mysql::execute_sql_logged($mysql::master_db, "select password from user where user = '$user'");
return @{$u->{'data'}} ? $u->{'data'}->[0]->[0] : undef;
}

# check_mysql_clash(&domain)
# Returns 1 if some MySQL database already exists
sub check_mysql_clash
{
&require_mysql();
local @dblist = &mysql::list_databases();
return &indexof($_[0]->{'db'}, @dblist) >= 0;
}

# backup_mysql(&domain, file)
# Dumps this domain's mysql database to a backup file
sub backup_mysql
{
&$first_print($text{'backup_mysqldump'});
&require_mysql();
local $cmd = "$mysql::config{'mysqldump'} $mysql::authstr --add-drop-table".
	     (&mysql::supports_quoting() ? " --quote-names" : "").
	     " $_[0]->{'db'} 2>&1 >$_[1]";
local $out = `$cmd`;
if ($? || $out) {
	&$second_print(&text('backup_mysqldumpfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# restore_mysql(&domain, file)
# Restores this domain's mysql database from a backup file, and re-creates
# the mysql user.
sub restore_mysql
{
&$first_print($text{'restore_mysqlload'});
	{
	local $first_print = \&null_print;	# supress messages
	local $second_print = \&null_print;
	&require_mysql();

	# First clear out the database
	if (&check_mysql_clash($_[0])) {
		&delete_mysql($_[0]);
		}

	# Now re-set it up
	&setup_mysql($_[0]);
	}

# Finally, import the data
local $cmd = "$mysql::config{'mysql'} $mysql::authstr -t $_[0]->{'db'} <$_[1] 2>&1";
local $out = &backquote_logged($cmd);
if ($? || $out) {
	&$second_print(&text('restore_mysqlloadfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# mysql_user(&domain)
sub mysql_user
{
return $_[0]->{'mysql_user'} if (defined($_[0]->{'mysql_user'}));
return length($_[0]->{'user'}) > 16 ?
	  substr($_[0]->{'user'}, 0, 16) : $_[0]->{'user'};
}

1;

