sub require_postgres
{
return if ($require_postgres++);
&foreign_require("postgresql", "postgresql-lib.pl");
%qconfig = &foreign_config("postgresql");
}

# check_postgres_clash(&domain)
# Returns 1 if some PostgreSQL database already exists
sub check_postgres_clash
{
&require_postgres();
local @dblist = &postgresql::list_databases();
return &indexof($_[0]->{'db'}, @dblist) >= 0;
}

# setup_postgres(&domain)
# Create a new PostgreSQL database and user
sub setup_postgres
{
&$first_print($text{'setup_postgres'});
&require_postgres();
&postgresql::execute_sql_logged($qconfig{'basedb'}, "create database $_[0]->{'db'}");
local $pass = &postgresql::get_postgresql_version() >= 7 ? "'$_[0]->{'pass'}'"
							 : $_[0]->{'pass'};
&postgresql::execute_sql_logged($qconfig{'basedb'}, "create user \"$_[0]->{'user'}\" with password $pass nocreatedb nocreateuser");
&$second_print($text{'setup_done'});
}

# modify_postgres(&domain, &olddomain)
# Change the PostgreSQL user's password if needed
sub modify_postgres
{
&require_postgres();
if ($_[0]->{'pass'} ne $_[1]->{'pass'}) {
	&$first_print($text{'save_postgrespass'});
	local $pass = &postgresql::get_postgresql_version() >= 7 ?
			"'$_[0]->{'pass'}'" : $_[0]->{'pass'};
	&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$_[0]->{'user'}\" with password $pass");
	&$second_print($text{'setup_done'});
	}
}

# delete_postgres(&domain)
# Delete the PostgreSQL database and user
sub delete_postgres
{
&$first_print($text{'delete_postgres'});
&require_postgres();
&postgresql::execute_sql_logged($qconfig{'basedb'}, "drop database $_[0]->{'db'}");
&postgresql::execute_sql_logged($qconfig{'basedb'}, "drop user \"$_[0]->{'user'}\"");
&$second_print($text{'setup_done'});
}

# disable_postgres(&domain)
# Invalidate the domain's PostgreSQL user
sub disable_postgres
{
&$first_print($text{'disable_postgres'});
&require_postgres();
local $date = localtime(0);
&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$_[0]->{'user'}\" valid until '$date'");
&$second_print($text{'setup_done'});
}

# enable_postgres(&domain)
# Validate the domain's PostgreSQL user
sub enable_postgres
{
&$first_print($text{'enable_postgres'});
&require_postgres();
&postgresql::execute_sql_logged($qconfig{'basedb'}, "alter user \"$_[0]->{'user'}\" valid until 'Jan 1 2038'");
&$second_print($text{'setup_done'});
}

# backup_postgres(&domain, file)
# Dumps this domain's postgreSQL database to a backup file
sub backup_postgres
{
&$first_print($text{'backup_postgresdump'});
&require_postgres();
&foreign_require("proc", "proc-lib.pl");
local $pass = &tempname();
open(PASS, ">$pass");
print PASS "$postgresql::postgres_pass\n";
close(PASS);
local $cmd = $postgresql::config{'dump_cmd'}.
     ($postgresql::postgres_login ? " -U $postgresql::postgres_login" : "").
     ($postgresql::config{'host'} ? " -h $postgresql::config{'host'}" : "").
     " -F c -b -f $_[1] $_[0]->{'db'} 2>&1 <$pass";
local $out = `$cmd`;
unlink($pass);
if ($?) {
	&$second_print(&text('backup_postgresdumpfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# restore_postgres(&domain, file)
# Restores this domain's postgresql database from a backup file, and re-creates
# the postgresql user.
sub restore_postgres
{
&$first_print($text{'restore_postgresload'});
&require_postgres();
&foreign_require("proc", "proc-lib.pl");
	{
	local $first_print = \&null_print;	# supress messages
	local $second_print = \&null_print;
	&require_mysql();

	# First clear out the database
	if (&check_postgres_clash($_[0])) {
		&delete_postgres($_[0]);
		}

	# Now re-set it up
	&setup_postgres($_[0]);
	}

# Finally, import the data
local $pass = &tempname();
open(PASS, ">$pass");
print PASS "$postgresql::postgres_pass\n";
close(PASS);
local $cmd = $postgresql::config{'rstr_cmd'}.
     ($postgresql::postgres_login ? " -U $postgresql::postgres_login" : "").
     ($postgresql::config{'host'} ? " -h $postgresql::config{'host'}" : "").
     " -d $_[0]->{'db'} $_[1] <$pass 2>&1";
local $out = &backquote_logged($cmd);
unlink($pass);
if ($? || $out =~ /failed|fatal/i) {
	&$second_print(&text('restore_mysqlloadfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

1;

