#!/usr/local/bin/perl
# index.cgi
# Display a list of domains managed by this module

require './virtual-server-lib.pl';

if ($single_domain_mode) {
	# This user can edit just a single domain, so show only a menu of
	# icons for options he can use
	&header($text{'index_title2'}, "", undef, 1, 1);
	$d = &get_domain($access{'domains'});
	&domain_title($d);
	print "<hr>\n";
	@links = ( "list_users.cgi?dom=$access{'domains'}",
		   "list_aliases.cgi?dom=$access{'domains'}" );
	@titles = ( $text{'users_title'}, $text{'aliases_title'} );
	@icons = ( "images/users.gif", "images/aliases.gif" );
	&icons_table(\@links, \@titles, \@icons);
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

&header($text{'index_title'}, "", "index", 1, 1, 0,
	undef, undef, undef, &text('index_version', $module_info{'version'}));
print "<hr>\n";

# Check if server configuration has been checked
@cst = stat($module_config_file);
if ($cst[9] > $config{'last_check'}) {
	# Not since last config change .. force it now
	print "<form action=check.cgi>\n";
	print "<b>$text{'index_needcheck'}</b><p>\n";
	print "<input type=submit value='$text{'index_srefresh'}'></form>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Setup the default templates
&ensure_template("domain-template");
&ensure_template("user-template");
&ensure_template("local-template");

# Display local users
if ($config{'localgroup'} && $access{'local'}) {
	print "<h3>$text{'index_header1'}</h3>\n";
	@lusers = &list_domain_users();
	if (@lusers) {
		print "<a href='edit_user.cgi?new=1&dom=0'>",
		      "$text{'index_uadd'}</a><br>\n";
		&users_table(\@lusers);
		}
	else {
		print "<b>$text{'index_nousers'}</b><p>\n";
		}
	print "<a href='edit_user.cgi?new=1&dom=0'>",
	      "$text{'index_uadd'}</a><p>\n";
	print "<hr>\n";
	}

# Display domains
print "<h3>$text{'index_header2'}</h3>\n";
@doms = grep { &can_edit_domain($_) } &list_domains();
if ($config{'display_max'} && @doms > $config{'display_max'}) {
	# Too many domains to display, so show a search form
	print "<b>$text{'index_toomany'}</b><p>\n";
	print "<form action=search.cgi>\n";
	print "<b>$text{'index_search'}</b>\n";
	print "<select name=field>\n";
	print "<option value=dom checked>$text{'index_search_dom'}\n";
	print "<option value=user>$text{'index_search_user'}\n";
	print "<option value=ip>$text{'index_search_ip'}\n";
	print "</select> <b>$text{'index_contains'}</b>\n";
	print "<input name=what size=30>\n";
	print "<input type=submit value='$text{'index_searchok'}'></form>\n";
	}
elsif (@doms) {
	# Show domains in a table
	&create_links();
	print "<br>\n";
	&domains_table(\@doms);
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
&create_links();
print "<p>\n";

# Show icons for editing various templates
if ($master_admin) {
	print "<hr>\n";
	print "<h3>$text{'index_header3'}</h3>\n";
	@tmpls = ( $config{'web'} ? ( 'web' ) : ( ),
		   $config{'dns'} ? ( 'dns' ) : ( ),
		   $config{'ftp'} ? ( 'ftp' ) : ( ),
		   'dom', 'user',
		   $config{'localgroup'} ? ( 'local' ) : ( ) );
	@tlinks = map { "edit_new${_}.cgi" } @tmpls;
	@ttitles = map { $text{"new${_}_title"} } @tmpls;
	@ticons = map { "images/new${_}.gif" } @tmpls;
	&icons_table(\@tlinks, \@ttitles, \@ticons, scalar(@tlinks));
	}

# Show current status
if ($master_admin) {
	print "<hr>\n";
	print "<h3>$text{'index_sheader'}</h3>\n";
	print "<table width=100%>\n";

	print "<tr> <td nowrap><b>$text{'index_sfeatures'}</b></td> <td>\n";
	print join(", ", map { $text{"feature_".$_} }
		         grep { $config{$_} } @features),"</td> </tr>\n";

	@dis = grep { !$config{$_} } @opt_features;
	if (@dis) {
		print "<tr> <td nowrap><b>$text{'index_snfeatures'}</b></td> <td>\n";
		print join(", ", map { $text{"feature_".$_} }
				 @dis),"</td> </tr>\n";
		}

	print "<tr> <td nowrap><b>$text{'index_squotas'}</b></td> <td>\n";
	if (!$config{'quotas'}) {
		# Quotas manually disabled
		print "$text{'index_squotas1'}\n";
		}
	elsif ($config{'home_quotas'} &&
	       $config{'home_quotas'} eq $config{'mail_quotas'}) {
		# Both quota filesystems are the same
		print &text($config{'group_quotas'} ? 'index_squotas5g' : 'index_squotas5', "<tt>$config{'home_quotas'}</tt>"),"\n";
		}
	elsif ($config{'home_quotas'} && $config{'mail_quotas'}) {
		# Quota filesystems are different
		print &text($config{'group_quotas'} ? 'index_squotas4g' : 'index_squotas4', "<tt>$config{'home_quotas'}</tt>", "<tt>$config{'mail_quotas'}</tt>"),"\n";
		}
	elsif ($config{'home_quotas'}) {
		# Only for home
		print &text($config{'group_quotas'} ? 'index_squotas3g' : 'index_squotas3', "<tt>$config{'home_quotas'}</tt>"),"\n";
		}
	else {
		# Not active at all
		print "$text{'index_squotas2'}\n";
		}
	print "</td> </tr>\n";

	if ($config{'mail'}) {
		print "<tr nowrap> <td><b>$text{'index_smail'}</b></td> <td>\n";
		print $config{'mail_system'} == 0 ? "Postfix" :
		      $config{'mail_system'} == 1 ? "Sendmail" : "Qmail";
		print "</td> </tr>\n";
		}

	print "<tr><form action=check.cgi>\n";
	print "<td colspan=2 align=right><input type=submit value='$text{'index_srefresh'}'></td> </form></tr>\n";

	print "</table>\n";
	}

# Show backup and restore buttons
if ($master_admin) {
	print "<hr>\n";
	print "<h3>$text{'index_sheader'}</h3>\n";
	print "<table width=100%>\n";

	# Button to backup now
	print "<form action=backup_form.cgi>\n";
	print "<tr> <td><input type=submit value='$text{'index_backup'}'></td>\n";
	print "<td>$text{'index_backupdesc'}</td> </tr>\n";
	print "</form>\n";

	# Button to setup scheduled backup
	print "<form action=backup_form.cgi>\n";
	print "<input type=hidden name=sched value=1>\n";
	print "<tr> <td><input type=submit value='$text{'index_sched'}'></td>\n";
	print "<td>$text{'index_scheddesc'}</td> </tr>\n";
	print "</form>\n";

	# Button to restore
	print "<form action=restore_form.cgi>\n";
	print "<tr> <td><input type=submit value='$text{'index_restore'}'></td>\n";
	print "<td>$text{'index_restoredesc'}</td> </tr>\n";
	print "</form>\n";

	print "</table>\n";
	}

# Show start/stop buttons
if ($access{'stop'}) {
	print "<hr>\n";
	print "<table width=100%>\n";

	if ($config{'web'}) {
		$apid = &get_apache_pid();
		if (!$apid || !kill(0, $apid)) {
			# Apache is down .. offer to start it
			&ss_form("start_apache.cgi", $text{'index_astart'},
						     $text{'index_astartdesc'});
			}
		else {
			# Apache is up .. offer to stop it
			&ss_form("stop_apache.cgi", $text{'index_astop'},
						    $text{'index_astopdesc'});
			}
		}

	if ($config{'dns'}) {
		$bpid = &get_bind_pid();
		if (!$bpid || !kill(0, $bpid)) {
			# BIND is down .. offer to start it
			&ss_form("start_bind.cgi", $text{'index_bstart'},
						   $text{'index_bstartdesc'});
			}
		else {
			# BIND is up .. offer to stop it
			&ss_form("stop_bind.cgi", $text{'index_bstop'},
						  $text{'index_bstopdesc'});
			}
		}

	if ($config{'mail'}) {
		if (!&is_mail_running()) {
			# Mail server is down .. offer to start it
			&ss_form("start_mail.cgi", $text{'index_mstart'},
						   $text{'index_mstartdesc'});
			}
		else {
			# Mail server is up .. offer to stop it
			&ss_form("stop_mail.cgi", $text{'index_mstop'},
						  $text{'index_mstopdesc'});
			}
		}

	print "</table>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

sub ss_form
{
print "<form action=$_[0]> <tr>\n";
if ($_[0] =~ /^start/) {
	print "<td><img src=images/down.gif></td>\n";
	}
else {
	print "<td><img src=images/up.gif></td>\n";
	}
print "<td><input type=submit value='$_[1]'></td>\n";
print "<td>$_[2]</td> </tr></form>\n";
}

sub create_links
{
if ($access{'create'}) {
	print "<a href='domain_form.cgi'>$text{'index_add'}</a>&nbsp;\n";
	if ($access{'import'}) {
		print "<a href='import_form.cgi'>$text{'index_import'}</a>\n";
		}
	}
}

