#!/usr/local/bin/perl
# Actually restore some servers, after asking for confirmation

require './virtual-server-lib.pl';
$master_admin || &error($text{'restore_ecannot'});
&ReadParse();

# Validate inputs
&error_setup($text{'restore_err'});
if ($in{'src'}) {
	$src = $in{'src'};
	}
else {
	$src = &parse_backup_destination("src", \%in);
	}
($mode) = &parse_backup_url($src);
$mode > 0 || -r $src || -d $src || &error($text{'restore_esrc'});
@do_features = split(/\0/, $in{'feature'});
@do_features || &error($text{'restore_efeatures'});
%do_features = map { $_, 1 } @do_features;

# Parse option inputs
foreach $f (@do_features) {
	local $ofunc = "parse_restore_$f";
	if (defined(&$ofunc)) {
		$options{$f} = &$ofunc(\%in);
		}
	}

$cont = &backup_contents($src);
if (!$in{'confirm'}) {
	# See what is in the tar file or directory
	ref($cont) || &error(&text('restore_efile', $cont));
	(keys %$cont) || &error($text{'restore_enone'});
	}
else {
	# Find the selected domains
	foreach $d (split(/\0/, $in{'dom'})) {
		local $dinfo = &get_domain_by("dom", $d);
		push(@doms, $dinfo) if ($dinfo);
		}
	@doms || &error($text{'restore_edoms'});
	}

if ($in{'confirm'}) {
	$| = 1;
	$theme_no_table++;
	}
&header($text{'restore_title'}, "");
print "<hr>\n";

if (!$in{'confirm'}) {
	# Tell the user what will be done
	print "<form action=restore.cgi method=post>\n";
	print &text('restore_from', "<tt>$src</tt>"),"<p>\n";
	print "<dl>\n";
	foreach $d (sort { $a cmp $b } keys %$cont) {
		print "<dt><input type=checkbox name=dom ",
		      "value='$d' checked><b>$d</b>\n";
		@dfeats = grep { $do_features{$_} } @{$cont->{$d}};
		if (!@dfeats) {
			print "<dd><i>$text{'restore_nofeat'}</i>\n";
			}
		else {
			print "<dd>",join("<br>",
				map { $text{'backup_feature_'.$_} ||
				      $text{'feature_'.$_} } @dfeats),"\n";
			$any++;
			}
		}
	print "</dl>\n";
	if ($any) {
		# Pass all HTML inputs to program again, and show OK button
		print "<input type=hidden name=src value='",
		      &html_escape($src),"'>\n";
		foreach $i (keys %in) {
			next if ($i =~ /^src_/);
			foreach $v (split(/\0/, $in{$i})) {
				print "<input type=hidden name='$i' value='$v'>\n";
				}
			}
		print "<center><input type=submit name=confirm value='$text{'restore_now2'}'></center>\n";
		}
	else {
		print "$text{'restore_notany'}<p>\n";
		}
	print "</form>\n";
	}
else {
	# Actually execute the restore
	print "<p>",&text('restore_doing', scalar(@doms), "<tt>$src</tt>"),"<p>\n";
	$ok = &restore_domains($src, \@doms, \@do_features, \%options);
	if ($ok) {
		print &text('restore_done'),"<p>\n";
		}
	else {
		print &text('restore_failed'),"<p>\n";
		}
	&webmin_log("restore", $src, undef,
		    { 'doms' => [ map { $_->{'dom'} } @doms ] });
	}

print "<hr>\n";
&footer("", $text{'index_return'});

