#!/usr/local/bin/perl
# save_rfile.cgi
# Save an autoreply file

require './virtual-server-lib.pl';
&ReadParseMime();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'aliases_ecannot'});
$config{'edit_afiles'} || $master_admin ||
	&error($text{'rfile_ecannot'});

$in{'replies_def'} || $in{'replies'} =~ /^\/\S+/ ||
	&error($text{'rfile_ereplies'});
$in{'period_def'} || $in{'period'} =~ /^\d+$/ ||
	&error($text{'rfile_eperiod'});

&switch_to_domain_user($d);
$in{'text'} =~ s/\r//g;
&lock_file($in{'file'});
open(FILE, ">$in{'file'}") ||
	&error(&text('rfile_ewrite', $in{'file'}, $dom->{'user'}, $!));
if (!$in{'replies_def'}) {
	print FILE "Reply-Tracking: $in{'replies'}\n";
	}
if (!$in{'period_def'}) {
	print FILE "Reply-Period: $in{'period'}\n";
	}
print FILE $in{'text'};
close(FILE);
&unlock_file($in{'file'});
&webmin_log("save", "rfile", $in{'file'});

$what = $in{'alias'} ? 'alias' : 'user';
&redirect("edit_$what.cgi?$what=$in{$what}&dom=$in{'dom'}");

