#!/usr/local/bin/perl
# check.cgi
# Make sure that all enabled features are valid, and check the status of quotas

require './virtual-server-lib.pl';
&master_admin() || &error($text{'check_ecannot'});

$| = 1;
$theme_no_table++;
&header($text{'check_title'}, "");
print "<hr>\n";

&read_file("$module_config_directory/last-config", \%lastconfig);
print "<b>$text{'check_desc'}</b><p>\n";
print "<ul>\n";

$clink = "../config.cgi?$module_name";

# Make sure networking is supported
if (!&foreign_check("net")) {
	&foreign_require("net", "net-lib.pl");
	if (!defined(&net::boot_interfaces)) {
		&check_error(&text('index_enet'));
		}
	print "$text{'check_netok'}<p>\n";
	}

if ($config{'dns'}) {
	# Make sure BIND is installed
	&foreign_installed("bind8", 1) == 2 ||
		&check_error(&text('index_ebind', "/bind8/", $clink));
	print "$text{'check_bindok'}<p>\n";
	}

if ($config{'mail'}) {
	if ($config{'mail_system'} == 3) {
		# Work out which mail server we have
		if (&postfix_installed()) {
			$config{'mail_system'} = 0;
			}
		elsif (&qmail_installed()) {
			$config{'mail_system'} = 2;
			}
		elsif (&sendmail_installed()) {
			$config{'mail_system'} = 1;
			}
		else {
			&check_error(&text('index_email'));
			}
		&write_file("$module_config_directory/config", \%config);
		}
	if ($config{'mail_system'} == 1) {
		# Make sure sendmail is installed
		if (!&sendmail_installed()) {
			&check_error(&text('index_esendmail', '/sendmail/',
					   "/config.cgi?$module_name"));
			}
		# Check that aliases and virtusers are configured
		&require_mail();
		@$sendmail_afiles ||
			&check_error(&text('index_esaliases', '/sendmail/'));
		$sendmail_vdbm ||
			&check_error(&text('index_esvirts', '/sendmail/'));
		if ($config{'generics'}) {
			$sendmail_gdbm ||
		    		&check_error(&text('index_esgens',
					     '/sendmail/', $clink));
			}
		print "$text{'check_sendmailok'}<p>\n";
		}
	elsif ($config{'mail_system'} == 0) {
		# Make sure postfix is installed
		if (!&postfix_installed()) {
			&check_error(&text('index_epostfix', '/postfix/',
					   "/config.cgi?$module_name"));
			}
		# Check that aliases and virtusers are configured
		&require_mail();
		@$postfix_afiles ||
			&check_error(&text('index_epaliases', '/postfix/'));
		$virtual_maps =~ /^[a-z0-9]+:\//i ||
			&check_error(&text('index_epvirts', '/postfix/'));
		if ($config{'generics'}) {
			$canonical_maps ||
				check_error(&text('index_epgens',
					    '/postfix/', $clink));
			}
		print "$text{'check_postfixok'}<p>\n";
		}
	elsif ($config{'mail_system'} == 2) {
		# Make sure qmail is installed
		if (!&qmail_installed()) {
			&check_error(&text('index_eqmail', '/qmailadmin/',
					   "/config.cgi?$module_name"));
			}
		if ($config{'generics'}) {
			# Is this even possible for qmail?
			}
		print "$text{'check_qmailok'}<p>\n";
		}
	}

if ($config{'web'}) {
	# Make sure Apache is installed
	&foreign_installed("apache", 1) == 2 ||
		&check_error(&text('index_eapache', "/apache/", $clink));
	print "$text{'check_webok'}<p>\n";
	}

if ($config{'webalizer'}) {
	# Make sure Webalizer is installed, and that global directives are OK
	# XXX is the path checking really needed?
	$config{'web'} || &check_error(&text('check_edepwebalizer', $clink));
	&foreign_installed("webalizer", 1) == 2 ||
		&check_error(&text('index_ewebalizer', "/webalizer/", $clink));
	&foreign_require("webalizer", "webalizer-lib.pl");
	$conf = &webalizer::get_config();
	$current = &webalizer::find_value("IncrementalName", $conf);
	$history = &webalizer::find_value("HistoryName", $conf);
	if ($current =~ /^\//) {
		&check_error(&text('check_current', "/webalizer/"));
		}
	elsif ($history =~ /^\//) {
		&check_error(&text('check_history', "/webalizer/"));
		}
	else {
		print "$text{'check_webalizerok'}<p>\n";
		}
	}

if ($config{'ssl'}) {
	# Make sure openssl is installed, that Apache supports mod_ssl,
	# and that port 443 is in use
	$config{'web'} || &check_error(&text('check_edepssl', $clink));
	&has_command("openssl") ||
	    &check_error(&text('index_eopenssl', "<tt>openssl</tt>", $clink));

	&require_apache();
	local $conf = &apache::get_config();
	local @loads = &apache::find_directive_struct("LoadModule", $conf);
	local ($l, $hasmod);
	foreach $l (@loads) {
		$hasmod++ if ($l->{'words'}->[1] =~ /mod_ssl/);
		}
	local ($aver, $amods) = &apache::httpd_info();
	$hasmod++ if (&indexof("mod_ssl", @$amods) >= 0);
	$hasmod++ if ($apache::httpd_modules{'mod_ssl'});
	$hasmod ||
	    &check_error(&text('index_emodssl', "<tt>mod_ssl</tt>", $clink));

	local @listens = &apache::find_directive_struct("Listen", $conf);
	foreach $l (@listens) {
		$haslisten++ if ($l->{'words'}->[0] =~ /^(\S+:)?$web_sslport$/);
		}
	local @ports = &apache::find_directive_struct("Port", $conf);
	foreach $l (@ports) {
		$haslisten++ if ($l->{'words'}->[0] == $web_sslport);
		}
	$haslisten ||
	    &check_error(&text('index_emodssl2', $web_sslport, $clink));
	print "$text{'check_sslok'}<p>\n";
	}

if ($config{'mysql'}) {
	# Make sure MySQL is installed
	&foreign_installed("mysql", 1) == 2 ||
		&check_error(&text('index_emysql', "/mysql/", $clink));
	print "$text{'check_mysqlok'}<p>\n";
	}

if ($config{'postgres'}) {
	# Make sure PostgreSQL is installed
	&foreign_installed("postgresql", 1) == 2 ||
		&check_error(&text('index_epostgres', "/postgresql/", $clink));
	print "$text{'check_postgresok'}<p>\n";
	}

if ($config{'ftp'}) {
	# Make sure ProFTPd is installed, and that the ftp user exists
	&foreign_installed("proftpd", 1) == 2 ||
		&check_error(&text('index_eproftpd', "/proftpd/", $clink));
	$err = &check_proftpd_template();
	$err && &check_error(&text('check_proftpd', $err));
	print "$text{'check_ftpok'}<p>\n";
	}

if (!$config{'iface'}) {
	# Work out the network interface automatically
	&foreign_require("net", "net-lib.pl");
	foreach $a (&net::active_interfaces()) {
		if ($a->{'up'} && $a->{'virtual'} eq '' &&
		    &net::iface_type($a->{'name'}) =~ /ethernet/i) {
			$config{'iface'} = $a->{'fullname'};
			last;
			}
		}
	if (!$config{'iface'}) {
		&check_error(&text('index_eiface', "/config.cgi?$module_name"));
		}
	&write_file("$module_config_directory/config", \%config);
	}
print &text('check_ifaceok', "<tt>$config{'iface'}</tt>"),"<p>\n";

# Make sure local group exists
if ($config{'localgroup'} && !defined(getgrnam($config{'localgroup'}))) {
	&check_error(&text('index_elocal', "<tt>$config{'localgroup'}</tt>",
			   "/config.cgi?$module_name"));
	}

$config{'home_quotas'} = '';
$config{'mail_quotas'} = '';
$config{'group_quotas'} = '';
if ($config{'quotas'}) {
	# Make sure quotas are enabled, and work out where they are needed
	&require_useradmin();
	if (!$home_base) {
		print "<p><b>",&text('index_ehomebase'),"</b><p>\n";
		}
	else {
		&foreign_require("mount", "mount-lib.pl");
		$mail_base = &mail_system_base();
		($home_mtab, $home_fstab) = &mount_point($home_base);
		($mail_mtab, $mail_fstab) = &mount_point($mail_base);
		if (!$home_mtab) {
			print "<p><b>",&text('index_ehomemtab',
		    		"<tt>$home_base</tt>"),"</b><p>\n";
			}
		elsif (!$mail_mtab) {
			print "<p><b>",&text('index_emailmtab',
				"<tt>$mail_base</tt>"),"</b><p>\n";
			}
		else {
			# Check if quotas are enabled for home filesystem
			local $nohome;
			if (!($home_mtab->[4] = &quota::quota_can(
				$home_mtab, $home_fstab))%2 ||
			    !&quota::quota_now($home_mtab, $home_fstab)) {
				$nohome++;
				}
			else {
				if ($home_mtab->[4] >= 2) {
					# Group quotas are active too
					$config{'group_quotas'} = 1;
					}
				}

			if ($home_mtab->[0] eq $mail_mtab->[0]) {
				# Home and mail are the same filesystem
				if ($nohome) {
					# Neither are enabled
					$qerr = &text('index_equota2',
					    "<tt>$home_mtab->[0]</tt>",
					    "<tt>$home_base</tt>",
					    "<tt>$mail_base</tt>");
					}
				else {
					# Both are enabled
					$config{'home_quotas'} =
						$home_mtab->[0];
					$config{'mail_quotas'} =
						$home_mtab->[0];
					}
				}
			else {
				# Different .. so check mail too
				local $nomail;
				if (!($mail_mtab->[4] = &quota::quota_can(
					$mail_mtab, $mail_fstab)) ||
				    !&quota::quota_now($mail_mtab,
						       $mail_fstab)) {
					$nomail++;
					}
				if ($nohome) {
					$qerr = &text('index_equota3',
					    "<tt>$home_mtab->[0]</tt>",
					    "<tt>$home_base</tt>");
					}
				else {
					$config{'home_quotas'} =
						$home_mtab->[0];
					}
				if ($nomail) {
					$qerr = &text('index_equota4',
					    "<tt>$mail_mtab->[0]</tt>",
					    "<tt>$mail_base</tt>");
					}
				else {
					$config{'mail_quotas'} =
						$mail_mtab->[0];
					}
				}
			}
		}
	}
if ($qerr) {
	print "$qerr<p>\n";
	}
elsif (!$config{'group_quotas'}) {
	print "$text{'check_nogroup'}<p>\n";
	}
else {
	print "$text{'check_group'}<p>\n";
	}

# Check for FTP shells in /etc/shells
open(SHELLS, "/etc/shells");
while(<SHELLS>) {
	s/\r|\n//g;
	s/#.*$//;
	$shells{$_}++;
	}
close(SHELLS);
if ($shells{$config{'shell'}}) {
	print &text('check_eshell', "<tt>$config{'shell'}</tt>",
		    "/etc/shells"),"<p>\n";
	}
if (!$shells{$config{'ftp_shell'}}) {
	print &text('check_eftpshell', "<tt>$config{'ftp_shell'}</tt>",
		    "/etc/shells"),"<p>\n";
	}

# Check for problem module config settings
if ($config{'all_namevirtual'} && $config{'dns_ip'}) {
	&check_error(&text('check_enamevirt', $clink));
	}

$config{'last_check'} = time()+1;
$config{'disable'} =~ s/user/unix/g;	# changed since last release
&lock_file($module_config_file);
&write_file($module_config_file, \%config);
&unlock_file($module_config_file);
#&lock_file("$module_config_directory/last-config");
&write_file("$module_config_directory/last-config", \%config);
#&unlock_file("$module_config_directory/last-config");

print "</ul>\n";
print "<b>$text{'check_done'}</b><p>\n";

# See if any options effecting Webmin users have changed
$webminchanged = 0;
foreach $k (keys %config) {
	if ($k =~ /^avail_/ || $k eq 'leave_acl' ||
	    &indexof($k, @features) >= 0) {
		$webminchanged++ if ($config{$k} != $lastconfig{$k});
		}
	}

if ($webminchanged) {
	if ($config{'post_check'}) {
		# Update all Webmin users
		&modify_all_webmin();
		}
	else {
		# Just offer to update
		print "<form action=all_webmin.cgi>\n";
		print "$text{'check_needupdate'}<p>\n";
		print "<input type=submit value='$text{'check_updatenow'}'>\n";
		print "</form>\n";
		}
	}
&webmin_log("check");

print "<hr>\n";
&footer("", $text{'index_return'});

sub check_error
{
print "<p>$_[0]<p>\n";
print "</ul>\n";
print "<b>$text{'check_failed'}</b><p>\n";
print "<hr>\n";
&footer("/", $text{'index'});
exit;
}

# mount_point(dir)
# Returns both the mtab and fstab details for the parent mount for a directory
sub mount_point
{
local $dir = &resolve_links($_[0]);
local @mounts = &mount::list_mounts();
local @mounted = &mount::list_mounted();
@mounts = @mounted if (!@mounts);
foreach $m (sort { length($b->[0]) <=> length($a->[0]) } @mounted) {
	if ($dir eq $m->[0] || $m->[0] eq "/" ||
	    substr($dir, 0, length($m->[0])+1) eq "$m->[0]/") {
		local ($m2) = grep { $_->[0] eq $m->[0] } @mounts;
		if ($m2) {
			return ($m, $m2);
			}
		}
	}
&error("Failed to find mount point for $dir");
}

