#!/usr/local/bin/perl
# edit_newdns.cgi
# Display the current DNS configuration template

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newdns_ecannot'});
&header($text{'newdns_title'}, "");
print "<hr>\n";

print "<form action=save_newdns.cgi method=post enctype=multipart/form-data>\n";
print "$text{'newdns_desc'}<br>\n";
&print_subs_table("DOM", "IP");

printf "<input type=radio name=bind_replace value=0 %s> %s<br>\n",
	$config{'bind_replace'} ? "" : "checked", $text{'newdns_replace0'};
printf "<input type=radio name=bind_replace value=1 %s> %s<br>\n",
	$config{'bind_replace'} ? "checked" : "", $text{'newdns_replace1'};

print "<textarea name=bind_config rows=10 cols=70>";
print join("\n", map { &html_escape($_) }
		     split(/\t/, $config{'bind_config'}));
if ($config{'mx_server'}) {
	print "\${IF-MAIL}\n";
	$pri = 5;
	foreach $mx (split(/\s+/, $config{'mx_server'})) {
		print "@ IN MX $pri $mx\n";
		$pri += 5;
		}
	print "\${ENDIF-MAIL}\n";
	}
print "</textarea><br>\n";

print "<table>\n";

# Show view to create new domains in
&require_bind();
$conf = &bind8::get_config();
@views = &bind8::find("view", $conf);
if (@views) {
	print "<tr> <td valign=top><b>$text{'newdns_view'}</b></td>\n";
	print "<td><select name=view>\n";
	printf "<option value='' %s>%s\n",
		$config{'dns_view'} eq "" ? "selected" : "",
		$text{'newdns_noview'};
	foreach $v (@views) {
		printf "<option value=%s %s>%s\n",
			$v->{'values'}->[0],
			$config{'dns_view'} eq $v->{'values'}->[0] ? "selected" : "",
			$v->{'values'}->[0];
		}
	print "</select></td> </tr>\n";
	}

print "</table>\n";

print "<input type=submit value='$text{'save'}'>\n";
print "<input type=reset value='$text{'newweb_undo'}'>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

