#!/usr/local/bin/perl
# edit_user.cgi
# Display a form for editing or adding a user. This can be a local user,
# or a domain mailbox user

require './virtual-server-lib.pl';
&ReadParse();
if ($in{'dom'}) {
	$d = &get_domain($in{'dom'});
	&can_edit_domain($d) || &error($text{'users_ecannot'});
	}
else {
	$access{'local'} || &error($text{'users_ecannot2'});
	}
if ($in{'new'}) {
	&header($text{'user_create'}, "");
	}
else {
	&header($text{'user_edit'}, "");
	@users = &list_domain_users($d);
	($user) = grep { $_->{'user'} eq $in{'user'} } @users;
	$mailbox = $d && $d->{'user'} eq $user->{'user'};
	}
&domain_title($d) if ($d);
print "<hr>\n";

print &check_clicks_function();
print "<form action=save_user.cgi>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<input type=hidden name=dom value='$in{'dom'}'>\n";
print "<input type=hidden name=old value='$in{'user'}'>\n";

print "<table border>\n";
print "<tr $tb> <td><b>",$mailbox ? $text{'user_mheader'} :
			 $d ? $text{'user_header'} : $text{'user_lheader'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>",&hlink($text{'user_user'}, "username"),"</b></td>\n";
if ($mailbox) {
	print "<td><tt>$user->{'user'}</tt></td> </tr>\n";
	$pop3 = $user->{'user'};
	}
else {
	$pop3 = $d ? &remove_userdom($user->{'user'}, $d) : $user->{'user'};
	print "<td><input name=user size=13 value='$pop3'>",
		$d ? "\@$d->{'dom'}\n" : "\n";
	if ($pop3 ne $user->{'user'}) {
		print " ",&text('user_pop3', "<tt>$user->{'user'}</tt>");
		}
	print "</td> </tr>\n";
	print "<input type=hidden name=oldpop3 value='$pop3'>\n";
	}

print "<tr> <td><b>",&hlink($text{'user_real'}, "realname"),"</b></td>\n";
if ($mailbox) {
	print "<td>$user->{'real'}</td> </tr>\n";
	}
else {
	print "<td><input name=real size=25 value='$user->{'real'}'></td> </tr>\n";
	}

if (!$mailbox) {
	print "<tr> <td><b>",&hlink($text{'user_pass'}, "password"),"</b></td>\n";
	if ($in{'new'}) {
		print "<td><input name=pass type=password size=13></td> </tr>\n";
		}
	else {
		print "<td><input type=radio name=pass_def value=1 checked> ",
		      "$text{'user_passdef'}\n";
		print "<input type=radio name=pass_def value=0> $text{'user_passset'}\n";
		print "<input name=pass type=password size=13></td> </tr>\n";
		}
	}

if ((&master_admin() || $config{'edit_homes'}) && $d && $d->{'home'} &&
    !$mailbox) {
	# Show home directory editing field
	local $auto = $in{'new'} || $user->{'home'} eq "$d->{'home'}/$config{'homes_dir'}/$pop3";
	print "<tr> <td><b>", &hlink($text{'user_home'}, "userhome"), "</b></td>\n";
	printf "<td><input type=radio name=home_def value=1 %s> %s\n",
		$auto ? "checked" : "", $text{'user_home1'};
	printf "<input type=radio name=home_def value=0 %s> %s\n",
		$auto ? "" : "checked", &text('user_home0', "<tt>$d->{'home'}/</tt>");
	printf "<input name=home size=20 value='%s'></td> </tr>\n",
		$auto ? "" : substr($user->{'home'}, length($d->{'home'})+1);
	}

if ((&master_admin() || $config{'edit_ftp'}) && !$mailbox) {
	# Show FTP shell field
	print "<tr> <td><b>", &hlink($text{'user_ftp'}, "ftp"), "</b></td>\n";
	$ftp = $user->{'shell'} eq $config{'ftp_shell'} ? 1 :
	       $in{'new'} || $user->{'shell'} eq $config{'shell'} ? 0 : -1;
	if ($ftp < 0) {
		print "<td>",&text('user_shell', "<tt>$user->{'shell'}</tt>"),"</td>\n";
		}
	else {
		printf "<td><input type=radio name=ftp value=1 %s> %s\n",
			$ftp ? "checked" : "", $text{'yes'};
		printf "<input type=radio name=ftp value=0 %s> %s</td>\n",
			$ftp ? "" : "checked", $text{'no'};
		}
	print "</tr>\n";
	}

print "<tr> <td colspan=2><hr></td> </tr>\n";

if ($d) {
	# Show primary email address field
	print "<tr> <td><b>", &hlink($text{'user_mailbox'}, "mailbox"), "</b></td>\n";
	printf "<td><input type=radio name=mailbox value=1 %s> %s\n",
		$user->{'email'} || $in{'new'} ? "checked" : "", $text{'yes'};
	printf "<input type=radio name=mailbox value=0 %s> %s</td> </tr>\n",
		$user->{'email'} || $in{'new'} ? "" : "checked", $text{'no'};
	}

if (!$mailbox) {
	# Show quotas field(s)
	$qsame = $config{'home_quotas'} eq $config{'mail_quotas'};
	if ($config{'home_quotas'}) {
		print "<tr> <td><b>", &hlink($qsame ? $text{'user_umquota'} : $text{'user_uquota'}, "diskquota"), "</b></td>\n";
		&quota_field("quota", $user->{'quota'}, $user->{'uquota'},
			     $config{'home_quotas'});
		}
	if ($config{'mail_quotas'} && !$qsame) {
		print "<tr> <td><b>", &hlink($text{'user_mquota'}, "diskmquota"), "</b></td>\n";
		&quota_field("mquota", $user->{'mquota'}, $user->{'umquota'},
			     $config{'mail_quotas'});
		}
	}

if (!$in{'new'}) {
	local ($sz, $umf) = &mail_file_size($user);
	print "<tr> <td>",
	      &hlink("<b>$text{'user_mail'}</b>", "mailfile"),"</td>\n";
	local $link = &read_mail_link($user);
	print "<td><tt>$umf</tt>\n";
	if ($link) { print "<a href='$link'>$text{'user_read'}</a></td>\n"; }
	print "</tr>\n";
	}

print "<tr> <td valign=top>",
      &hlink("<b>$text{'user_extra'}</b>", "extraemail"),"</td>\n";
print "<td><textarea name=extra rows=5 cols=30>\n";
foreach $e (@{$user->{'extraemail'}}) {
	print "$e\n";
	}
print "</textarea></td> </tr>\n";

# Show forwarding setup for this user
print "<tr> <td colspan=2><hr></td> </tr>\n";
&alias_form($user->{'to'},
	    &hlink("<b>$text{'user_aliases'}</b>", "userdest"),
	    $d, "user", $in{'user'});

print "</table></td></tr></table>\n";

print "<table><tr>\n";
if ($in{'new'}) {
	print "<td><input type=submit value='$text{'create'}'></td>\n";
	}
else {
	print "<td><input type=submit value='$text{'save'}'></td>\n";
	print "<td><input type=submit name=delete ",
	      "value='$text{'delete'}' onClick='check_clicks(form)'></td>\n"
		if (!$mailbox);
	}
print "</table></form>\n";

print "<hr>\n";
if ($d) {
	if ($single_domain_mode) {
		&footer("list_users.cgi?dom=$in{'dom'}", $text{'users_return'},
			"", $text{'index_return2'});
		}
	else {
		&footer("list_users.cgi?dom=$in{'dom'}", $text{'users_return'},
			"edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
			"", $text{'index_return'});
		}
	}
else {
	&footer("", $text{'index_return'});
	}

# quota_field(name, value, used, filesystem)
sub quota_field
{
local @defmquota = split (/ /,$config{'defmquota'});
if (&master_admin() || $config{'edit_quota'}) {
	# Show inputs for editing quotas
	printf "<td><input type=radio name=%s_def value=1 %s> %s\n",
		$_[0], $_[1] || $in{'new'} ? "" : "checked", $text{'form_unlimit'};
	printf "<input type=radio name=%s_def value=0 %s>\n",
		$_[0], $_[1] || $in{'new'} ? "checked" : "";
	if (!$in{'new'}) {
		print &quota_input($_[0], $_[1] || "", $_[3]),"\n";
		print &text('user_used', &quota_show($_[2], $_[3])),"\n";
		}
	else {
		if ( !@defmquota or $#defmquota eq 0 ) {
			print &quota_input($_[0], $config{'defmquota'} || "", $_[3]),"\n";
		} else {
			print "<select name=$_[0]>\n";
			foreach $i (@defmquota) {
				chomp $i;
				print "<option value=\"$i\">$i</option>\n";
			}
			print "<option value=\"-1\">$text{'other'}</option></select>\n";
			print "<input name=other$_[0] size=15> $text{'form_b'}\n";
			}
		}
	print "</td> </tr>\n";
	}
else {
	# Just show current settings, or default
	print "<td>";
	local $q = $in{'new'} ? $defmquota[0] : $_[1];
	print ($q ? &quota_show($q, $_[3]) : $text{'form_unlimit'}),"\n";
	print &text('user_used', &quota_show($_[2], $_[3])) if (!$in{'new'});
	print "</td> </tr>\n";
	}
}

