#!/usr/local/bin/perl
# list_aliases.cgi
# Display users and aliases in a domain

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'aliases_ecannot'});
@aliases = &list_domain_aliases($d);
&header($text{'aliases_title'}, "");
&domain_title($d);
print "<hr>\n";

if (@aliases) {
	print "<a href='edit_alias.cgi?new=1&dom=$in{'dom'}'>",
	      "$text{'aliases_add'}</a><br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'aliases_name'}</b></td> ",
	      "<td><b>$text{'aliases_domain'}</b></td> ",
	      "<td><b>$text{'aliases_dests'}</b></td> </tr>\n";
	foreach $a (@aliases) {
		$name = $a->{'from'};
		$name =~ s/\@\S+$//;
		$name = "<i>$text{'alias_catchall'}</i>" if ($name eq "");
		print "<tr $cb>\n";
		print "<td valign=top><a href='edit_alias.cgi?dom=$in{'dom'}&",
		      "alias=$a->{'from'}'>$name</a></td>\n";
		print "<td valign=top>",$d->{'dom'},"</td>\n";
		print "<td>\n";
		foreach $v (@{$a->{'to'}}) {
			($anum, $astr) = &alias_type($v);
			print &text("aliases_type$anum",
			    "<tt>".&html_escape($astr)."</tt>"),"<br>\n";
			}
		if (!@{$a->{'to'}}) { print "<i>$text{'aliases_dnone'}</i>\n"; }
		print "</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'aliases_none'}</b><p>\n";
	}
print "<a href='edit_alias.cgi?new=1&dom=$in{'dom'}'>",
      "$text{'aliases_add'}</a><p>\n";

print "<hr>\n";
if ($single_domain_mode) {
	&footer("", $text{'index_return2'});
	}
else {
	&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		"", $text{'index_return'});
	}

