#!/usr/local/bin/perl
# newkey.cgi
# Install a new SSL cert and key

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});

# Validate inputs
&error_setup($text{'newkey_err'});
$in{'cert'} =~ /BEGIN CERTIFICATE/ &&
  $in{'cert'} =~ /END CERTIFICATE/ || &error($text{'newkey_ecert'});
$in{'newkey'} =~ /BEGIN RSA PRIVATE KEY/ &&
  $in{'newkey'} =~ /END RSA PRIVATE KEY/ || &error($text{'newkey_enewkey'});

&header($text{'newkey_title'}, "");
&domain_title($d);
print "<hr>\n";

# Make sure Apache is setup to use the right key files
&require_apache();
$conf = &apache::get_config();
($virt, $vconf) = &get_apache_virtual($d->{'dom'},
                                      $d->{'web_sslport'});
$d->{'ssl_cert'} ||= "$d->{'home'}/ssl.cert";
$d->{'ssl_key'} ||= "$d->{'home'}/ssl.key";
&lock_file($virt->{'file'});
&apache::save_directive("SSLCertificateFile", [ $d->{'ssl_cert'} ],
			$vconf, $conf);
&apache::save_directive("SSLCertificateKeyFile", [ $d->{'ssl_key'} ],
			$vconf, $conf);
&flush_file_lines();
&unlock_file($virt->{'file'});

# Save the cert and private keys
&$first_print($text{'newkey_saving'});
&lock_file($d->{'ssl_cert'});
unlink($d->{'ssl_cert'});
open(CERT, ">$d->{'ssl_cert'}");
$in{'cert'} =~ s/\r//g;
print CERT $in{'cert'};
close(CERT);
chown($d->{'uid'}, $d->{'ugid'}, $d->{'ssl_cert'});
chmod(0755, $d->{'ssl_cert'});
&unlock_file($d->{'ssl_cert'});

&lock_file($d->{'ssl_key'});
unlink($d->{'ssl_key'});
open(CERT, ">$d->{'ssl_key'}");
$in{'newkey'} =~ s/\r//g;
print CERT $in{'newkey'};
close(CERT);
chown($d->{'uid'}, $d->{'ugid'}, $d->{'ssl_key'});
chmod(0755, $d->{'ssl_key'});
&unlock_file($d->{'ssl_key'});
&$second_print($text{'setup_done'});

# Remove the new private key we just installed
if ($d->{'ssl_newkey'}) {
	$newkeyfile = `cat $d->{'ssl_newkey'}`;
	if ($newkeyfile eq $in{'newkey'}) {
		unlink($d->{'ssl_newkey'});
		delete($d->{'ssl_newkey'});
		&save_domain($d);
		}
	}

# Re-start Apache
&register_post_action(\&restart_apache, 1);
&run_post_actions();
&webmin_log("newkey", "domain", $d->{'dom'}, $d);

print "<hr>\n";
&footer("cert_form.cgi?dom=$in{'dom'}", $text{'cert_return'},
	"edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

