#!/usr/local/bin/perl
# edit_limits.cgi
# Display access control and usage limits for this domain's user

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} == 1 && &can_edit_domain($d) || &error($text{'edit_ecannot'});

# Validate and store inputs
&error_setup($text{'limits_err'});
$in{'mailboxlimit_def'} || $in{'mailboxlimit'} =~ /^[1-9]\d*$/ ||
	&error($text{'setup_emailboxlimit'});
$d->{'mailboxlimit'} = $in{'mailboxlimit_def'} ? undef : $in{'mailboxlimit'};
$in{'domslimit_def'} || $in{'domslimit'} =~ /^\d+$/ ||
	&error($text{'limit_edoms'});
$d->{'domslimit'} = $in{'domslimit_def'} == 1 ? undef :
		    $in{'domslimit_def'} == 2 ? "*" : $in{'domslimit'};
%sel_features = map { $_, 1 } split(/\0/, $in{'features'});
foreach $f (@opt_features) {
	next if ($f eq "webmin");	# makes no sense for subdomains
	$d->{"limit_".$f} = $sel_features{$f};
	}

# Update files
$first_print = $second_print = $indent_print = $outdent_print = \&null_print;
&save_domain($d);
&modify_webmin($d, $d);
&run_post_actions();
&webmin_log("limits", "domain", $d->{'dom'}, $d);

&redirect("edit_domain.cgi?dom=$in{'dom'}");

