#!/usr/local/bin/perl
# save_newdns.cgi
# Update the BIND configuration template

require './virtual-server-lib.pl';
&master_admin() || &error($text{'newdns_ecannot'});
&ReadParseMime();
&error_setup($text{'newdns_err'});
&require_bind();

# Parse and save records
$in{'bind_config'} =~ s/\r//g;
$in{'bind_config'} =~ s/\t/ /g;
$config{'bind_config'} = join("\t", split(/\n/, $in{'bind_config'}));
$config{'bind_replace'} = $in{'bind_replace'};
delete($config{'mx_server'});

$fakeip = "1.2.3.4";
$fakedom = "foo.com";
$recs = &substitute_template(
	join("\n", split(/\t+/, $config{'bind_config'}))."\n",
	{ 'ip' => $fakeip,
	  'dom' => $fakedom });
$temp = &tempname();
open(TEMP, ">$temp");
print TEMP $recs;
close(TEMP);
$bind8::config{'short_names'} = 0;	# force canonicalization
$bind8::config{'chroot'} = '/';		# turn off chroot for temp path
@recs = &bind8::read_zone_file($temp, $fakedom);
unlink($temp);
foreach $r (@recs) {
	$soa++ if ($r->{'name'} eq $fakedom."." &&
		   $r->{'type'} eq "SOA");
	$ns++ if ($r->{'name'} eq $fakedom."." &&
		  $r->{'type'} eq "NS");
	$dom++ if ($r->{'name'} eq $fakedom."." &&
		   ($r->{'type'} eq "A" || $r->{'type'} eq "MX"));
	$www++ if ($r->{'name'} eq "www.".$fakedom."." &&
		   $r->{'type'} eq "A");
	}

if ($config{'bind_replace'}) {
	# Make sure an SOA and NS records exist
	$soa == 1 || &error($text{'newdns_esoa'});
	$ns || &error($text{'newdns_ens'});
	$dom || &error($text{'newdns_edom'});
	$www || &error($text{'newdns_ewww'});
	}
else {
	# Make sure SOA doesn't exist
	$soa && &error($text{'newdns_esoa2'});
	}

# Save view
$config{'dns_view'} = $in{'view'};

&lock_file($module_config_file);
$config{'last_check'} = time()+1;	# no need for check.cgi to be run
&write_file($module_config_file, \%config);
&unlock_file($module_config_file);
&webmin_log("newdns");
&redirect("");

