#!/usr/local/bin/perl
# save_user.cgi
# Create, update or delete a user

require './virtual-server-lib.pl';
&ReadParse();
if ($in{'dom'}) {
	$d = &get_domain($in{'dom'});
	&can_edit_domain($d) || &error($text{'users_ecannot'});
	}
else {
	$access{'local'} || &error($text{'users_ecannot2'});
	}
@users = &list_domain_users($d);
if (!$in{'new'}) {
	# Lookup user details
	($user) = grep { $_->{'user'} eq $in{'old'} } @users;
	$user || &error("User does not exist!");
	%old = %$user;
	$mailbox = $d && $d->{'user'} eq $user->{'user'};
	}
&error_setup($text{'user_err'});

&build_taken(\%taken, \%utaken);

if ($in{'delete'}) {
	if ($in{'confirm'}) {
		# Get rid of his mail file
		$mailbox && &error($text{'user_edelete'});
		&delete_mail_file($user);

		# Delete the user, his virtusers and aliases
		&delete_user($user, $d);

		# Delete home dir
		&system_logged("rm -rf '$user->{'home'}'")
		  if (-d $user->{'home'} && $user->{'home'} ne "/");

		$user->{'dom'} = $d->{'dom'};
		&run_post_actions();
		&webmin_log("delete", "user",
			    &remove_userdom($user->{'user'}, $d), $user);
		}
	else {
		# Confirm deletion first
		&header($text{'user_delete'}, "");
		&domain_title($d) if ($d);
		print "<hr>\n";

		print &check_clicks_function();
		print "<form action=save_user.cgi>\n";
		print "<input type=hidden name=dom value='$in{'dom'}'>\n";
		print "<input type=hidden name=old value='$in{'old'}'>\n";
		print "<input type=hidden name=delete value=1>\n";
		local ($mailsz) = &mail_file_size($user);
		local ($homesz) = &disk_usage_kb($user->{'home'});
		print "<p>",&text('user_rusure', "<tt>$in{'old'}</tt>",
			  	  &nice_size($mailsz),
				  &nice_size($homesz*1024),
				  "<tt>$user->{'home'}</tt>"),"<p>\n";
		print "<center><input type=submit name=confirm ",
		      "value='$text{'user_deleteok'}' ",
		      "onClick='check_clicks(form)'></center>\n";
		print "</form>\n";

		print "<hr>\n";
		if ($d) {
			&footer("list_users.cgi?dom=$in{'dom'}",
				$text{'users_return'});
			}
		else {
			&footer("", $text{'index_return'});
			}
		exit;
		}
	}
else {
	# Verify inputs
	local ($mcount, $mmax) = &count_mailboxes($d);
	if ($in{'new'} && $d && $mmax && $mcount >= $mmax) {
		&error($text{'user_emailboxlimit'});
		}
	if (!$mailbox) {
		$in{'user'} = lc($in{'user'});
		$in{'user'} =~ /^[^ \t:]+$/ || &error($text{'user_euser'});
		$in{'real'} =~ /^[^:]*$/ || &error($text{'user_ereal'});
		$user->{'real'} = $in{'real'};
		if ($in{'pass_def'}) {
			$user->{'passmode'} = 4;
			}
		else {
			$user->{'pass'} =
				&useradmin::encrypt_password($in{'pass'});
			$user->{'plainpass'} = $in{'pass'};
			$user->{'passmode'} = 3;
			&set_pass_change($user);
			}
		$qsame = $config{'mail_quotas'} eq $config{'home_quotas'};
		$qedit = &master_admin() || $config{'edit_quota'};
		if ($config{'home_quotas'} && $qedit) {
			if ( $in{'quota'} eq -1 ) {
				$in{'quota'} = $in{'otherquota'};
				}
			$in{'quota_def'} || $in{'quota'} =~ /^\d+$/ ||
				&error($text{'user_equota'});
			}
		if ($config{'mail_quotas'} && !$qsame && $qedit) {
			if ( $in{'mquota'} eq -1 ) {
				$in{'mquota'} = $in{'othermquota'};
				}
			$in{'mquota_def'} || $in{'mquota'} =~ /^\d+$/ ||
				&error($text{'user_equota'});
			}
		}
	@extra = split(/\s+/, $in{'extra'});
	foreach $e (@extra) {
		$e = lc($e);
		if ($d && $e =~ /^([^\@ \t]+$)$/) {
			$e = "$e\@$d->{'dom'}";
			}
		if ($e !~ /^(\S*)\@(\S+)$/) {
			&error(&text('user_eextra1', $e));
			}
		local ($eu, $ed) = ($1, $2);
		local $edom = &get_domain_by("dom", $ed);
		$edom && $edom->{'mail'} || &error(&text('user_eextra2', $ed));
		&can_edit_domain($edom) || &error(&text('user_eextra3', $ed));
		}
	@values = &parse_alias();
	$user->{'to'} = @values ? \@values : undef;
	$eu = $mailbox ? $d->{'user'} : $in{'user'};
	if ($d) {
		$user->{'email'} = $in{'mailbox'} ? $eu."\@".$d->{'dom'}
						  : undef;
		}
	$user->{'extraemail'} = \@extra;

	if (!$mailbox) {
		# Find home
		if ((&master_admin() || $config{'edit_homes'}) &&
		    $d && $d->{'home'} && !$in{'home_def'}) {
			$in{'home'} =~ /^\S+$/ && $in{'home'} !~ /\.\./ ||
				&error($text{'user_ehome'});
			# Custom home directory for mailbox user
			$home = "$d->{'home'}/$in{'home'}";
			}
		elsif ($d) {
			# Auto home directory for mailbox user
			$home = "$d->{'home'}/$config{'homes_dir'}/$in{'user'}";
			}
		else {
			# Auto home directory for local user
			$home = &useradmin::auto_home_dir(
				$home_base, $in{'user'}, $config{'localgroup'});
			}
		}

	# Create or update the user
	if ($in{'new'}) {
		# Set new user parameters
		$user->{'uid'} = &allocate_uid(\%taken);
		$user->{'gid'} = $d ? $d->{'gid'} :
				      getgrnam($config{'localgroup'});
		if (&master_admin() || $config{'edit_ftp'}) {
			# Shell can be set based on FTP flag
			$user->{'shell'} = $in{'ftp'} ? $config{'ftp_shell'}
						      : $config{'shell'};
			}
		elsif ($in{'new'}) {
			# For new users, shell is always non-FTP
			$user->{'shell'} = $config{'shell'};
			}
		$user->{'home'} = $home;
		if ($utaken{$in{'user'}} || ($d && $config{'append'})) {
			# Need to append domain name
			if ($d) {
				# Add group name
				$user->{'user'} = &userdom_name($in{'user'},$d);
				}
			else {
				# No domain to add, so give up!
				&error($text{'user_eclash2'});
				}
			}
		else {
			$user->{'user'} = $in{'user'};
			}
		$user->{'passmode'} = 3;
		$user->{'plainpass'} = $in{'pass'};

		if ($d) {
			# Check for a clash in this domain
			if ($utaken{$user->{'user'}} ||
			    &check_clash($in{'user'}, $d->{'dom'})) {
				&error($text{'user_eclash'});
				}
			}

		# Check if any extras clash
		foreach $e (@extra) {
			$e =~ /^(\S*)\@(\S+)$/;
			if (&check_clash($1, $2)) {
				&error(&text('user_eextra4', $e));
				}
			}

		# Check if the name is too long
		if ($lerr = &too_long($user->{'user'})) {
			&error($lerr);
			}

		# Check if home directory already exists
		if (-e $home) {
			&error(&text('user_emkhome', $home));
			}

		# Create the user and virtusers and alias
		&create_user($user, $d);

		# Create his homedir
		&system_logged("mkdir -p '$home'");
		&system_logged("chown $user->{'uid'}:$user->{'gid'} '$home'");
		&system_logged("chmod 755 '$home'");

		# Copy files into homedir
		&copy_skel_files($config{'mail_skel'}, $user);

		# Create an empty mail file
		&create_mail_file($user);

		# Send an email upon creation
		@erv = &send_user_email($d, $user);
		}
	else {
		# Check if any extras clash
		%oldextra = map { $_, 1 } @{$old{'extraemail'}};
		foreach $e (@extra) {
			$e =~ /^(\S*)\@(\S+)$/;
			if (!$oldextra{$e} && &check_clash($1, $2)) {
				&error(&text('user_eextra4', $e));
				}
			}

		# For any user except the domain owner, update his home and shel
		if (!$mailbox) {
			# Check if new homedir exists
			if (-e $home && $user->{'home'} ne $home) {
				&error(&text('user_emkhome', $home));
				}

			# Update user parameters (handle rename and .group)
			if ($in{'user'} ne $in{'oldpop3'}) {
				# Has been renamed .. check for a username clash
				if ($d && ($utaken{$in{'user'}} ||
					   $config{'append'})) {
					# New name has to include group
					$user->{'user'} =
						&userdom_name($in{'user'}, $d);
					}
				else {
					# Can rename without the dot
					$user->{'user'} = $in{'user'};
					}

				# Check if the name is too long
				if ($lerr = &too_long($user->{'user'})) {
					&error($lerr);
					}

				# Check for a virtuser clash too
				if ($d && &check_clash($in{'user'},
						       $d->{'dom'})) {
					&error($text{'user_eclash'});
					}

				# Rename his mail file
				&rename_mail_file($user, $in{'old'});
				}

			# Rename homedir
			if ($user->{'home'} ne $home && -d $user->{'home'}) {
				&system_logged("mv '$user->{'home'}' '$home'");
				$user->{'home'} = $home;
				}

			# Update shell
			if (defined($in{'ftp'})) {
				$user->{'shell'} = $in{'ftp'} ?
					$config{'ftp_shell'} :
					$config{'shell'};
				}
			}

		# Update the user and any virtusers and aliases
		&modify_user($user, \%old, $d);
		}

	if (!$mailbox && ($qedit || $in{'new'})) {
		# Actually update quotas, if allowed
		@defmquota = split (/ /,$config{'defmquota'});
		if ($config{'home_quotas'}) {
			# Set his home directory quota
			&set_quota($user->{'user'}, $config{'home_quotas'},
			   !$qedit ? $defmquota[0] :
			    $in{'quota_def'} ? 0 :
				&quota_parse('quota', $config{'home_quotas'}));
			}
		if ($config{'mail_quotas'} && !$qsame) {
			# Set his home directory quota
			&set_quota($user->{'user'}, $config{'mail_quotas'},
			   !$qedit ? $defmquota[0] :
			   $in{'mquota_def'} ? 0 :
				&quota_parse('mquota', $config{'mail_quotas'}));
			}
		}

	&run_post_actions();
	$user->{'dom'} = $d->{'dom'};
	&webmin_log($in{'new'} ? "create" : "modify", "user",
		    &remove_userdom($user->{'user'}, $d), $user);
	}
&redirect($d ? "list_users.cgi?dom=$in{'dom'}" : "index.cgi");

