
do 'virtual-server-lib.pl';

# useradmin_create_user(&details)
# Does nothing
sub useradmin_create_user
{
}

# useradmin_delete_user(&details)
# Does nothing (though maybe could delete the domain)
sub useradmin_delete_user
{
}

# useradmin_modify_user(&details)
# If the domain user's password is being changed, update it in the domain's
# file as well
sub useradmin_modify_user
{
if ($_[0]->{'passmode'} == 3) {
	local @doms = &list_domains();
	local ($d) = grep { $_->{'user'} eq $_[0]->{'user'} } @doms;
	if ($d) {
		# User is for a virtualmin domain
		$first_print = $second_print = \&null_print;
		$oldd = { %$d };
		$d->{'pass'} = $_[0]->{'plainpass'};
		if ($d->{'disabled'}) {
			# Clear any saved passwords, as they should
			# be reset at this point
			$d->{'disabled_oldpass'} = $_[0]->{'pass'};
			$d->{'disabled_mysqlpass'} = undef;
			$d->{'disabled_postgrespass'} = undef;
			}
		if ($d->{'mysql'} && $config{'mysql'}) {
			&require_mysql();
			if (!$mconfig{'sync_modify'}) {
				# Need to update password in MySQL db as well
				&modify_mysql($d, $oldd);
				}
			}
		if ($d->{'postgres'} && $config{'postgres'}) {
			&require_postgres();
			if (!$qconfig{'sync_modify'}) {
				# Need to update password in PostgreSQL db too
				&modify_postgres($d, $oldd);
				}
			}
		&modify_webmin($d, $oldd);  # so that acl passwords are updated
		&save_domain($d);
		}
	}
}

sub null_print
{
}

