#!/usr/local/bin/perl
# edit_unix.cgi
# Choose a user whose permissions will be used for logins that don't
# match any webmin user, but have unix accounts

require './acl-lib.pl';
$access{'unix'} && $access{'create'} && $access{'delete'} ||
	&error($text{'unix_ecannot'});
&ui_print_header(undef, $text{'unix_title'}, "");

print "$text{'unix_desc'}<p>\n";
&get_miniserv_config(\%miniserv);

print "<form action=save_unix.cgi>\n";
print "<table>\n";

print "<tr> <td colspan=2>\n";
printf "<input type=radio name=unix_def value=1 %s> %s<br>\n",
	$miniserv{'unixauth'} ? '' : 'checked', $text{'unix_def'};
printf "<input type=radio name=unix_def value=0 %s> %s\n",
	$miniserv{'unixauth'} ? 'checked' : '', $text{'unix_user'};
print "<select name=user>\n";
foreach $u (&list_users()) {
	printf "<option %s>%s\n",
		$miniserv{'unixauth'} eq $u->{'name'} ? 'selected' : '',
		$u->{'name'};
	}
print "</select></td> </tr>\n";

print "<tr> <td></td> </tr>\n";

print "<tr> <td valign=top>\n";
printf "<input type=radio name=access value=0 %s>\n",
	$miniserv{"allowusers"} || $miniserv{"denyusers"} ? "" : "checked";
print "$text{'unix_all'}<br>\n";
printf "<input type=radio name=access value=1 %s>\n",
	$miniserv{"allowusers"} ? "checked" : "";
print "$text{'unix_allow'}<br>\n";
printf "<input type=radio name=access value=2 %s>\n",
	$miniserv{"denyusers"} ? "checked" : "";
print "$text{'unix_deny'}<br>\n";
print "</td> <td valign=top>\n";
printf "<textarea name=users rows=6 cols=30>%s</textarea></td> </tr>\n",
 $miniserv{"allowusers"} ? join("\n", split(/\s+/, $miniserv{"allowusers"})) :
 $miniserv{"denyusers"} ? join("\n", split(/\s+/, $miniserv{"denyusers"})) : "";

print "<tr> <td colspan=2>\n";
printf "<input type=checkbox name=shells_deny value=1 %s> %s\n",
	$miniserv{'shells_deny'} ? "checked" : "",$text{'unix_shells'};
printf "<input name=shells size=25 value='%s'> %s</td> </tr>\n",
	$miniserv{'shells_deny'} || "/etc/shells",
	&file_chooser_button("shells");

print "</table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

&ui_print_footer("", $text{'index_return'});

