#!/usr/local/bin/perl
# edit_cron.cgi
# Edit an existing or new cron job

require './cron-lib.pl';
&ReadParse();

if (!$in{'new'}) {
	@jobs = &list_cron_jobs();
	$job = $jobs[$in{'idx'}];
	&can_edit_user(\%access, $job->{'user'}) ||
		&error($text{'edit_ecannot'});
	&ui_print_header(undef, $text{'edit_title'}, "");
	}
else {
	&ui_print_header(undef, $text{'create_title'}, "");
	$job = { 'mins' => '*',
		 'hours' => '*',
		 'days' => '*',
		 'months' => '*',
		 'weekdays' => '*',
		 'active' => 1 };
	}

print "<form action=save_cron.cgi>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_details'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
if ($access{'mode'} == 1) {
	print "<td><select name=user>\n";
	foreach $u (split(/\s+/, $access{'users'})) {
		printf "<option %s>$u\n",
			$job->{'user'} eq $u ? "selected" : "";
		}
	print "</select></td>\n";
	}
elsif ($access{'mode'} == 3) {
	print "<td><tt>$remote_user</tt></td>\n";
	print "<input type=hidden name=user value='$remote_user'>\n";
	}
else {
	print "<td><input name=user size=8 value=\"$job->{'user'}\"> ",
		&user_chooser_button("user", 0),"</td>\n";
	}

print "<td> <b>$text{'edit_active'}</b></td>\n";
printf "<td><input type=radio name=active value=1 %s> $text{'yes'}\n",
	$job->{'active'} ? "checked" : "";
printf "<input type=radio name=active value=0 %s> $text{'no'}</td> </tr>\n",
	$job->{'active'} ? "" : "checked";

$rpd = &is_run_parts($job->{'command'});
if ($rpd) {
	# run-parts command.. just show scripts that will be run
	print "<tr> <td valign=top><b>$text{'edit_commands'}</b></td>\n";
	print "<td><tt>",join("<br>",&expand_run_parts($rpd)),
	      "</tt></td> </tr>\n";
	print "<input type=hidden name=cmd value='$job->{'command'}'>\n";
	}
elsif (!$access{'command'}) {
	# Just show command, which cannot be edited
	print "<tr> <td><b>$text{'edit_command'}</b></td>\n";
	print "<td colspan=3><tt>$job->{'command'}</tt></td> </tr>\n";
	}
else {
	# Normal cron job.. can edit command
	$job->{'command'} =~ s/\\%/\0/g;
	@lines = split(/%/ , $job->{'command'});
	foreach (@lines) { s/\0/%/g; }
	print "<tr> <td><b>$text{'edit_command'}</b></td>\n";
	print "<td colspan=3><input name=cmd size=50 ",
	      "value='",&html_escape($lines[0]),"'></td> </tr>\n";

	if ($config{'cron_input'}) {
		print "<tr> <td valign=top><b>$text{'edit_input'}</b></td>\n";
		print "<td colspan=3><textarea name=input rows=3 cols=50>",
		      join("\n" , @lines[1 .. @lines-1]),"</textarea></td> </tr>\n";
		}
	}

print "</table></td></tr></table><p>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td colspan=5><b>$text{'edit_when'}</b></td> </tr>\n";
&show_times_input($job);
print "</table>\n";

if (!$in{'new'}) {
	print "<table width=100%>\n";
	print "<tr> <td align=left width=33%><input type=submit value=\"$text{'save'}\"></td>\n";
	if (!$rpd) {
		print "</form><form action=\"exec_cron.cgi\">\n";
		print "<input type=hidden name=idx value=\"$in{'idx'}\">\n";
		print "<td align=center width=33%>",
		      "<input type=submit value=\"$text{'edit_run'}\"></td>\n";
		}
	if ($access{'delete'}) {
		print "</form><form action=\"delete_cron.cgi\">\n";
		print "<input type=hidden name=idx value=\"$in{'idx'}\">\n";
		print "<td align=right width=33%><input type=submit value=\"$text{'delete'}\"></td> </tr>\n";
		}
	else {
		print "<td align=right width=33%></td>\n";
		}
	print "</form></table><p>\n";
	}
else {
	print "<input type=submit value=\"$text{'create'}\"></form><p>\n";
	}

&ui_print_footer("", $text{'index_return'});

