#!/usr/local/bin/perl
# change_os.cgi
# Change OS settings

require './webmin-lib.pl';
&ReadParse();

&lock_file("$config_directory/config");
if ($in{'update'}) {
	%osinfo = &detect_operating_system();
	$gconfig{'real_os_type'} = $osinfo{'real_os_type'};
	$gconfig{'real_os_version'} = $osinfo{'real_os_version'};
	$gconfig{'os_type'} = $osinfo{'os_type'};
	$gconfig{'os_version'} = $osinfo{'os_version'};
	}
$gconfig{'path'} = join(":", split(/[\r\n]+/, $in{'path'}));
$gconfig{'ld_path'} = join(":", split(/[\r\n]+/, $in{'ld_path'}));
&write_file("$config_directory/config", \%gconfig);
&unlock_file("$config_directory/config");

&lock_file($ENV{'MINISERV_CONFIG'});
&get_miniserv_config(\%miniserv);
foreach $e (keys %miniserv) {
	delete($miniserv{$e}) if ($e =~ /^env_(\S+)$/ &&
				  $1 ne "WEBMIN_CONFIG" && $1 ne "WEBMIN_VAR");
	}
for($i=0; defined($n = $in{"name_$i"}); $i++) {
	next if (!$n);
	$miniserv{'env_'.$n} = $in{"value_$i"}
		if ($n ne "WEBMIN_CONFIG" && $n ne "WEBMIN_VAR");
	}
&put_miniserv_config(\%miniserv);
&unlock_file($ENV{'MINISERV_CONFIG'});
&restart_miniserv();

&webmin_log("os", undef, undef, \%in);
&redirect("");
