#!/usr/local/bin/perl
# run.cgi
# Run some command with the given parameters

require './custom-lib.pl';
$theme_no_table = 1;
&foreign_require("proc", "proc-lib.pl");
if ($ENV{'CONTENT_TYPE'} =~ /multipart\/form-data/i) {
	&ReadParseMime();
	}
else {
	&ReadParse();
	}
$| = 1;
&error_setup($text{'run_err'});
@cmds = &list_commands();
$cmd = $cmds[$in{'idx'}];
&can_run_command($cmd) || &error($text{'run_ecannot'});
if (&supports_users()) {
	$user = $cmd->{'user'} eq '*' ? $remote_user : $cmd->{'user'};
	@user_info = getpwnam($user);
	@user_info || &error(&text('run_ecmduser', $user));
	}
else {
	@user_info = ( "root", undef, 0, 0 );
	}

# substitute parameters into command
($env, $export, $str, $displaystr) = &set_parameter_envs(
					$cmd, $cmd->{'cmd'}, \@user_info);

# Run and display output
&ui_print_unbuffered_header($cmd->{'desc'}, $text{'run_title'}, "", -d "help" ? "run" : undef);
if ($cmd->{'noshow'}) {
	print "<p>$text{'run_out2'}\n";
	}
else {
	print "<p>",&text('run_out',
			  "<tt>".&html_escape($displaystr)."</tt>"),"\n";
	}
print "<pre>" if (!$cmd->{'raw'});
&clean_environment() if ($cmd->{'clear'});
if ($cmd->{'su'}) {
	$temp = &transname();
	&open_tempfile(TEMP, ">$temp");
	&print_tempfile(TEMP, "#!/bin/sh\n");
	&print_tempfile(TEMP, $env);
	&print_tempfile(TEMP, "export $export\n") if ($export);
	&print_tempfile(TEMP, "$str\n");
	&close_tempfile(TEMP);
	chmod(0755, $temp);
	$shell = $config{'su_shell'} ? "-s /bin/sh" : "";
	$got = &foreign_call("proc", "safe_process_exec",
	   		     "su - $user $shell -c $temp", 0, 0,
			     STDOUT, undef, !$cmd->{'raw'}, 0,
			     $cmd->{'timeout'});
	unlink($temp);
	}
else {
	$got = &foreign_call("proc", "safe_process_exec", $str,
			     $user_info[2], undef, STDOUT, undef,
			     !$cmd->{'raw'}, 0, $cmd->{'timeout'});
	}
&reset_environment() if ($cmd->{'clear'});
&additional_log('exec', undef, $displaystr);
if (!$got) { print "<i>$text{'run_noout'}</i>\n"; }
print "</pre>\n" if (!$cmd->{'raw'});
if ($proc::safe_process_exec_timeout) {
	print "<b>",&text('run_timeout', $cmd->{'timeout'}),"</b><p>\n";
	}
%cmdin = ( %$cmd, %in );
&webmin_log("exec", "command", $cmd->{'id'}, \%cmdin);
unlink(@unlink) if (@unlink);
&ui_print_footer("", $text{'index_return'});

