# =============================================================================
#  Copyright (c) 2003-2005 by FlashCode <flashcode@flashtux.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#  fete.pl (c) Dcembre 2003 par FlashCode <flashcode@flashtux.org>
#  Mis  jour le 04/06/2005, FlashCode <flashcode@flashtux.org>
#
#  Gestion des ftes du calendrier franais avec la commande "/fete"
#  Syntaxe: /fete          - affiche la fte du jour et du lendemain
#           /fete prenom   - cherche un prnom dans le calendrier
# =============================================================================

use locale;

my $version = "0.4";
weechat::register ("Fete", $version, "", "Gestion des ftes du calendrier franais");
weechat::print ("Script 'Fete' $version charg");
weechat::add_command_handler ("fete", fete);

@noms_jours = qw(Dimanche Lundi Mardi Mercredi Jeudi Vendredi Samedi);
@noms_mois = qw(Janvier Fvrier Mars Avril Mai Juin Juillet Aot Septembre Octobre Novembre Dcembre);
@fetes = (
    # janvier
    [ '!Marie - JOUR de l\'AN', '&Basile', '!Genevive', '&Odilon', '&Edouard',
      '&Mlaine', '&Raymond', '&Lucien', '!Alix', '&Guillaume', '&Paulin',
      '!Tatiana', '!Yvette', '!Nina', '&Rmi', '&Marcel', '!Roseline',
      '!Prisca', '&Marius', '&Sbastien', '!Agns', '&Vincent', '&Barnard',
      '&Franois de Sales', '-Conversion de St Paul', '!Paule', '!Angle',
      '&Thomas d\'Aquin', '&Gildas', '!Martine', '!Marcelle' ],
    # fvrier
    [ '!Ella', '-Prsentation', '&Blaise', '!Vronique', '!Agathe',
      '&Gaston', '!Eugnie', '!Jacqueline', '!Apolline', '&Arnaud',
      '-Notre-Dame de Lourdes', '&Flix', '!Batrice', '&Valentin', '&Claude',
      '!Julienne', '&Alexis', '!Bernadette', '&Gabin', '!Aime',
      '&Pierre Damien', '!Isabelle', '&Lazare', '&Modeste', '&Romo', '&Nestor',
      '!Honorine', '&Romain', '&Auguste' ],
    # mars
    [ '&Aubin', '&Charles le Bon', '&Gunol', '&Casimir', '&Olive', '&Colette',
      '!Flicit', '&Jean de Dieu', '!Franoise', '&Vivien', '!Rosine',
      '!Justine', '&Rodrigue', '!Mathilde', '!Louise de Marillac', '!Bndicte',
      '&Patrice', '&Cyrille', '&Joseph', '&Herbert', '!Clmence', '!La',
      '&Victorien', '!Catherine de Sude', '-Annonciation', '!Larissa',
      '&Habib', '&Gontran', '!Gwladys', '&Amde', '&Benjamin' ],
    # avril
    [ '&Hugues', '!Sandrine', '&Richard', '&Isodore', '!Irne', '&Marcellin',
      '&Jean-Baptiste de la Salle', '!Julie', '&Gautier', '&Fulbert',
      '&Stanislas', '&Jules', '!Ida', '&Maxime', '&Paterne',
      '&Benot-Joseph Labre', '&Anicet', '&Parfait', '!Emma', '!Odette',
      '&Anselme', '&Alexandre', '&Georges', '&Fidle', '&Marc', '!Alida',
      '!Zita', '!Valrie', '!Catherine de Sienne', '&Robert' ],
    # mai
    [ '&Jrmie - FETE du TRAVAIL', '&Boris', '&Philippe / Jacques', '&Sylvain',
      '!Judith', '!Prudence', '!Gisle', '&Dsir - ANNIVERSAIRE 1945',
      '&Pacme', '!Solange', '!Estelle', '&Achille', '!Rolande', '&Mathias',
      '!Denise', '&Honor', '&Pascal', '&Eric', '&Yves', '&Bernardin',
      '&Constantin', '&Emile', '&Didier', '&Donatien', '!Sophie', '&Brenger',
      '&Augustin', '&Germain', '&Aymar', '&Ferdinand', '-Visitation' ],
    # juin
    [ '&Justin', '!Blandine', '&Kvin', '!Clotilde', '&Igor', '&Norbert',
      '&Gilbert', '&Mdard', '!Diane', '&Landry', '&Barnab', '&Guy',
      '&Antoine de Padoue', '&Elise', '!Germaine', '&Jean-Franois Rgis',
      '&Herv', '&Lonce', '&Romuald', '&Silvre', '&Rodolphe', '&Alban',
      '!Audrey', '&Jean-Baptiste', '&Salomon', '&Anthelme', '&Fernand',
      '&Irne', '&Pierre / Paul', '&Martial' ],
    # juillet
    [ '&Thierry', '&Martinien', '&Thomas', '&Florent', '&Antoine', '!Mariette',
      '&Raoul', '&Thibaut', '!Amandine', '&Ulrich', '&Benot', '&Olivier',
      '&Henri / Jol', '!Camille - FETE NATIONALE', '&Donald',
      '-N.D. du Mont Carmel', '!Charlotte', '&Frdric', '&Arsne', '!Marina',
      '&Victor', '!Marie-Madeleine', '!Brigitte', '!Christine', '&Jacques',
      '&Anne', '!Nathalie', '&Samson', '!Marthe', '!Juliette',
      '&Ignace de Loyola' ],
    # aot
    [ '&Alphonse', '&Julien', '!Lydie', '&Jean-Marie Vianney', '&Abel',
      '-Transfiguration', '&Gatan', '&Dominique', '&Amour', '&Laurent',
      '!Claire', '!Clarisse', '&Hippolyte', '&Evrard',
      '!Marie - ASSOMPTION', '&Armel', '&Hyacinthe', '!Hlne', '&Jean Eudes',
      '&Bernard', '&Christophe', '&Fabrice', '!Rose de Lima', '&Barthlmy',
      '&Louis', '!Natacha', '!Monique', '&Augustin', '!Sabine', '&Fiacre',
      '&Aristide' ],
    # septembre
    [ '&Gilles', '!Ingrid', '&Grgoire', '!Rosalie', '!Rassa', '&Bertrand',
      '!Reine', '-Nativit de Marie', '&Alain', '!Ins', '&Adelphe',
      '&Apollinaire', '&Aim', '-La Ste Croix', '&Roland', '!Edith', '&Renaud',
      '!Nadge', '!Emilie', '&Davy', '&Matthieu', '&Maurice', '&Constant',
      '!Thcle', '&Hermann', '&Cme / Damien', '&Vincent de Paul', '&Venceslas',
      '&Michel / Gabriel', '&Jrme' ],
    # octobre
    [ '!Thrse de l\'Enfant Jsus', '&Lger', '&Grard', '&Franois d\'Assise',
      '!Fleur', '&Bruno', '&Serge', '!Plagie', '&Denis', '&Ghislain', '&Firmin',
      '&Wilfried', '&Graud', '&Juste', '!Thrse d\'Avila', '!Edwige',
      '&Baudouin', '&Luc', '&Ren', '!Adeline', '!Cline', '!Elodie',
      '&Jean de Capistran', '&Florentin', '&Crpin', '&Dimitri', '!Emeline',
      '&Simon / Jude', '&Narcisse', '!Bienvenue', '&Quentin' ],
    # novembre
    [ '&Harold - TOUSSAINT', '-Dfunts', '&Hubert', '&Charles', '!Sylvie',
      '!Bertille', '!Carine', '&Geoffroy', '&Thodore', '&Lon',
      '&Martin - ARMISTICE 1918', '&Christian', '&Brice', '&Sidoine', '&Albert',
      '!Marguerite', '!Elisabeth', '!Aude', '&Tanguy', '&Edmond',
      '-Prsentation de Marie', '!Ccile', '&Clment', '!Flora', '!Catherine',
      '!Delphine', '&Sverin', '&Jacques de la Marche', '&Saturnin', '&Andr' ],
    # dcembre
    [ '!Florence', '!Viviane', '&Xavier', '!Barbara', '&Grald', '&Nicolas',
      '&Ambroise', '-Immacule Conception', '&Pierre Fourier', '&Romaric',
      '&Daniel', '!Jeanne de Chantal', '!Lucie', '!Odile', '!Ninon', '!Alice',
      '&Gal', '&Gatien', '&Urbain', '&Abraham', '&Pierre Canisius',
      '!Franoise-Xavier', '&Armand', '!Adle', '&Emmanuel - NOEL', '&Etienne',
      '&Jean', '-Sts Innocents', '&David', '&Roger', '&Sylvestre' ],
);

sub fete_jour
{
    my ($sec, $min, $heure, $mjour, $mois, $annee, $sjour, $ajour, $est_dst) = localtime ($_[0]);
    my $fete = $fetes[$mois][$mjour-1];
    $fete =~ s/^!/Ste /;
    $fete =~ s/^&/St /;
    $fete =~ s/^-//;
    $fete;
}

sub fete
{
    if ($#_ == 1)
    {
        my @params = split " ", @_[1];
        for $arg (@params)
        {
            for (my $mois = 0; $mois <= $#fetes; $mois++)
            {
                for (my $jour = 0; $jour < 31; $jour++)
                {
                    if (uc ($fetes[$mois][$jour]) =~ /\U$arg/)
                    {
                        weechat::print (($jour + 1)." ".$noms_mois[$mois].": ".substr ($fetes[$mois][$jour], 1));
                    }
                }
            }
        }
    }
    else
    {
        my $time_now = time;
        my ($fete1, $fete2) = (fete_jour ($time_now), fete_jour ($time_now + (3600 * 24)));
        my ($mjour, $mois, $sjour) = (localtime ($time_now))[3, 4, 6];
        weechat::print_infobar (0, "$fete1 (demain: $fete2)");
    }
    return weechat::PLUGIN_RC_OK;
}

fete ();
