/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "wflogentry.h"
#include "output_sort.h"
#include "defs.h"

// change all this (ugly), probably by using templates RV@@7

#define CMP_STR(NAME, VAR) \
static int \
cmp_ ## NAME (const void* P, const void* Q) { \
  return cmp_string(((wf_logentry*)P)->VAR, ((wf_logentry*)Q)->VAR); \
}

#define CMP_INT(NAME, VAR) \
static int \
cmp_ ## NAME (const void* P, const void* Q) { \
  return cmp_integer(((wf_logentry*)P)->VAR, ((wf_logentry*)Q)->VAR); \
}

#define CMP_IPADDR(NAME, VAR) \
static int \
cmp_ ## NAME (const void* P, const void* Q) { \
  return cmp_ipaddr(((wf_logentry*)P)->VAR, ((wf_logentry*)Q)->VAR); \
}

#define CMP_MACADDR(NAME, VAR) \
static int \
cmp_ ## NAME (const void* P, const void* Q) { \
  return cmp_macaddr(((wf_logentry*)P)->VAR, ((wf_logentry*)Q)->VAR); \
}

inline int
cmp_ipaddr(const wf_ipaddr& a, const wf_ipaddr& b) {
  if (a < b)
    return -1;
  if (a == b)
    return 0;
  return 1;
}

inline int
cmp_macaddr(const wf_macaddr& a, const wf_macaddr& b) {
  if (a < b)
    return -1;
  if (a == b)
    return 0;
  return 1;
}


CMP_STR(format, format)
CMP_INT(count, count)
CMP_INT(time, start_time)
CMP_INT(timeend, end_time)
CMP_STR(hostname, hostname)
CMP_STR(chainlabel, chainlabel)
CMP_STR(branchname, branchname)
CMP_STR(input_iface, input_iface)
CMP_STR(output_iface, output_iface)
CMP_INT(protocol, protocol)
CMP_INT(datalen, datalen)
CMP_IPADDR(sipaddr, sipaddr)
CMP_MACADDR(smacaddr, smacaddr)
CMP_INT(sport, sport)
CMP_IPADDR(dipaddr, dipaddr)
CMP_MACADDR(dmacaddr, dmacaddr)
CMP_INT(dport, dport)
CMP_INT(tcpflags, tcpflags)


/* Sorted array (because of binary search) */
const struct wf_sort_availspecs format_array[] = {
  /*  crit name          compare func    */
  { "branchname",	cmp_branchname   },
  { "chainlabel",	cmp_chainlabel   },
  { "count",		cmp_count        },
  { "datalen",		cmp_datalen      },
  { "dipaddr",		cmp_dipaddr      },
  { "dmacaddr",		cmp_dmacaddr     },
  { "dport",		cmp_dport        },
  { "format",		cmp_format       },
  { "hostname",		cmp_hostname     },
  { "input_iface",	cmp_input_iface  },
  { "output_iface",	cmp_output_iface },
  { "protocol",		cmp_protocol     },
  { "sipaddr",		cmp_sipaddr      },
  { "smacaddr",		cmp_smacaddr     },
  { "sport",		cmp_sport        },
  { "tcpflags",		cmp_tcpflags     },
  { "time",		cmp_time         },
  { "timeend",		cmp_timeend      },
  /* trailing NULL would ruin alphabetical order : we use "~" instead */
  { "~",            NULL             }
};

int format_array_count =
  sizeof(format_array) / sizeof(struct wf_sort_availspecs);
