/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WFWHOIS_H
#define _WFWHOIS_H

#include <list>
#include <iostream>
#include <string>

#include "wfipaddr.h"

#define WHOIS_SERVER "whois.radb.net"
#define WHOIS_PORT 43

/**
 * 
 */
class wf_whois_entry {
 public:
  wf_whois_entry();
  virtual ~wf_whois_entry() {}
  // wf_whois_entry(const wf_whois_entry&) implicit copy constructor

  ostream& print(ostream& os) const;
  friend ostream& operator<<(ostream& os, const wf_whois_entry& whois_entry);

 public:
  string ip_route;
  string ip_descr;
  int as_number;
  string as_descr;
};

/**
 * 
 */
class wf_whois {
 public:
  wf_whois();
  wf_whois(unsigned char verb);
  virtual ~wf_whois() {}
  // wf_whois(const wf_whois&)  copy pointers? RV@@5

  wf_whois_entry* whois(const wf_ipaddr& ipaddr);
  bool isconnected() const;
  bool connect();
  bool connect(const string& whois_server, uint16_t port);
  bool close();

  void cache_add(const wf_whois_entry* whois_entry);
  wf_whois_entry* cache_get(const wf_ipaddr& ipaddr) const;
  ostream& cache_debugprint(ostream& os) const;

 private:
  void whois_from_ip(const wf_ipaddr& ipaddr, wf_whois_entry* whois_entry);

 public:
  list<wf_whois_entry*> cache;
  unsigned char verbose;
 private:
  string _host;
  uint16_t _port;
  int _sock;
};

#endif
