/*
 * MainWindow.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MAIN_WINDOW_H
#define _MAIN_WINDOW_H

#ifndef _PANED_WINDOW_H
#include "PanedWindow.h"
#endif

#ifndef _SCENE_H
#include "Scene.h"
#endif

#ifdef HAVE_SAND
#include "nebula/ExportNebula.h"
#endif

class SceneView;
class ToolbarWindow;
class StatusBar;
class ScriptEdit;
class NodeShape;

#include "swttypedef.h"
#include "ColorConversion.h"

class MainWindow : public PanedWindow {
public:
    			MainWindow(Scene *scene, SWND parent);

    virtual	       ~MainWindow();
    void        	destroyMainWindow(void); // but keep scene

    virtual void	OnCommand(int id);
    virtual void	OnHighlight(int id);
    virtual void        OnUpdate(SceneView *sender, int type, Hint *hint);
    virtual void	OnSize(int x, int y);

    void                OnFileOpen();
    void                OnFileImport();
    void		OnFileSave();
    void		OnFileSaveAs(bool pureVRML97 = false);
    void                OnFileExportVRML97();
    int			OnTimer();
    bool		SaveModified();
    void		setStatusText(const char *str);
    bool		SaveFile(const char *path, const char *url, 
                                 bool pureVRML97 = false);

    SWND		getParentWindow() { return _parentWindow; }
    void		UpdateToolbars(void);
    void                UpdateUpload(void);
    void		OnEditorReadyCallback(void);

protected:
    void		CreateNode(const char *type);
    void		CreateGeometryNode(const char *type);
    void		CreateGeometryNode(Node *node);
    void		CreateAnimation(void);
    void		CreateScript();
    void		CreateElevationGrid();
    void		CreateViewpoint();
    void		CreateNurbsPlane();
    void                CreateNurbsCurve();
    void                CreateSuperExtrusion();
    Node	       *InsertNode(const char *type);
    Node	       *InsertNode(int fieldType, const char *type);
    void		InsertAudioClip();
    void		InsertImageTexture();
    void		InsertTextureCoordinate();
    void		InsertNormal();
    void		InsertInline(bool withLoadControl = false);
    void		InsertMovieTexture();
    void 		InsertNewNurbsNode(Node *nurbsNode, Node* parent);
    void		ToggleFullScreen();
    void		ToggleView(int direction, SceneView *view, int id,
    				   const char *name);
    void		ShowView(int direction, SceneView *view, int id,
    				   const char *name);
    STOOLBAR		LoadToolbar(ToolbarWindow *tbWin, int id, int count,
    				    const int *buttons, int menuid,
				    const char *prefName);
    void		ToggleToolbar(ToolbarWindow *tbWin, STOOLBAR toolbar,
    				      int id, const char *name);
    void		ToggleStatusbar();

    void		setTMode(TMode mode);
    void		setTDimension(TDimension dimension);
    void 		setT2axes(T2axes axes);

    void		setColorCircleIcon();
    int		        getMouseMode() {return(_mouseMode);}
    bool		getNavigationMode() {return(_navigation_active);}
    void		OnEditCut();
    void		OnEditCopy();
    void		OnEditPaste();
    void		Play();
    void		Stop();
    void		Record();
    bool		OpenFileCheck(const char *path);
    void		ImportFileCheck(const char *path);
    void		RefreshRecentFileMenu();
    void		RefreshProtoMenu();
    void                RefreshSelectionHelp();
    void		UpdateTitle();
    void                updateColorCircle(void);
    int 		GetIconPos(int* buttons,int length,int icon);
    void		OnHelpOverview();
    void		OnHelpSelection();
    void                EditScript(Node* oldnode);
    void                EditObject();
    void                EditUrl();
    bool                isScriptEditorInUse();
    void                setXSymetricNurbsIcon();
    void                moveBranchToParent(void);
    void                moveBranchTo(char* nodeName, char* fieldName);
    void                moveBranchTo(Node* node, int field, Node* current);
    void                removeIllegalNodes();
    Node               *getTransformForCenter();
    void                centerToMid();
    void                centerToMax(int index);
    void                centerToMin(int index);
    void                InsertArray(void);
    void                flip(int index);
    void                degreeElevate(int degree);
    void                uDegreeElevate(int degree);
    void                vDegreeElevate(int degree);
    void                toNurbs();
    void                toNurbsCurve();
    void                toSuperExtrusion();
    void                toExtrusion();
    void                toIndexedFaceSet();
    void                toIndexedLineSet();
    void                toPointSet();
    void                toPositionInterpolator();
    void                toOrientationInterpolator();
    void                timeShift();
    void		countPolygons();
    void                setPathAllURLs();
    void		clearStatusText();
    void                testInMenu();
    void                swapDiffuseEmissiveShape(NodeShape *shape,
                                                 ColorConversion conversion);
    void                CreateStarFish(int numberArms);
    void                CreateFlower(int numberLeaves);
    void                CreateTube(bool hornFlag = false);
    void                CreateHalfSphere(void);
    void                CreateShell(void);
    void                CreateUfo(void);
    void                CreateInsectRear(int segments);

#ifdef HAVE_SAND
    void OnSANDExport(void);
#endif

protected:
    SWND		_parentWindow;
    SMENU		_menu;
    StatusBar	       *_statusBar;
    ToolbarWindow      *_toolbarWindow;
    ToolbarWindow      *_toolbarWindow2;
    PanedWindow        *_innerPane;
    PanedWindow        *_outerPane;
    SceneView	       *_treeView;
    SceneView	       *_S3DView;
    SceneView	       *_fieldView;
    SceneView	       *_graphView;
    SceneView	       *_channelView;
    STOOLBAR		_standardToolbar;
    STOOLBAR		_nodeToolbar1;
    bool		_nodeToolbar1Enabled;
    STOOLBAR		_nodeToolbar2;
    bool		_nodeToolbar2Enabled;
    STOOLBAR		_nodeToolbar3;
    bool		_nodeToolbar3Enabled;
    STOOLBAR		_nodeToolbarVRML200x;
    bool		_nodeToolbarVRML200xEnabled;
    STOOLBAR		_nodeToolbarScripted;
    bool		_nodeToolbarScriptedEnabled;
    STOOLBAR		_vcrToolbar;
    STIMER		_timer;
    int                 _fileNewIconPos;
    int                 _fileOpenIconPos;
    int                 _fileSaveIconPos;
    int                 _filePreviewIconPos;
    int                 _editCutIconPos;
    int                 _editCopyIconPos;
    int                 _editPasteIconPos;
    int                 _editDeleteIconPos;
    bool                _fullScreen_enabled;
    int                 _fullScreenIconPos;
    SceneView	       *_colorCircle;    
    FieldUpdate        *_colorCircleHint;
    bool		_colorCircle_active;
    bool		_colorCircle_enabled;
    int                 _colorCircleIconPos;
    bool		_objectEdit_enabled;
    int                 _objectEditIconPos;
    bool		_urlEdit_enabled;
    int                 _urlEditIconPos;
    int                 _animationIconPos;
    int 		_x_symetricIconPos;
    bool		_navigation_active;
    int		        _mouseMode;
    int                 _mouseIconPos;
    int                 _inputModeStartIconPos;
    int                 _tDimensionStartIconPos;
    int                 _t2axesStartIconPos;
    int                 _inputDeviceGreaterIconPos;
    int                 _inputDeviceLesserIconPos;
//    SceneView	       *_oldFieldView;
    SWND                _fieldCanvas;
    int			_lenProtoMenu;
    ScriptEdit	       *_scriptEdit;
    bool	        _scriptEditorInUse;
    int                 _selectedField;
    char 	        _statusText[256];
#ifdef HAVE_SAND
    ExportNebula        _nebulaExporter;
#endif
};

#endif /* _MAIN_WINDOW_H */
