(**************************************************************************)
(*                                                                        *)
(*  The Why/Caduceus/Krakatoa tool suite for program certification        *)
(*  Copyright (C) 2002-2006                                               *)
(*    Jean-Franois COUCHOT                                               *)
(*    Mehdi DOGGUY                                                        *)
(*    Jean-Christophe FILLITRE                                           *)
(*    Thierry HUBERT                                                      *)
(*    Claude MARCH                                                       *)
(*    Yannick MOY                                                         *)
(*                                                                        *)
(*  This software is free software; you can redistribute it and/or        *)
(*  modify it under the terms of the GNU General Public                   *)
(*  License version 2, as published by the Free Software Foundation.      *)
(*                                                                        *)
(*  This software is distributed in the hope that it will be useful,      *)
(*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *)
(*                                                                        *)
(*  See the GNU General Public License version 2 for more details         *)
(*  (enclosed in the file GPL).                                           *)
(*                                                                        *)
(**************************************************************************)


val window_width : int ref
val window_height : int ref

val font_size : int ref
val font_family : string

type color = {
  key : string;
  name : string;
  fc : string;
  bc : string;
}

val get_fc : string -> string
val get_bc : string -> string
val get_color : string -> string * string

val get_fc_predicate : unit -> string
val get_bc_predicate : unit -> string

val color_exists : string -> bool

val get_all_colors : unit -> color list
val set_all_colors : (string * string * string) list -> unit
val replace_color : string -> string -> string -> unit

val has_changed : unit -> bool
