(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require Import ZOdiv.
Require Import Rbasic_fun.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.
Require floating_point.Rounding.
Require real.Real.
Require real.Abs.
Require real.FromInt.
Require floating_point.SingleFormat.
Require floating_point.DoubleFormat.
Require Jessie_memory_model.

(* Why3 assumption *)
Definition unit  := unit.

Parameter qtmark : Type.

Parameter at1: forall (a:Type), a -> qtmark -> a.
Implicit Arguments at1.

Parameter old: forall (a:Type), a -> a.
Implicit Arguments old.

(* Why3 assumption *)
Definition implb(x:bool) (y:bool): bool := match (x,
  y) with
  | (true, false) => false
  | (_, _) => true
  end.

(* Why3 assumption *)
Inductive class  :=
  | Finite : class 
  | Infinite : class 
  | NaN : class .

(* Why3 assumption *)
Inductive sign  :=
  | Neg : sign 
  | Pos : sign .

(* Why3 assumption *)
Inductive same_sign_real : sign -> R -> Prop :=
  | Neg_case : forall (x:R), (x < 0%R)%R -> (same_sign_real Neg x)
  | Pos_case : forall (x:R), (0%R < x)%R -> (same_sign_real Pos x).

Axiom same_sign_real_zero1 : forall (b:sign), ~ (same_sign_real b 0%R).

Axiom same_sign_real_zero2 : forall (x:R), ~ ((same_sign_real Neg x) /\
  (same_sign_real Pos x)).

Axiom same_sign_real_zero3 : forall (b:sign) (x:R), (same_sign_real b x) ->
  ~ (x = 0%R).

Axiom same_sign_real_correct2 : forall (b:sign) (x:R), (same_sign_real b
  x) -> ((x < 0%R)%R <-> (b = Neg)).

Axiom same_sign_real_correct3 : forall (b:sign) (x:R), (same_sign_real b
  x) -> ((0%R < x)%R <-> (b = Pos)).

Parameter round: floating_point.Rounding.mode -> R -> R.

Parameter round_logic: floating_point.Rounding.mode -> R ->
  floating_point.SingleFormat.single.

Parameter value: floating_point.SingleFormat.single -> R.

Parameter exact: floating_point.SingleFormat.single -> R.

Parameter model: floating_point.SingleFormat.single -> R.

(* Why3 assumption *)
Definition round_error(x:floating_point.SingleFormat.single): R :=
  (Rabs ((value x) - (exact x))%R).

(* Why3 assumption *)
Definition total_error(x:floating_point.SingleFormat.single): R :=
  (Rabs ((value x) - (model x))%R).

(* Why3 assumption *)
Definition no_overflow(m:floating_point.Rounding.mode) (x:R): Prop :=
  ((Rabs (round m x)) <= (33554430 * 10141204801825835211973625643008)%R)%R.

Axiom Bounded_real_no_overflow : forall (m:floating_point.Rounding.mode)
  (x:R), ((Rabs x) <= (33554430 * 10141204801825835211973625643008)%R)%R ->
  (no_overflow m x).

Axiom Round_monotonic : forall (m:floating_point.Rounding.mode) (x:R) (y:R),
  (x <= y)%R -> ((round m x) <= (round m y))%R.

Axiom Round_idempotent : forall (m1:floating_point.Rounding.mode)
  (m2:floating_point.Rounding.mode) (x:R), ((round m1 (round m2
  x)) = (round m2 x)).

Axiom Round_value : forall (m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single), ((round m (value x)) = (value x)).

Axiom Bounded_value : forall (x:floating_point.SingleFormat.single),
  ((Rabs (value x)) <= (33554430 * 10141204801825835211973625643008)%R)%R.

Axiom Exact_rounding_for_integers : forall (m:floating_point.Rounding.mode)
  (i:Z), (((-16777216%Z)%Z <= i)%Z /\ (i <= 16777216%Z)%Z) -> ((round m
  (IZR i)) = (IZR i)).

Axiom Round_down_le : forall (x:R), ((round floating_point.Rounding.Down
  x) <= x)%R.

Axiom Round_up_ge : forall (x:R), (x <= (round floating_point.Rounding.Up
  x))%R.

Axiom Round_down_neg : forall (x:R), ((round floating_point.Rounding.Down
  (-x)%R) = (-(round floating_point.Rounding.Up x))%R).

Axiom Round_up_neg : forall (x:R), ((round floating_point.Rounding.Up
  (-x)%R) = (-(round floating_point.Rounding.Down x))%R).

Parameter class1: floating_point.SingleFormat.single -> class.

(* Why3 assumption *)
Definition is_finite(x:floating_point.SingleFormat.single): Prop :=
  ((class1 x) = Finite).

(* Why3 assumption *)
Definition is_infinite(x:floating_point.SingleFormat.single): Prop :=
  ((class1 x) = Infinite).

(* Why3 assumption *)
Definition is_NaN(x:floating_point.SingleFormat.single): Prop :=
  ((class1 x) = NaN).

(* Why3 assumption *)
Definition is_not_NaN(x:floating_point.SingleFormat.single): Prop :=
  (is_finite x) \/ (is_infinite x).

Axiom is_not_NaN1 : forall (x:floating_point.SingleFormat.single),
  (is_not_NaN x) <-> ~ (is_NaN x).

Parameter sign1: floating_point.SingleFormat.single -> sign.

(* Why3 assumption *)
Definition same_sign_real1(x:floating_point.SingleFormat.single)
  (y:R): Prop := (same_sign_real (sign1 x) y).

(* Why3 assumption *)
Definition same_sign(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ((sign1 x) = (sign1 y)).

(* Why3 assumption *)
Definition diff_sign(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ~ ((sign1 x) = (sign1 y)).

(* Why3 assumption *)
Definition sign_zero_result(m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single): Prop := ((value x) = 0%R) ->
  match m with
  | floating_point.Rounding.Down => ((sign1 x) = Neg)
  | _ => ((sign1 x) = Pos)
  end.

(* Why3 assumption *)
Definition is_minus_infinity(x:floating_point.SingleFormat.single): Prop :=
  (is_infinite x) /\ ((sign1 x) = Neg).

(* Why3 assumption *)
Definition is_plus_infinity(x:floating_point.SingleFormat.single): Prop :=
  (is_infinite x) /\ ((sign1 x) = Pos).

(* Why3 assumption *)
Definition is_gen_zero(x:floating_point.SingleFormat.single): Prop :=
  (is_finite x) /\ ((value x) = 0%R).

(* Why3 assumption *)
Definition is_gen_zero_plus(x:floating_point.SingleFormat.single): Prop :=
  (is_gen_zero x) /\ ((sign1 x) = Pos).

(* Why3 assumption *)
Definition is_gen_zero_minus(x:floating_point.SingleFormat.single): Prop :=
  (is_gen_zero x) /\ ((sign1 x) = Neg).

Axiom finite_sign : forall (x:floating_point.SingleFormat.single),
  (((class1 x) = Finite) /\ ~ ((value x) = 0%R)) -> (same_sign_real1 x
  (value x)).

Axiom finite_sign_pos1 : forall (x:floating_point.SingleFormat.single),
  (((class1 x) = Finite) /\ (0%R < (value x))%R) -> ((sign1 x) = Pos).

Axiom finite_sign_pos2 : forall (x:floating_point.SingleFormat.single),
  (((class1 x) = Finite) /\ ((~ ((value x) = 0%R)) /\ ((sign1 x) = Pos))) ->
  (0%R < (value x))%R.

Axiom finite_sign_neg1 : forall (x:floating_point.SingleFormat.single),
  (((class1 x) = Finite) /\ ((value x) < 0%R)%R) -> ((sign1 x) = Neg).

Axiom finite_sign_neg2 : forall (x:floating_point.SingleFormat.single),
  (((class1 x) = Finite) /\ ((~ ((value x) = 0%R)) /\ ((sign1 x) = Neg))) ->
  ((value x) < 0%R)%R.

Axiom diff_sign_trans : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (z:floating_point.SingleFormat.single), ((diff_sign x y) /\ (diff_sign y
  z)) -> (same_sign x z).

Axiom diff_sign_product : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), (((class1 x) = Finite) /\
  (((class1 y) = Finite) /\ (((value x) * (value y))%R < 0%R)%R)) ->
  (diff_sign x y).

Axiom same_sign_product : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), (((class1 x) = Finite) /\
  (((class1 y) = Finite) /\ (same_sign x y))) ->
  (0%R <= ((value x) * (value y))%R)%R.

(* Why3 assumption *)
Definition overflow_value(m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single): Prop := match (m,
  (sign1 x)) with
  | (floating_point.Rounding.Down, Neg) => (is_infinite x)
  | (floating_point.Rounding.Down, Pos) => (is_finite x) /\
      ((value x) = (33554430 * 10141204801825835211973625643008)%R)
  | (floating_point.Rounding.Up, Neg) => (is_finite x) /\
      ((value x) = (-(33554430 * 10141204801825835211973625643008)%R)%R)
  | (floating_point.Rounding.Up, Pos) => (is_infinite x)
  | (floating_point.Rounding.ToZero, Neg) => (is_finite x) /\
      ((value x) = (-(33554430 * 10141204801825835211973625643008)%R)%R)
  | (floating_point.Rounding.ToZero, Pos) => (is_finite x) /\
      ((value x) = (33554430 * 10141204801825835211973625643008)%R)
  | (
      (floating_point.Rounding.NearestTiesToAway|floating_point.Rounding.NearestTiesToEven),
      _) => (is_infinite x)
  end.

Axiom round1 : forall (m:floating_point.Rounding.mode) (x:R), (no_overflow m
  x) -> ((is_finite (round_logic m x)) /\ ((value (round_logic m
  x)) = (round m x))).

Axiom round2 : forall (m:floating_point.Rounding.mode) (x:R),
  (~ (no_overflow m x)) -> ((same_sign_real1 (round_logic m x) x) /\
  (overflow_value m (round_logic m x))).

Axiom round3 : forall (m:floating_point.Rounding.mode) (x:R),
  ((exact (round_logic m x)) = x).

Axiom round4 : forall (m:floating_point.Rounding.mode) (x:R),
  ((model (round_logic m x)) = x).

Axiom round_of_zero : forall (m:floating_point.Rounding.mode),
  (is_gen_zero (round_logic m 0%R)).

Axiom round_logic_le : forall (m:floating_point.Rounding.mode) (x:R),
  (is_finite (round_logic m x)) -> ((Rabs (value (round_logic m
  x))) <= (33554430 * 10141204801825835211973625643008)%R)%R.

Axiom round_no_overflow : forall (m:floating_point.Rounding.mode) (x:R),
  ((Rabs x) <= (33554430 * 10141204801825835211973625643008)%R)%R ->
  ((is_finite (round_logic m x)) /\ ((value (round_logic m x)) = (round m
  x))).

Parameter min: R.

Axiom positive_constant : forall (m:floating_point.Rounding.mode) (x:R),
  ((min <= x)%R /\
  (x <= (33554430 * 10141204801825835211973625643008)%R)%R) ->
  ((is_finite (round_logic m x)) /\ ((0%R < (value (round_logic m x)))%R /\
  ((sign1 (round_logic m x)) = Pos))).

Axiom negative_constant : forall (m:floating_point.Rounding.mode) (x:R),
  (((-(33554430 * 10141204801825835211973625643008)%R)%R <= x)%R /\
  (x <= (-min)%R)%R) -> ((is_finite (round_logic m x)) /\
  (((value (round_logic m x)) < 0%R)%R /\ ((sign1 (round_logic m
  x)) = Neg))).

Axiom is_gen_zero_comp1 : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), ((is_gen_zero x) /\
  (((value x) = (value y)) /\ (is_finite y))) -> (is_gen_zero y).

Axiom is_gen_zero_comp2 : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), ((is_finite x) /\
  ((~ (is_gen_zero x)) /\ ((value x) = (value y)))) -> ~ (is_gen_zero y).

(* Why3 assumption *)
Definition add_post(m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (r:floating_point.SingleFormat.single): Prop := (((is_NaN x) \/
  (is_NaN y)) -> (is_NaN r)) /\ ((((is_finite x) /\ (is_infinite y)) ->
  ((is_infinite r) /\ (same_sign r y))) /\ ((((is_infinite x) /\
  (is_finite y)) -> ((is_infinite r) /\ (same_sign r x))) /\
  ((((is_infinite x) /\ ((is_infinite y) /\ (same_sign x y))) ->
  ((is_infinite r) /\ (same_sign r x))) /\ ((((is_infinite x) /\
  ((is_infinite y) /\ (diff_sign x y))) -> (is_NaN r)) /\ ((((is_finite x) /\
  ((is_finite y) /\ (no_overflow m ((value x) + (value y))%R))) ->
  ((is_finite r) /\ (((value r) = (round m ((value x) + (value y))%R)) /\
  (sign_zero_result m r)))) /\ ((((is_finite x) /\ ((is_finite y) /\
  ~ (no_overflow m ((value x) + (value y))%R))) -> ((same_sign_real (sign1 r)
  ((value x) + (value y))%R) /\ (overflow_value m r))) /\
  (((exact r) = ((exact x) + (exact y))%R) /\
  ((model r) = ((model x) + (model y))%R)))))))).

(* Why3 assumption *)
Definition sub_post(m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (r:floating_point.SingleFormat.single): Prop := (((is_NaN x) \/
  (is_NaN y)) -> (is_NaN r)) /\ ((((is_finite x) /\ (is_infinite y)) ->
  ((is_infinite r) /\ (diff_sign r y))) /\ ((((is_infinite x) /\
  (is_finite y)) -> ((is_infinite r) /\ (same_sign r x))) /\
  ((((is_infinite x) /\ ((is_infinite y) /\ (same_sign x y))) ->
  (is_NaN r)) /\ ((((is_infinite x) /\ ((is_infinite y) /\ (diff_sign x
  y))) -> ((is_infinite r) /\ (same_sign r x))) /\ ((((is_finite x) /\
  ((is_finite y) /\ (no_overflow m ((value x) - (value y))%R))) ->
  ((is_finite r) /\ (((value r) = (round m ((value x) - (value y))%R)) /\
  (sign_zero_result m r)))) /\ ((((is_finite x) /\ ((is_finite y) /\
  ~ (no_overflow m ((value x) - (value y))%R))) -> ((same_sign_real (sign1 r)
  ((value x) - (value y))%R) /\ (overflow_value m r))) /\
  (((exact r) = ((exact x) - (exact y))%R) /\
  ((model r) = ((model x) - (model y))%R)))))))).

(* Why3 assumption *)
Definition product_sign(z:floating_point.SingleFormat.single)
  (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ((same_sign x y) ->
  ((sign1 z) = Pos)) /\ ((diff_sign x y) -> ((sign1 z) = Neg)).

(* Why3 assumption *)
Definition mul_post(m:floating_point.Rounding.mode)
  (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (r:floating_point.SingleFormat.single): Prop := (((is_NaN x) \/
  (is_NaN y)) -> (is_NaN r)) /\ ((((is_gen_zero x) /\ (is_infinite y)) ->
  (is_NaN r)) /\ ((((is_finite x) /\ ((is_infinite y) /\
  ~ ((value x) = 0%R))) -> (is_infinite r)) /\ ((((is_infinite x) /\
  (is_gen_zero y)) -> (is_NaN r)) /\ ((((is_infinite x) /\ ((is_finite y) /\
  ~ ((value y) = 0%R))) -> (is_infinite r)) /\ ((((is_infinite x) /\
  (is_infinite y)) -> (is_infinite r)) /\ ((((is_finite x) /\
  ((is_finite y) /\ (no_overflow m ((value x) * (value y))%R))) ->
  ((is_finite r) /\ ((value r) = (round m ((value x) * (value y))%R)))) /\
  ((((is_finite x) /\ ((is_finite y) /\ ~ (no_overflow m
  ((value x) * (value y))%R))) -> (overflow_value m r)) /\ ((product_sign r x
  y) /\ (((exact r) = ((exact x) * (exact y))%R) /\
  ((model r) = ((model x) * (model y))%R)))))))))).

(* Why3 assumption *)
Definition neg_post(x:floating_point.SingleFormat.single)
  (r:floating_point.SingleFormat.single): Prop := ((is_NaN x) ->
  (is_NaN r)) /\ (((is_infinite x) -> (is_infinite r)) /\ (((is_finite x) ->
  ((is_finite r) /\ ((value r) = (-(value x))%R))) /\ ((diff_sign r x) /\
  (((exact r) = (-(exact x))%R) /\ ((model r) = (-(model x))%R))))).

(* Why3 assumption *)
Definition of_real_exact_post(x:R)
  (r:floating_point.SingleFormat.single): Prop := (is_finite r) /\
  (((value r) = x) /\ (((exact r) = x) /\ ((model r) = x))).

(* Why3 assumption *)
Definition le(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ((is_finite x) /\
  ((is_finite y) /\ ((value x) <= (value y))%R)) \/
  (((is_minus_infinity x) /\ (is_not_NaN y)) \/ ((is_not_NaN x) /\
  (is_plus_infinity y))).

(* Why3 assumption *)
Definition lt(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ((is_finite x) /\
  ((is_finite y) /\ ((value x) < (value y))%R)) \/ (((is_minus_infinity x) /\
  ((is_not_NaN y) /\ ~ (is_minus_infinity y))) \/ ((is_not_NaN x) /\
  ((~ (is_plus_infinity x)) /\ (is_plus_infinity y)))).

(* Why3 assumption *)
Definition eq(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := (is_not_NaN x) /\
  ((is_not_NaN y) /\ (((is_finite x) /\ ((is_finite y) /\
  ((value x) = (value y)))) \/ ((is_infinite x) /\ ((is_infinite y) /\
  (same_sign x y))))).

(* Why3 assumption *)
Definition ne(x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single): Prop := ~ (eq x y).

Axiom le_lt_trans : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (z:floating_point.SingleFormat.single), ((le x y) /\ (lt y z)) -> (lt x z).

Axiom lt_le_trans : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single)
  (z:floating_point.SingleFormat.single), ((lt x y) /\ (le y z)) -> (lt x z).

Axiom le_ge_asym : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), ((le x y) /\ (le y x)) -> (eq x y).

Axiom not_lt_ge : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), ((~ (lt x y)) /\ ((is_not_NaN x) /\
  (is_not_NaN y))) -> (le y x).

Axiom not_gt_le : forall (x:floating_point.SingleFormat.single)
  (y:floating_point.SingleFormat.single), ((~ (lt y x)) /\ ((is_not_NaN x) /\
  (is_not_NaN y))) -> (le x y).

Parameter round5: floating_point.Rounding.mode -> R -> R.

Parameter round_logic1: floating_point.Rounding.mode -> R ->
  floating_point.DoubleFormat.double.

Parameter value1: floating_point.DoubleFormat.double -> R.

Parameter exact1: floating_point.DoubleFormat.double -> R.

Parameter model1: floating_point.DoubleFormat.double -> R.

(* Why3 assumption *)
Definition round_error1(x:floating_point.DoubleFormat.double): R :=
  (Rabs ((value1 x) - (exact1 x))%R).

(* Why3 assumption *)
Definition total_error1(x:floating_point.DoubleFormat.double): R :=
  (Rabs ((value1 x) - (model1 x))%R).

(* Why3 assumption *)
Definition no_overflow1(m:floating_point.Rounding.mode) (x:R): Prop :=
  ((Rabs (round5 m
  x)) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R.

Axiom Bounded_real_no_overflow1 : forall (m:floating_point.Rounding.mode)
  (x:R),
  ((Rabs x) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R ->
  (no_overflow1 m x).

Axiom Round_monotonic1 : forall (m:floating_point.Rounding.mode) (x:R) (y:R),
  (x <= y)%R -> ((round5 m x) <= (round5 m y))%R.

Axiom Round_idempotent1 : forall (m1:floating_point.Rounding.mode)
  (m2:floating_point.Rounding.mode) (x:R), ((round5 m1 (round5 m2
  x)) = (round5 m2 x)).

Axiom Round_value1 : forall (m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double), ((round5 m
  (value1 x)) = (value1 x)).

Axiom Bounded_value1 : forall (x:floating_point.DoubleFormat.double),
  ((Rabs (value1 x)) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R.

Axiom Exact_rounding_for_integers1 : forall (m:floating_point.Rounding.mode)
  (i:Z), (((-9007199254740992%Z)%Z <= i)%Z /\ (i <= 9007199254740992%Z)%Z) ->
  ((round5 m (IZR i)) = (IZR i)).

Axiom Round_down_le1 : forall (x:R), ((round5 floating_point.Rounding.Down
  x) <= x)%R.

Axiom Round_up_ge1 : forall (x:R), (x <= (round5 floating_point.Rounding.Up
  x))%R.

Axiom Round_down_neg1 : forall (x:R), ((round5 floating_point.Rounding.Down
  (-x)%R) = (-(round5 floating_point.Rounding.Up x))%R).

Axiom Round_up_neg1 : forall (x:R), ((round5 floating_point.Rounding.Up
  (-x)%R) = (-(round5 floating_point.Rounding.Down x))%R).

Parameter class2: floating_point.DoubleFormat.double -> class.

(* Why3 assumption *)
Definition is_finite1(x:floating_point.DoubleFormat.double): Prop :=
  ((class2 x) = Finite).

(* Why3 assumption *)
Definition is_infinite1(x:floating_point.DoubleFormat.double): Prop :=
  ((class2 x) = Infinite).

(* Why3 assumption *)
Definition is_NaN1(x:floating_point.DoubleFormat.double): Prop :=
  ((class2 x) = NaN).

(* Why3 assumption *)
Definition is_not_NaN2(x:floating_point.DoubleFormat.double): Prop :=
  (is_finite1 x) \/ (is_infinite1 x).

Axiom is_not_NaN3 : forall (x:floating_point.DoubleFormat.double),
  (is_not_NaN2 x) <-> ~ (is_NaN1 x).

Parameter sign2: floating_point.DoubleFormat.double -> sign.

(* Why3 assumption *)
Definition same_sign_real2(x:floating_point.DoubleFormat.double)
  (y:R): Prop := (same_sign_real (sign2 x) y).

(* Why3 assumption *)
Definition same_sign1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ((sign2 x) = (sign2 y)).

(* Why3 assumption *)
Definition diff_sign1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ~ ((sign2 x) = (sign2 y)).

(* Why3 assumption *)
Definition sign_zero_result1(m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double): Prop := ((value1 x) = 0%R) ->
  match m with
  | floating_point.Rounding.Down => ((sign2 x) = Neg)
  | _ => ((sign2 x) = Pos)
  end.

(* Why3 assumption *)
Definition is_minus_infinity1(x:floating_point.DoubleFormat.double): Prop :=
  (is_infinite1 x) /\ ((sign2 x) = Neg).

(* Why3 assumption *)
Definition is_plus_infinity1(x:floating_point.DoubleFormat.double): Prop :=
  (is_infinite1 x) /\ ((sign2 x) = Pos).

(* Why3 assumption *)
Definition is_gen_zero1(x:floating_point.DoubleFormat.double): Prop :=
  (is_finite1 x) /\ ((value1 x) = 0%R).

(* Why3 assumption *)
Definition is_gen_zero_plus1(x:floating_point.DoubleFormat.double): Prop :=
  (is_gen_zero1 x) /\ ((sign2 x) = Pos).

(* Why3 assumption *)
Definition is_gen_zero_minus1(x:floating_point.DoubleFormat.double): Prop :=
  (is_gen_zero1 x) /\ ((sign2 x) = Neg).

Axiom finite_sign1 : forall (x:floating_point.DoubleFormat.double),
  (((class2 x) = Finite) /\ ~ ((value1 x) = 0%R)) -> (same_sign_real2 x
  (value1 x)).

Axiom finite_sign_pos11 : forall (x:floating_point.DoubleFormat.double),
  (((class2 x) = Finite) /\ (0%R < (value1 x))%R) -> ((sign2 x) = Pos).

Axiom finite_sign_pos21 : forall (x:floating_point.DoubleFormat.double),
  (((class2 x) = Finite) /\ ((~ ((value1 x) = 0%R)) /\ ((sign2 x) = Pos))) ->
  (0%R < (value1 x))%R.

Axiom finite_sign_neg11 : forall (x:floating_point.DoubleFormat.double),
  (((class2 x) = Finite) /\ ((value1 x) < 0%R)%R) -> ((sign2 x) = Neg).

Axiom finite_sign_neg21 : forall (x:floating_point.DoubleFormat.double),
  (((class2 x) = Finite) /\ ((~ ((value1 x) = 0%R)) /\ ((sign2 x) = Neg))) ->
  ((value1 x) < 0%R)%R.

Axiom diff_sign_trans1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (z:floating_point.DoubleFormat.double), ((diff_sign1 x y) /\ (diff_sign1 y
  z)) -> (same_sign1 x z).

Axiom diff_sign_product1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), (((class2 x) = Finite) /\
  (((class2 y) = Finite) /\ (((value1 x) * (value1 y))%R < 0%R)%R)) ->
  (diff_sign1 x y).

Axiom same_sign_product1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), (((class2 x) = Finite) /\
  (((class2 y) = Finite) /\ (same_sign1 x y))) ->
  (0%R <= ((value1 x) * (value1 y))%R)%R.

(* Why3 assumption *)
Definition overflow_value1(m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double): Prop := match (m,
  (sign2 x)) with
  | (floating_point.Rounding.Down, Neg) => (is_infinite1 x)
  | (floating_point.Rounding.Down, Pos) => (is_finite1 x) /\
      ((value1 x) = (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)
  | (floating_point.Rounding.Up, Neg) => (is_finite1 x) /\
      ((value1 x) = (-(9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R)
  | (floating_point.Rounding.Up, Pos) => (is_infinite1 x)
  | (floating_point.Rounding.ToZero, Neg) => (is_finite1 x) /\
      ((value1 x) = (-(9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R)
  | (floating_point.Rounding.ToZero, Pos) => (is_finite1 x) /\
      ((value1 x) = (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)
  | (
      (floating_point.Rounding.NearestTiesToAway|floating_point.Rounding.NearestTiesToEven),
      _) => (is_infinite1 x)
  end.

Axiom round11 : forall (m:floating_point.Rounding.mode) (x:R),
  (no_overflow1 m x) -> ((is_finite1 (round_logic1 m x)) /\
  ((value1 (round_logic1 m x)) = (round5 m x))).

Axiom round21 : forall (m:floating_point.Rounding.mode) (x:R),
  (~ (no_overflow1 m x)) -> ((same_sign_real2 (round_logic1 m x) x) /\
  (overflow_value1 m (round_logic1 m x))).

Axiom round31 : forall (m:floating_point.Rounding.mode) (x:R),
  ((exact1 (round_logic1 m x)) = x).

Axiom round41 : forall (m:floating_point.Rounding.mode) (x:R),
  ((model1 (round_logic1 m x)) = x).

Axiom round_of_zero1 : forall (m:floating_point.Rounding.mode),
  (is_gen_zero1 (round_logic1 m 0%R)).

Axiom round_logic_le1 : forall (m:floating_point.Rounding.mode) (x:R),
  (is_finite1 (round_logic1 m x)) -> ((Rabs (value1 (round_logic1 m
  x))) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R.

Axiom round_no_overflow1 : forall (m:floating_point.Rounding.mode) (x:R),
  ((Rabs x) <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R ->
  ((is_finite1 (round_logic1 m x)) /\ ((value1 (round_logic1 m
  x)) = (round5 m x))).

Parameter min1: R.

Axiom positive_constant1 : forall (m:floating_point.Rounding.mode) (x:R),
  ((min1 <= x)%R /\
  (x <= (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R) ->
  ((is_finite1 (round_logic1 m x)) /\ ((0%R < (value1 (round_logic1 m
  x)))%R /\ ((sign2 (round_logic1 m x)) = Pos))).

Axiom negative_constant1 : forall (m:floating_point.Rounding.mode) (x:R),
  (((-(9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R)%R <= x)%R /\
  (x <= (-min1)%R)%R) -> ((is_finite1 (round_logic1 m x)) /\
  (((value1 (round_logic1 m x)) < 0%R)%R /\ ((sign2 (round_logic1 m
  x)) = Neg))).

Axiom is_gen_zero_comp11 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), ((is_gen_zero1 x) /\
  (((value1 x) = (value1 y)) /\ (is_finite1 y))) -> (is_gen_zero1 y).

Axiom is_gen_zero_comp21 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), ((is_finite1 x) /\
  ((~ (is_gen_zero1 x)) /\ ((value1 x) = (value1 y)))) -> ~ (is_gen_zero1 y).

(* Why3 assumption *)
Definition add_post1(m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (r:floating_point.DoubleFormat.double): Prop := (((is_NaN1 x) \/
  (is_NaN1 y)) -> (is_NaN1 r)) /\ ((((is_finite1 x) /\ (is_infinite1 y)) ->
  ((is_infinite1 r) /\ (same_sign1 r y))) /\ ((((is_infinite1 x) /\
  (is_finite1 y)) -> ((is_infinite1 r) /\ (same_sign1 r x))) /\
  ((((is_infinite1 x) /\ ((is_infinite1 y) /\ (same_sign1 x y))) ->
  ((is_infinite1 r) /\ (same_sign1 r x))) /\ ((((is_infinite1 x) /\
  ((is_infinite1 y) /\ (diff_sign1 x y))) -> (is_NaN1 r)) /\
  ((((is_finite1 x) /\ ((is_finite1 y) /\ (no_overflow1 m
  ((value1 x) + (value1 y))%R))) -> ((is_finite1 r) /\
  (((value1 r) = (round5 m ((value1 x) + (value1 y))%R)) /\
  (sign_zero_result1 m r)))) /\ ((((is_finite1 x) /\ ((is_finite1 y) /\
  ~ (no_overflow1 m ((value1 x) + (value1 y))%R))) ->
  ((same_sign_real (sign2 r) ((value1 x) + (value1 y))%R) /\
  (overflow_value1 m r))) /\ (((exact1 r) = ((exact1 x) + (exact1 y))%R) /\
  ((model1 r) = ((model1 x) + (model1 y))%R)))))))).

(* Why3 assumption *)
Definition sub_post1(m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (r:floating_point.DoubleFormat.double): Prop := (((is_NaN1 x) \/
  (is_NaN1 y)) -> (is_NaN1 r)) /\ ((((is_finite1 x) /\ (is_infinite1 y)) ->
  ((is_infinite1 r) /\ (diff_sign1 r y))) /\ ((((is_infinite1 x) /\
  (is_finite1 y)) -> ((is_infinite1 r) /\ (same_sign1 r x))) /\
  ((((is_infinite1 x) /\ ((is_infinite1 y) /\ (same_sign1 x y))) ->
  (is_NaN1 r)) /\ ((((is_infinite1 x) /\ ((is_infinite1 y) /\ (diff_sign1 x
  y))) -> ((is_infinite1 r) /\ (same_sign1 r x))) /\ ((((is_finite1 x) /\
  ((is_finite1 y) /\ (no_overflow1 m ((value1 x) - (value1 y))%R))) ->
  ((is_finite1 r) /\ (((value1 r) = (round5 m
  ((value1 x) - (value1 y))%R)) /\ (sign_zero_result1 m r)))) /\
  ((((is_finite1 x) /\ ((is_finite1 y) /\ ~ (no_overflow1 m
  ((value1 x) - (value1 y))%R))) -> ((same_sign_real (sign2 r)
  ((value1 x) - (value1 y))%R) /\ (overflow_value1 m r))) /\
  (((exact1 r) = ((exact1 x) - (exact1 y))%R) /\
  ((model1 r) = ((model1 x) - (model1 y))%R)))))))).

(* Why3 assumption *)
Definition product_sign1(z:floating_point.DoubleFormat.double)
  (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ((same_sign1 x y) ->
  ((sign2 z) = Pos)) /\ ((diff_sign1 x y) -> ((sign2 z) = Neg)).

(* Why3 assumption *)
Definition mul_post1(m:floating_point.Rounding.mode)
  (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (r:floating_point.DoubleFormat.double): Prop := (((is_NaN1 x) \/
  (is_NaN1 y)) -> (is_NaN1 r)) /\ ((((is_gen_zero1 x) /\ (is_infinite1 y)) ->
  (is_NaN1 r)) /\ ((((is_finite1 x) /\ ((is_infinite1 y) /\
  ~ ((value1 x) = 0%R))) -> (is_infinite1 r)) /\ ((((is_infinite1 x) /\
  (is_gen_zero1 y)) -> (is_NaN1 r)) /\ ((((is_infinite1 x) /\
  ((is_finite1 y) /\ ~ ((value1 y) = 0%R))) -> (is_infinite1 r)) /\
  ((((is_infinite1 x) /\ (is_infinite1 y)) -> (is_infinite1 r)) /\
  ((((is_finite1 x) /\ ((is_finite1 y) /\ (no_overflow1 m
  ((value1 x) * (value1 y))%R))) -> ((is_finite1 r) /\
  ((value1 r) = (round5 m ((value1 x) * (value1 y))%R)))) /\
  ((((is_finite1 x) /\ ((is_finite1 y) /\ ~ (no_overflow1 m
  ((value1 x) * (value1 y))%R))) -> (overflow_value1 m r)) /\
  ((product_sign1 r x y) /\ (((exact1 r) = ((exact1 x) * (exact1 y))%R) /\
  ((model1 r) = ((model1 x) * (model1 y))%R)))))))))).

(* Why3 assumption *)
Definition neg_post1(x:floating_point.DoubleFormat.double)
  (r:floating_point.DoubleFormat.double): Prop := ((is_NaN1 x) ->
  (is_NaN1 r)) /\ (((is_infinite1 x) -> (is_infinite1 r)) /\
  (((is_finite1 x) -> ((is_finite1 r) /\ ((value1 r) = (-(value1 x))%R))) /\
  ((diff_sign1 r x) /\ (((exact1 r) = (-(exact1 x))%R) /\
  ((model1 r) = (-(model1 x))%R))))).

(* Why3 assumption *)
Definition of_real_exact_post1(x:R)
  (r:floating_point.DoubleFormat.double): Prop := (is_finite1 r) /\
  (((value1 r) = x) /\ (((exact1 r) = x) /\ ((model1 r) = x))).

(* Why3 assumption *)
Definition le1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ((is_finite1 x) /\
  ((is_finite1 y) /\ ((value1 x) <= (value1 y))%R)) \/
  (((is_minus_infinity1 x) /\ (is_not_NaN2 y)) \/ ((is_not_NaN2 x) /\
  (is_plus_infinity1 y))).

(* Why3 assumption *)
Definition lt1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ((is_finite1 x) /\
  ((is_finite1 y) /\ ((value1 x) < (value1 y))%R)) \/
  (((is_minus_infinity1 x) /\ ((is_not_NaN2 y) /\
  ~ (is_minus_infinity1 y))) \/ ((is_not_NaN2 x) /\
  ((~ (is_plus_infinity1 x)) /\ (is_plus_infinity1 y)))).

(* Why3 assumption *)
Definition eq1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := (is_not_NaN2 x) /\
  ((is_not_NaN2 y) /\ (((is_finite1 x) /\ ((is_finite1 y) /\
  ((value1 x) = (value1 y)))) \/ ((is_infinite1 x) /\ ((is_infinite1 y) /\
  (same_sign1 x y))))).

(* Why3 assumption *)
Definition ne1(x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double): Prop := ~ (eq1 x y).

Axiom le_lt_trans1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (z:floating_point.DoubleFormat.double), ((le1 x y) /\ (lt1 y z)) -> (lt1 x
  z).

Axiom lt_le_trans1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double)
  (z:floating_point.DoubleFormat.double), ((lt1 x y) /\ (le1 y z)) -> (lt1 x
  z).

Axiom le_ge_asym1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), ((le1 x y) /\ (le1 y x)) -> (eq1 x
  y).

Axiom not_lt_ge1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), ((~ (lt1 x y)) /\
  ((is_not_NaN2 x) /\ (is_not_NaN2 y))) -> (le1 y x).

Axiom not_gt_le1 : forall (x:floating_point.DoubleFormat.double)
  (y:floating_point.DoubleFormat.double), ((~ (lt1 y x)) /\
  ((is_not_NaN2 x) /\ (is_not_NaN2 y))) -> (le1 x y).

Parameter charP : Type.

Parameter doubleP : Type.

Parameter int32 : Type.

Parameter int8 : Type.

Parameter padding : Type.

Parameter voidP : Type.

Parameter charP_tag: (Jessie_memory_model.tag_id charP).

Axiom charP_int : ((Jessie_memory_model.int_of_tag charP_tag) = 1%Z).

Parameter charP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer charP).

Axiom charP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  charP)),
  (p = (charP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom charP_parenttag_bottom : (Jessie_memory_model.parenttag charP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id charP))).

Axiom charP_tags : forall (x:(Jessie_memory_model.pointer charP)),
  forall (charP_tag_table:(Jessie_memory_model.tag_table charP)),
  (Jessie_memory_model.instanceof charP_tag_table x charP_tag).

Parameter doubleP_tag: (Jessie_memory_model.tag_id doubleP).

Axiom doubleP_int : ((Jessie_memory_model.int_of_tag doubleP_tag) = 1%Z).

Parameter doubleP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer doubleP).

Axiom doubleP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  doubleP)),
  (p = (doubleP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom doubleP_parenttag_bottom : (Jessie_memory_model.parenttag doubleP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id doubleP))).

Axiom doubleP_tags : forall (x:(Jessie_memory_model.pointer doubleP)),
  forall (doubleP_tag_table:(Jessie_memory_model.tag_table doubleP)),
  (Jessie_memory_model.instanceof doubleP_tag_table x doubleP_tag).

Parameter integer_of_int32: int32 -> Z.

(* Why3 assumption *)
Definition eq_int32(x:int32) (y:int32): Prop :=
  ((integer_of_int32 x) = (integer_of_int32 y)).

Parameter integer_of_int8: int8 -> Z.

(* Why3 assumption *)
Definition eq_int8(x:int8) (y:int8): Prop :=
  ((integer_of_int8 x) = (integer_of_int8 y)).

Parameter int32_of_integer: Z -> int32.

Axiom int32_coerce : forall (x:Z), (((-2147483648%Z)%Z <= x)%Z /\
  (x <= 2147483647%Z)%Z) -> ((integer_of_int32 (int32_of_integer x)) = x).

Axiom int32_extensionality : forall (x:int32), forall (y:int32),
  ((integer_of_int32 x) = (integer_of_int32 y)) -> (x = y).

Axiom int32_range : forall (x:int32),
  ((-2147483648%Z)%Z <= (integer_of_int32 x))%Z /\
  ((integer_of_int32 x) <= 2147483647%Z)%Z.

Parameter int8_of_integer: Z -> int8.

Axiom int8_coerce : forall (x:Z), (((-128%Z)%Z <= x)%Z /\ (x <= 127%Z)%Z) ->
  ((integer_of_int8 (int8_of_integer x)) = x).

Axiom int8_extensionality : forall (x:int8), forall (y:int8),
  ((integer_of_int8 x) = (integer_of_int8 y)) -> (x = y).

Axiom int8_range : forall (x:int8), ((-128%Z)%Z <= (integer_of_int8 x))%Z /\
  ((integer_of_int8 x) <= 127%Z)%Z.

(* Why3 assumption *)
Definition left_valid_struct_charP(p:(Jessie_memory_model.pointer charP))
  (a:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_doubleP(p:(Jessie_memory_model.pointer doubleP))
  (a:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z.

(* Why3 assumption *)
Definition left_valid_struct_voidP(p:(Jessie_memory_model.pointer voidP))
  (a:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z.

Axiom pointer_addr_of_charP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (charP_of_pointer_address p))).

Axiom pointer_addr_of_doubleP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (doubleP_of_pointer_address p))).

Parameter voidP_of_pointer_address: (Jessie_memory_model.pointer unit) ->
  (Jessie_memory_model.pointer voidP).

Axiom pointer_addr_of_voidP_of_pointer_address : forall (p:(Jessie_memory_model.pointer
  unit)),
  (p = (Jessie_memory_model.pointer_address (voidP_of_pointer_address p))).

(* Why3 assumption *)
Definition right_valid_struct_charP(p:(Jessie_memory_model.pointer charP))
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_doubleP(p:(Jessie_memory_model.pointer
  doubleP)) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop :=
  (b <= (Jessie_memory_model.offset_max doubleP_alloc_table p))%Z.

(* Why3 assumption *)
Definition right_valid_struct_voidP(p:(Jessie_memory_model.pointer voidP))
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition sorted(t:(Jessie_memory_model.pointer doubleP)) (a:Z) (b:Z)
  (doubleP_doubleM_t_1_at_L:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)): Prop := forall (i:Z), forall (j:Z),
  ((a <= i)%Z /\ ((i <= j)%Z /\ (j <= b)%Z)) ->
  (le1 (Jessie_memory_model.select doubleP_doubleM_t_1_at_L
  (Jessie_memory_model.shift t i))
  (Jessie_memory_model.select doubleP_doubleM_t_1_at_L
  (Jessie_memory_model.shift t j))).

(* Why3 assumption *)
Definition strict_valid_root_charP(p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_doubleP(p:(Jessie_memory_model.pointer doubleP))
  (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max doubleP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_root_voidP(p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_charP(p:(Jessie_memory_model.pointer charP))
  (a:Z) (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table
  charP)): Prop := ((Jessie_memory_model.offset_min charP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max charP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_doubleP(p:(Jessie_memory_model.pointer
  doubleP)) (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max doubleP_alloc_table p) = b).

(* Why3 assumption *)
Definition strict_valid_struct_voidP(p:(Jessie_memory_model.pointer voidP))
  (a:Z) (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table
  voidP)): Prop := ((Jessie_memory_model.offset_min voidP_alloc_table
  p) = a) /\ ((Jessie_memory_model.offset_max voidP_alloc_table p) = b).

(* Why3 assumption *)
Definition valid_root_charP(p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_root_doubleP(p:(Jessie_memory_model.pointer doubleP)) (a:Z)
  (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z /\ (b <= (Jessie_memory_model.offset_max doubleP_alloc_table
  p))%Z.

(* Why3 assumption *)
Definition valid_root_voidP(p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_charP(p:(Jessie_memory_model.pointer charP)) (a:Z)
  (b:Z) (charP_alloc_table:(Jessie_memory_model.alloc_table charP)): Prop :=
  ((Jessie_memory_model.offset_min charP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max charP_alloc_table p))%Z.

(* Why3 assumption *)
Definition valid_struct_doubleP(p:(Jessie_memory_model.pointer doubleP))
  (a:Z) (b:Z) (doubleP_alloc_table:(Jessie_memory_model.alloc_table
  doubleP)): Prop := ((Jessie_memory_model.offset_min doubleP_alloc_table
  p) <= a)%Z /\ (b <= (Jessie_memory_model.offset_max doubleP_alloc_table
  p))%Z.

(* Why3 assumption *)
Definition valid_struct_voidP(p:(Jessie_memory_model.pointer voidP)) (a:Z)
  (b:Z) (voidP_alloc_table:(Jessie_memory_model.alloc_table voidP)): Prop :=
  ((Jessie_memory_model.offset_min voidP_alloc_table p) <= a)%Z /\
  (b <= (Jessie_memory_model.offset_max voidP_alloc_table p))%Z.

Parameter voidP_tag: (Jessie_memory_model.tag_id voidP).

Axiom voidP_int : ((Jessie_memory_model.int_of_tag voidP_tag) = 1%Z).

Axiom voidP_of_pointer_address_of_pointer_addr : forall (p:(Jessie_memory_model.pointer
  voidP)),
  (p = (voidP_of_pointer_address (Jessie_memory_model.pointer_address p))).

Axiom voidP_parenttag_bottom : (Jessie_memory_model.parenttag voidP_tag
  (Jessie_memory_model.bottom_tag :(Jessie_memory_model.tag_id voidP))).

Axiom voidP_tags : forall (x:(Jessie_memory_model.pointer voidP)),
  forall (voidP_tag_table:(Jessie_memory_model.tag_table voidP)),
  (Jessie_memory_model.instanceof voidP_tag_table x voidP_tag).

(* Why3 assumption *)
Inductive ref (a:Type) :=
  | mk_ref : a -> ref a.
Implicit Arguments mk_ref.

(* Why3 assumption *)
Definition contents (a:Type)(v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.
Implicit Arguments contents.

Parameter eq_unit: unit -> unit -> Prop.

Parameter neq_unit: unit -> unit -> Prop.

Parameter eq_bool: bool -> bool -> Prop.

Parameter neq_bool: bool -> bool -> Prop.

Parameter lt_int: Z -> Z -> Prop.

Parameter le_int: Z -> Z -> Prop.

Parameter gt_int: Z -> Z -> Prop.

Parameter ge_int: Z -> Z -> Prop.

Parameter eq_int: Z -> Z -> Prop.

Parameter neq_int: Z -> Z -> Prop.

Parameter add_int: Z -> Z -> Z.

Parameter sub_int: Z -> Z -> Z.

Parameter mul_int: Z -> Z -> Z.

Parameter neg_int: Z -> Z.

(* Why3 assumption *)
Definition zwf_zero(a:Z) (b:Z): Prop := (0%Z <= b)%Z /\ (a < b)%Z.

Parameter lt_int_bool: Z -> Z -> bool.

Parameter le_int_bool: Z -> Z -> bool.

Parameter gt_int_bool: Z -> Z -> bool.

Parameter ge_int_bool: Z -> Z -> bool.

Parameter eq_int_bool: Z -> Z -> bool.

Parameter neq_int_bool: Z -> Z -> bool.

Axiom Lt_int_bool_axiom : forall (x:Z), forall (y:Z), ((lt_int_bool x
  y) = true) <-> (x < y)%Z.

Axiom Le_int_bool_axiom : forall (x:Z), forall (y:Z), ((le_int_bool x
  y) = true) <-> (x <= y)%Z.

Axiom Gt_int_bool_axiom : forall (x:Z), forall (y:Z), ((gt_int_bool x
  y) = true) <-> (y < x)%Z.

Axiom Ge_int_bool_axiom : forall (x:Z), forall (y:Z), ((ge_int_bool x
  y) = true) <-> (y <= x)%Z.

Axiom Eq_int_bool_axiom : forall (x:Z), forall (y:Z), ((eq_int_bool x
  y) = true) <-> (x = y).

Axiom Neq_int_bool_axiom : forall (x:Z), forall (y:Z), ((neq_int_bool x
  y) = true) <-> ~ (x = y).

Parameter abs_int: Z -> Z.

Axiom Abs_int_pos : forall (x:Z), (0%Z <= x)%Z -> ((Zabs x) = x).

Axiom Abs_int_neg : forall (x:Z), (x <= 0%Z)%Z -> ((Zabs x) = (-x)%Z).

Parameter int_max: Z -> Z -> Z.

Parameter int_min: Z -> Z -> Z.

Axiom Int_max_is_ge : forall (x:Z), forall (y:Z), (x <= (int_max x y))%Z /\
  (y <= (int_max x y))%Z.

Axiom Int_max_is_some : forall (x:Z), forall (y:Z), ((int_max x y) = x) \/
  ((int_max x y) = y).

Axiom Int_min_is_le : forall (x:Z), forall (y:Z), ((int_min x y) <= x)%Z /\
  ((int_min x y) <= y)%Z.

Axiom Int_min_is_some : forall (x:Z), forall (y:Z), ((int_min x y) = x) \/
  ((int_min x y) = y).

Parameter charP_alloc_table: (ref (Jessie_memory_model.alloc_table charP)).

Parameter charP_tag_table: (ref (Jessie_memory_model.tag_table charP)).

Parameter doubleP_alloc_table: (ref (Jessie_memory_model.alloc_table
  doubleP)).

Parameter doubleP_tag_table: (ref (Jessie_memory_model.tag_table doubleP)).

Parameter voidP_alloc_table: (ref (Jessie_memory_model.alloc_table voidP)).

Parameter voidP_tag_table: (ref (Jessie_memory_model.tag_table voidP)).

(* Why3 goal *)
Theorem WP_parameter_binary_search_ensures_failure : forall (t_0:(Jessie_memory_model.pointer
  doubleP)), forall (n:int32), forall (v:floating_point.DoubleFormat.double),
  forall (doubleP_t_2_alloc_table:(Jessie_memory_model.alloc_table doubleP)),
  forall (doubleP_doubleM_t_2:(Jessie_memory_model.memory doubleP
  floating_point.DoubleFormat.double)), ((sorted t_0 0%Z
  ((integer_of_int32 n) - 1%Z)%Z doubleP_doubleM_t_2) /\
  ((0%Z <= (integer_of_int32 n))%Z /\
  (((Jessie_memory_model.offset_min doubleP_t_2_alloc_table t_0) <= 0%Z)%Z /\
  ((((integer_of_int32 n) - 1%Z)%Z <= (Jessie_memory_model.offset_max doubleP_t_2_alloc_table
  t_0))%Z /\ ((~ (is_NaN1 v)) /\ forall (i_0:Z), ((0%Z <= i_0)%Z /\
  (i_0 <= ((integer_of_int32 n) - 1%Z)%Z)%Z) ->
  ~ (is_NaN1 (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 i_0)))))))) -> forall (result:int32),
  ((integer_of_int32 result) = 0%Z) -> forall (l:int32), (l = result) ->
  forall (result1:int32),
  ((integer_of_int32 result1) = ((integer_of_int32 n) - 1%Z)%Z) ->
  forall (u:int32), (u = result1) -> forall (u1:int32), forall (l1:int32),
  ((forall (k_0:Z), (((integer_of_int32 u1) < k_0)%Z /\
  (k_0 <= ((integer_of_int32 n) - 1%Z)%Z)%Z) -> (lt1 v
  (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 k_0)))) /\ forall (k:Z), ((0%Z <= k)%Z /\
  (k < (integer_of_int32 l1))%Z) ->
  (lt1 (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 k)) v)) ->
  (((0%Z <= (integer_of_int32 l1))%Z /\
  ((integer_of_int32 u1) <= ((integer_of_int32 n) - 1%Z)%Z)%Z) ->
  (((integer_of_int32 l1) <= (integer_of_int32 u1))%Z ->
  forall (result2:int32),
  ((integer_of_int32 result2) = ((integer_of_int32 u1) - (integer_of_int32 l1))%Z) ->
  forall (result3:int32),
  ((integer_of_int32 result3) = (ZOdiv (integer_of_int32 result2) 2%Z)) ->
  forall (result4:int32),
  ((integer_of_int32 result4) = ((integer_of_int32 l1) + (integer_of_int32 result3))%Z) ->
  forall (m:int32), (m = result4) ->
  ((((integer_of_int32 l1) <= (integer_of_int32 m))%Z /\
  ((integer_of_int32 m) <= (integer_of_int32 u1))%Z) -> let result5 :=
  (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 (integer_of_int32 m))) in
  forall (result6:bool), (((result6 = true) /\ (lt1 result5 v)) \/
  ((~ (result6 = true)) /\ ~ (lt1 result5 v))) -> ((~ (result6 = true)) ->
  let result7 := (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 (integer_of_int32 m))) in
  forall (result8:bool), (((result8 = true) /\ (lt1 v result7)) \/
  ((~ (result8 = true)) /\ ~ (lt1 v result7))) -> ((result8 = true) ->
  forall (result9:int32),
  ((integer_of_int32 result9) = ((integer_of_int32 m) - 1%Z)%Z) ->
  forall (u2:int32), (u2 = result9) -> forall (k_0:Z),
  (((integer_of_int32 u2) < k_0)%Z /\
  (k_0 <= ((integer_of_int32 n) - 1%Z)%Z)%Z) -> (lt1 v
  (Jessie_memory_model.select doubleP_doubleM_t_2
  (Jessie_memory_model.shift t_0 k_0)))))))).
intuition.
intuition.
eapply lt_le_trans1; split.
apply H26.
apply H0; subst; intuition.
Qed.


