#! /bin/bash
mkdir /tmp/widelands-$$
chmod 700 /tmp/widelands-$$
cd /tmp/widelands-$$
ulimit -c 500000
/var/lib/widelands/widelands.real --record=record --coredump=yes $@ > output
if [ $? -ne 0 ]
then
  echo "Uups, widelands seems to have crashed."
  echo
  echo "Gathering some info about your install..."
  uname -a > /tmp/widelands-$$/uname_a
  COLUMNS=120 LC_ALL=C dpkg -l widelands\* > /tmp/widelands-$$/version 2>&1
  tar cf /tmp/widelands-$$.tar /tmp/widelands-$$/ 2>/dev/null
  bzip2 -9 /tmp/widelands-$$.tar 
  echo "done"
  echo
  echo "Please report this bug using the interface on"
  echo ' http://sourceforge.net/tracker/?func=add&group_id=40163&atid=427221'
  echo
  echo "Please make sure to provide as much useful information as possible."
  echo " To that extend, you can add the file /tmp/widelands-$$.tar.bz2 to your bug report. It contains :"
  echo "  - all the actions you've made while playing (the record file)"
  echo "  - a core file (if any)"
  echo "  - all messages widelands made during the game (the output file)"
  echo "  - the architecture you're playing on (`uname -a`)"
  echo "  - the version of the game used (as repported by dpkg)"
  echo
  echo "If you have any screenshot (and if they are relevant to the bug), please include them also."
  echo
  echo "Thanks for your help, and sorry for the inconviniance,"
  echo "the widelands development team."
fi

