#! /bin/sh

# working directory. Changeable.
cd `dirname $0`

if [ -z "$1" ]; then workday=`date -d "12 hours ago" '+%Y%m%d'`; else workday=$1;fi

test=`grep $workday account/00access.act | awk '{print $1}'`
if [ ! -z "$test" ]; then echo Accounting already done for today.; exit; fi

rm -f access.log.gz >&/dev/null
cat access.log* | grep $workday'\.' | grep -v 'devel/' | grep -v 'error' >tmp.log

cc=`grep -c . tmp.log`
cd=`cat tmp.log | awk '{print $3}' | sort | uniq | grep -c .`
cs=`cat session.log* | grep -c $workday`
if [ $cd -gt 0 ]; then
  echo "$workday	$cc	$cs	$cd	$(($cc/$cd))	$(($cs/$cd))" >>account/00access.act
else
  echo "$workday	$cc	$cs	$cd	0	0" >>account/00access.act
fi

ml=`cat tmp.log | awk '{print $5}' | sort | uniq`

for i in $ml
do
if [ $i != "-" ]; then
 cc=`grep -c $i tmp.log`
 cd=`grep $i tmp.log | awk '{print $3}' | sort | uniq | grep -c .`
 j=`echo $i | tr '/' '@'`
 if [ $cd -gt 0 ]; then
  echo "$workday	$cc	$cd	$(($cc/$cd))" >>account/$j
 else
  echo "$workday	$cc	$cd	0	0" >>account/$j
 fi
fi
done

# clear unwanted module accounts
rm -f account/home account/adm@* account/devel@* account/help@* account/light >&/dev/null
tar -czf account.tgz account

# Now referer logs.

cat referer.log* | grep $workday | awk '{print $3"      	"$4}' \
	| sort | uniq | sort +1 >tmp.log

grep -v '??' tmp.log >referer/refuniq.log
a=`grep -c '??' tmp.log`
echo "$workday	$a" >>referer/refauto.cnt

sed 's!?!/!g' referer/refuniq.log | awk -F / '{print $1"/"$2}' > referer/refstem.log
awk -F / '{print $1}' referer/refstem.log >referer/refsite.log

for s in stem uniq site
do
 cat referer/ref$s.log | tr '\?' ' ' | awk '{print $2}' | uniq -c | sort -nr \
 	| awk '{print '$workday'" "$1"	"$2}' >> referer/ref$s.cnt
done

