#! /bin/sh

basedir=`pwd`
sessiond=$basedir/$module_dir/sessions/$w_wims_session
logd=$basedir/../log/classes/$w_wims_class/.src
classb=$basedir/$module_dir/classes
classd=$classb/$w_wims_class
oefname=$sessiond/submit.oef

if [ ! -d $classd ]; then
 cp -dpRf $classb/template.$w_lang $classd
 if [ ! -d $classd ]; then exit; fi
fi

if [ ! -e $classd/images ]; then
 ln -fs ../../../../log/classes/$w_wims_class/.src/images $classd
fi

namesuffix=
if [ ! -z "$w_existing" ]; then 
 namebase=$w_existing
else
 if [ -f $classd/src/$w_oef_fname.oef ]; then
  if diff -b -B -q $oefname $classd/src/$w_oef_fname.oef >/dev/null; then
   echo fail already
   exit
  fi
  max_suffix=20
  namesuffix=2
  while [ -f $classd/src/$w_oef_fname$namesuffix.oef -a $namesuffix -lt $max_suffix ]; 
  do
   if diff -b -B -q $oefname $classd/src/$w_oef_fname$namesuffix.oef >/dev/null; then
    echo fail already
    exit
   fi
   namesuffix=$(($namesuffix+1))
  done
  if [ $namesuffix -gt $(($max_suffix-1)) ]; then
   echo fail name_exhaust
   exit
  fi
 fi
 namebase=$w_oef_fname$namesuffix
fi
 
if [ ! -d "$logd" ]; then
  mkdir $logd &>/dev/null
fi
cp -f $oefname $classd/src/$namebase.oef &>/dev/null
cp -f $oefname $logd/$namebase.oef &>/dev/null
cd $classd
./mkindex >/dev/null

if [ -d $sessiond/getfile/oefimg ]; then
 mkdir -p $logd/images/$namebase
 rm -f $logd/images/$namebase/* &>/dev/null
 cp -dpR $sessiond/getfile/oefimg/* $logd/images/$namebase &>/dev/null
fi

if [ -f def/$namebase.def ]; then 
 echo success $namebase
else
 echo fail unknown
fi

