/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 /* This file is a temporary patch to tex eps files with extra borders.
  * It cuts the borders in the resulting gif file, so that the font
  * fits tightly in the cadre. libgd is required. */

#include "flydraw.h"
#include "../Lib/libwims.h"

char imagefilename[1024];
int sizex, sizey, saved;
gdImagePtr image=NULL, brushimg=NULL, tileimg=NULL, wimg=NULL;
int brushed=0,tiled=0,styled=0,width=1, savew=1, wcolor=-1;
int color_white,color_black,color_bounder;
int linecnt=-100000;
int tranged=0;
double xscale=1,yscale=1,xstart=0,ystart=0;
double tstart=0,tend=1,tstep=100,plotjump=200;
double animstep=0;
int lstep=4;
ev_variable vartab[MAX_VARS];
char varnamebuf[MAX_VARNAMEBUF], *varnameptr=varnamebuf;
int varcnt;

	/* Write the image */
void output(void)
{
    FILE *out;

    if(!image) return;
    if(imagefilename[0]) {
	out=fopen(imagefilename,"wb");
	if(out!=NULL) {gdImageGif(image,out); fclose(out); }
    }
    else gdImageGif(image,stdout);
    saved=1;
}

#include "lines.c"
#include "nametab.c"
#include "evalue.c"
#include "objects.c"

void process(void)
{
    char buf[MAX_LINELEN+1];
    int c;
    do {
	c=ggetline(buf); obj_main(buf);
    }
    while(c!=EOF);
}

int verify_tables(void) {
    return evaltab_verify();
}

int main(int argc, char *argv[])
{
    error1=error; error2=error; error3=error;
    substitute=substit;
    ev_varcnt=&varcnt; ev_var=vartab;
    if(argc==2 && strcasecmp(argv[1],"table")==0) {
	if(verify_tables()) {
	    printf("Table disorder.\n"); return 1;
	}
	printf("Table orders OK.\n"); return 0;
    }
    vartab[0].name="animstep"; vartab[0].value=0;
    varcnt=1;
    if(argc>1) snprintf(imagefilename,sizeof(imagefilename),"%s",argv[1]);
    else imagefilename[0]=0;
    process();
    if(!saved || imagefilename[0]!=0) output();
    if(image) gdImageDestroy(image);
    return 0;
}

