%{
/* inclusions, dfinition */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "unites.h"

  typedef struct{
    int i;
    double multip, maxmultip;
    uniteSI unite;
    int base[BU_LAST];
    char * s;
    double val;
  } yystype;
  
#define YYSTYPE yystype 

 extern char * yytext;
 extern FILE * yyin;

/* variables globales */
 char buffer[128], buffer2[128];
 yystype result;
 double val_real;
 long pos;

/* les units du SI */
/* Handbook of Chemistry & Physics 78, CRC Press 1997, page 1-20 */
unite_data unites[TU_LAST] ={
/*TUh*/   {"h",    "seconde",3600.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUmin*/ {"min",   "seconde", 60.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUm*/   {"m",      "mtre",   1.0,     { 1, 0, 0, 0, 0, 0, 0}},
/*TUg*/   {"g",    "kilogramme",1.0e-3,  { 0, 1, 0, 0, 0, 0, 0}},
/*TUs*/   {"s",      "seconde", 1.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUA*/   {"A",      "ampre",  1.0,     { 0, 0, 0, 1, 0, 0, 0}},
/*TUK*/   {"K",      "kelvin",  1.0,     { 0, 0, 0, 0, 1, 0, 0}},
/*TUmol*/ {"mol",    "mol",     1.0,     { 0, 0, 0, 0, 0, 1, 0}},
/*TUcd*/  {"cd",     "candela", 1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUHz*/  {"Hz",     "hetrz",   1.0,     { 0, 0,-1, 0, 0, 0, 0}},
/*TUN*/   {"N",      "newton",  1.0,     { 1, 1,-2, 0, 0, 0, 0}},
/*TUPa*/  {"Pa",     "pascal",  1.0,     {-1, 1,-2, 0, 0, 0, 0}},
/*TUJ*/   {"J",      "joule",   1.0,     { 2, 1,-2, 0, 0, 0, 0}},
/*TUW */  {"W",      "watt",    1.0,     { 2, 1,-3, 0, 0, 0, 0}},
/*TUC*/   {"C",      "coulomb", 1.0,     { 0, 0, 1, 1, 0, 0, 0}},
/*TUV*/   {"V",      "volt",    1.0,     { 2, 1,-3,-1, 0, 0, 0}},
/*TUohm*/ {"\\Omega","ohm",     1.0,     { 2, 1,-3,-2, 0, 0, 0}},
/*TUS*/   {"S",      "siemens", 1.0,     {-2,-1, 3, 2, 0, 0, 0}},
/*TUF*/   {"F",      "farad",   1.0,     {-2,-1, 4, 2, 0, 0, 0}},
/*TUT*/   {"T",      "tesla",   1.0,     { 0, 1,-2,-1, 0, 0, 0}},
/*TUWb*/  {"Wb",     "weber",   1.0,     { 2, 1,-2,-1, 0, 0, 0}},
/*TUH*/   {"H",      "henry",   1.0,     { 2, 1,-2,-2, 0, 0, 0}},
/*TUlm*/  {"lm",     "lumen",   1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUlx*/  {"lx",     "lux",     1.0,     {-2, 0, 0, 0, 0, 0, 1}},
/*TUBq */ {"Bq",     "becquerel",1.0,    { 0, 0,-1, 0, 0, 0, 0}},
/*TUGy*/  {"Gy",     "gray",     1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUSv*/  {"Sv",     "sievert",  1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUrad*/ {"rad",    "radian",   1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsr*/  {"sr" ,    "stradian",1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUnull*/{"" ,    "sans unit",1.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUda*/  {"", "degr", M_PI/180.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUpc*/  {"%", "pour cent", 0.01,       { 0, 0, 0, 0, 0, 0, 0}},
/*TUma*/  {"'", "minute", M_PI/10800,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsa*/  {"''","seconde",M_PI/648000 ,  { 0, 0, 0, 0, 0, 0, 0}},
/*TUangs*/ {"\\o{A}", "angstrm", 1e-10, { 1, 0, 0, 0, 0, 0, 0}},
/*TUbarn*/ {"b", "barn", 1e-28,          { 2, 0, 0, 0, 0, 0, 0}},
/*TUl*/    {"L", "litre", 1e-3,          { 3, 0, 0, 0, 0, 0, 0}},
/*TUt*/ {"t", "tonne", 1e3,              { 0, 1, 0, 0, 0, 0, 0}},
/*TUbar*/ {"bar", "bar", 1e5,            {-1, 1,-2, 0, 0, 0, 0}},
/*TUeV*/ {"eV", "eV", 1.60218e-19,       { 0, 0, 1, 1, 0, 0, 0}},
/*TUuam*/ {"uma", "uma", 1.66054e-27,    { 0, 1, 0, 0, 0, 0, 0}}
};

%}


%token REAL
%token SPC
%token Uh
%token Umin
%token Um
%token Ug
%token Us
%token UA
%token UK
%token Umol
%token Ucd
%token UHz
%token UN
%token UPa
%token UJ
%token UW
%token UC
%token UV
%token Uohm
%token US
%token UF
%token UT
%token UWb
%token UH
%token Ulm
%token Ulx
%token UBq
%token UGy
%token USv
%token Urad
%token Usr
%token PUIS
%token PP
%token POINT
%token BARRE
%token Uda
%token Upc
%token Uma
%token Usa
%token Uangs
%token Ubarn
%token Ul
%token Ut
%token Ubar
%token UeV
%token Uuam

%%

/* les rgles */

but : valeur_mixte {result = $1;}
| sans_unite {result = $1;}
;

valeur_mixte : valeur spc valeur_mixte {
  int i;
  for(i=0; i < BU_LAST; i++){
    if ($1.base[i] != $3.base[i]) yyerror ("homogen: not homogeneous units");
  }
  if ($1.multip <= $3.maxmultip) 
    yyerror ("order: incorrect mutiple units ordering");
  $$.val=$1.val*$1.multip+$3.val*$3.multip;
  $$.multip=1; $$.maxmultip = $1.multip;
}
| valeur {$$=$1; $$.maxmultip=$1.multip;}
;

valeur : REAL spc unite {$$=$3; $$.val=val_real; }
;

sans_unite :REAL {
  int i;
  $$.val=val_real; 
  for (i=0; i < BU_LAST; i++){$$.base[i]=unites[TUnull].base[i];} 
  $$.multip=1.0; 
  $$.s="";
}
;
 
spc : /*rien*/
|SPC
;

unite : unite suiv_unit{
  int index;
  $$.unite = TU_LAST; /* unit non renseigne */
  strcpy(buffer,$1.s); strcat(buffer,$2.s); free($1.s); free($2.s);
  $$.s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    $$.base[index] = $1.base[index]+$2.base[index] ; 
  }
  $$.multip = $1.multip*$2.multip;
}
| prim_unit { $$=$1; }
;

suiv_unit : point prim_unit{
  $$=$2; strcpy(buffer,"."); strcat(buffer,$2.s); free($2.s);
  $$.s=strdup(buffer);
}
| BARRE prim_unit{
  int index;
  $$=$2; 
  $$.multip = 1/ $$.multip;
  strcpy(buffer,"/"); strcat(buffer,$2.s); free($2.s);
  $$.s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    $$.base[index] *= -1; 
  }
}
;

point : POINT
;

prim_unit1 : 
Um base_unite {
  $$=$2;
  strcpy(buffer,"m"); strcat(buffer,$2.s); free($2.s);
  $$.s = strdup(buffer); $$.multip*=1e-3; 
}
| UT base_unite {
  $$=$2;
  strcpy(buffer,"T"); strcat(buffer,$2.s); free($2.s);
  $$.s = strdup(buffer); $$.multip*=1e12;
}
| Uh base_unite {
  $$=$2;
  strcpy(buffer,"h"); strcat(buffer,$2.s); free($2.s);
  $$.s = strdup(buffer); $$.multip*=1e2;
}
|  prefixe base_unite {
  $$=$2;
  strcpy(buffer, $1.s); strcat(buffer, $2.s);
  free($1.s); free($2.s);$$.s=strdup(buffer); 
  $$.multip*=$1.multip;
  }
| base_unite {
  $$=$1;
}
;

prim_unit : prim_unit1 puissance01 {
  int index;
  double r;

  $$.i=$2.i;
  strcpy(buffer, $1.s);
  if ($2.i!=1){
    strcat(buffer, "^{%d}"); 
    sprintf(buffer2, buffer, $2.i);
  }
  else strcpy(buffer2,buffer);
  $$.s=strdup(buffer2); free($1.s);
  for(index=0; index< BU_LAST; index++){
    $$.base[index] = unites[$1.unite].base[index]*$2.i;
  }
  for(index=0, r=1; index<$2.i ; index++){
    r*= $$.multip;
  }
  $$.multip=r;
}
;

puissance01 : /*rien*/ {$$.i=1;}
| PUIS {$$.i = atoi(yytext);}
;

prefixe : 
PP {$$.s = strdup(yytext); $$.multip=1.0;
 switch (yytext[0]){
 case 'y' : $$.multip = 1e-24; break;
 case 'z' : $$.multip = 1e-21; break;
 case 'a' : $$.multip = 1e-18; break;
 case 'f' : $$.multip = 1e-15; break;
 case 'p' : $$.multip = 1e-12; break;
 case 'n' : $$.multip = 1e-9; break;
 case '' : $$.multip = 1e-6; break;
 case 'c' : $$.multip = 1e-2; break;
 case 'd' : if (!strcmp (yytext,"da") ) $$.multip = 10.0;
    else $$.multip = 0.1; break;
 case 'h' : $$.multip = 1e2; break;
 case 'k' : $$.multip = 1e3; break;
 case 'M' : $$.multip = 1e6; break;
 case 'G' : $$.multip = 1e9; break;
 case 'P' : $$.multip = 1e15; break;
 case 'E' : $$.multip = 1e18; break;
 case 'Z' : $$.multip = 1e21; break;
 case 'Y': $$.multip = 1e24; break;
 }
}
;

base_unite :  
Uh {$$.unite=TUh; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}
| Umin {$$.unite=TUmin; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}
| Um {$$.unite=TUm; $$.s = strdup("m"); $$.multip=unites[$$.unite].multiplicateur;}
| Ug {$$.unite=TUg; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}
| Us {$$.unite=TUs; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}
| UA { $$.unite = TUA; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UK { $$.unite = TUK; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Umol { $$.unite = TUmol; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Ucd { $$.unite = TUcd; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UHz { $$.unite = TUHz; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UN { $$.unite = TUN; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UPa { $$.unite = TUPa; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UJ { $$.unite = TUJ; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}
| UT { $$.unite = TUT; $$.s = strdup("T"); $$.multip=unites[$$.unite].multiplicateur;}  
| UW { $$.unite = TUW; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UC { $$.unite = TUC; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UV { $$.unite = TUV; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Uohm { $$.unite = TUohm; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| US { $$.unite = TUS; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UF { $$.unite = TUF; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UWb { $$.unite = TUWb; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UH { $$.unite = TUH; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Ulm { $$.unite = TUlm; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Ulx { $$.unite = TUlx; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UBq { $$.unite = TUBq; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| UGy { $$.unite = TUGy; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| USv { $$.unite = TUSv; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Urad { $$.unite = TUrad; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Usr { $$.unite = TUsr; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;}  
| Uda { $$.unite = TUda; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Upc { $$.unite = TUpc; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Uma { $$.unite = TUma; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Usa { $$.unite = TUsa; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Uangs { $$.unite = TUangs; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Ubarn { $$.unite = TUbarn; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Ul { $$.unite = TUl; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Ut { $$.unite = TUt; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Ubar { $$.unite = TUbar; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| UeV { $$.unite = TUeV; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
| Uuam { $$.unite = TUuam; $$.s = strdup(yytext); $$.multip=unites[$$.unite].multiplicateur;} 
;



%%

#include "lex.yy.c"
/* le programme lui-mme */

inline int yyerror(char * msg){
  if (strstr(msg, "parse")!=0) printf("ERROR syntax: at %d, %s\n", pos, msg);
  else printf("ERROR %s\n", msg);
  exit(1);
}

void test_verbeux(){
  int i;
  yyparse();
  if (result.s) {
    if (result.unite == TU_LAST){
      printf("%s %g SI (quation aux dimensions : ", result.s, 
	     result.multip*result.val );
      for (i=0; i<BU_LAST; i++){
	printf("%3d", result.base[i]);
      }
      printf(")\n");
    }
    else {
      if (result.i!=1) 
	printf ("%s (%g %s)^{%d}\n", result.s, 
		result.multip*result.val, 
		unites[result.unite].nom, result.i);
      else printf("%s %g %s\n", result.s, 
		  result.multip*result.val, 
		  unites[result.unite].nom);
    }
  }
  else fprintf(stderr, "problme : result.s = null\n");
}

void sortie_normalisee(){
  /***************************************************/
  /* le format des donnes en sortie est :           */
  /* double int int int int int int int              */
  /* et signifie  dans l'ordre                       */
  /***************************************************/
  /* valeur                                          */
  /* puissance en unit de longueur (m)              */
  /* puissance en unit de masse (kg)                */
  /* puissance en unit de temps (s)                 */
  /* puissance en unit de courant (A)               */
  /* puissance en unit de temprature (K)           */
  /* puissance en unit de quantit de matire (mol) */
  /* puissance en unit de inutensit lumineuse (cd) */
  /* deux zros pour des extensions futures          */
  /***************************************************/
  int i;

  yyparse();
  printf("%g", result.multip*result.val );
  for (i=0; i<BU_LAST; i++){
    printf(" %3d", result.base[i]);
  }
  printf("    0    0\n");
}

int main(void){
  /*test_verbeux();*/
  sortie_normalisee();
  return 0;
}
