/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

	/* This file contains user authentification routines */

void refuse_log(int th);
void set_module_prefix(void);
void set_static_session_var(void);

	/* check machine load. 2-threshold system.
	 * Threshold 1: anonymous new session refused.
	 * Threshold 2: New session and anonymous request refused. */
void check_load(int th)
{
    int i, load;
    FILE *f;
    char buf[256];
    char *p1, *p2;
    double dload;
    if(ispriority) return; /* priority connections will not be refused. */
    if(th<0 || th>2) return;
    f=fopen("/proc/loadavg","r");
    if(f==NULL) return; /* Operating system has no load average facility. */
    i=fread(buf,1,255,f); fclose(f);
    if(robot_access && i<=0) goto refuse;
    if(i>0 && i<256) buf[i]=0; else return;
    p1=find_word_start(buf); p2=find_word_end(p1);*p2=0;
    dload=atof(p1);
    if(robot_access && 
       (!finite(dload) || dload>1000 || dload<0 || dload*200>threshold1))
      goto refuse;
    if(!finite(dload) || dload<=0 || dload>1000) return; /* unreasonable */
    	/* very small 1 min load average */
    if(dload*200<threshold1) return;
    if(dload*50>threshold2) goto refuse;
    p1=find_word_start(p2+1);	/* go to second average: 5 min. */
    *find_word_end(p1)=0;
    dload=atof(p1);
    if(!finite(dload) || dload<=0 || dload>1000) return; /* unreasonable */
    load=dload*100;
    snprintf(buf,sizeof(buf),"%d",load);
    setvar("wims_server_load",buf);
    	/* cut cpu allowance to 3/4 or half if load is high.
	 * But alarm time is not changed */
    if(load*3>=threshold1*2) {
	struct rlimit rlim;
	rlimit_cpu=(3*rlimit_cpu+1)/4;
	if(load>=threshold1) rlimit_cpu=(3*rlimit_cpu+1)/4;
	rlim.rlim_cur=rlim.rlim_max=rlimit_cpu;
	setrlimit(RLIMIT_CPU,&rlim);
    }
    if((th==0 && load*2>threshold1) ||
       (th==1 && load>threshold1) || (th==2 && load>threshold2)) {
	refuse:
	if(new_session && *session_prefix!=0) remove_tree(session_prefix);
	refuse_log(th);	user_error("threshold");
    }
}

	/* User authentification routine, obsolete */
void auth(void)
{
    check_load(1); return;
}

#define rafinfono 10

	/* check rapidfire information */
void checkrafale(void)
{
    char *p, *p1, *p2, *sh;
    char rbuf[MAX_LINELEN+1];
    time_t rr, rafinfo[rafinfono];
    int i, t, mm, rafinfocnt;
    double coef=0.23;

    if(rafalvl<=0) return;
    p=getvar("module_scoring"); if(p==NULL || strcasecmp(p,"yes")!=0) return;
    p=getvar("wims_user"); if(p!=NULL && strcmp(p,"supervisor")==0) return;
    p=getvar("wims_developer"); if(p!=NULL && *p!=0) return;
    p=getvar("wims_rafale"); if(p==NULL) p="";
    sh=getvar("wims_sheet"); if(sh!=NULL && *sh>'0') coef*=3;
    mm=0;
    for(p1=find_word_start(p),i=0;i<rafinfono && *p1;p1=find_word_start(p2)) {
	p2=find_word_end(p1); if(*p2) *p2++=0;
	rr=atol(p1); if(rr<=0 || rr>nowtime) continue;
	t=coef*rafalvl*pow(i,1+rafalvl*0.05)-(nowtime-rr); if(t>mm) mm=t;
	rafinfo[i++]=rr;
    }
    if(mm>0) user_error("rafale");
    rafinfocnt=i;
    snprintf(rbuf,sizeof(rbuf),"%lu",nowtime);
    for(i=0;i<rafinfocnt;i++) {
	snprintf(rbuf+strlen(rbuf),sizeof(rbuf)-strlen(rbuf),
		 " %lu",rafinfo[i]);
    }
    force_setvar("wims_rafale",rbuf);
}

	/* when score is got: erase 2 rafale information. */
void lessrafale(void)
{
    char *p;
    double s;
    int i;
    p=getvar("module_score"); if(p==NULL) return;
    s=atof(p); if(s<3) return;
    p=getvar("wims_rafale"); if(p==NULL || *p==0) return;
    for(i=0;i<2;i++) p=find_word_end(find_word_start(p));
    p=find_word_start(p);
    force_setvar("wims_rafale",p);
}

