/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

      /* This file contains various configuration routines for wims. */

        /* Limitations are essentially for security reasons:
         * to curb attacks by resource exhaustion of the server. */

        /* maximal length of any module's variable definition file. */
int VAR_DEF_LENGTH_LIMIT=50000;
        /* maximal nesting level of substitutions. */
int SUBST_LIMIT=16;
        /* We fix a limit for the number of goto's (or for jumps) executed,
         * in order to avoid infinite loop or DOS attack. */
int GOTO_LIMIT=500000;
        /* Limit for instex, insplot, insPLOT. */
int INS_LIMIT=500;
	/* Limit for frames in an animation. */
int ANIM_LIMIT=400;
	/* module log file length */
int MODULE_LOG_LIMIT=102400;
	/* general log file length */
int GEN_LOG_LIMIT=1024000;
	/* number of old log files */
int OLD_LOG_FILES=2;

	/* Resource limits */
int threshold1=150;	/* First load shreshold */
int threshold2=300;	/* Second load shreshold */
int ispriority=0;	/* whether the connection is from priority sites */

	/* sessions not accessed more than these seconds will be erased. */
int idle_time=5400;

int rafalvl=10; 	/* anti-rapidfire severity */

	/* Explanation: two real numbers a,b such that
	 * |a+b|>|a-b|*compare_precision
	 * will be considered equal in !ifvalue comparisons. */
int DEFAULT_COMPARE_PRECISION=10000;
	/* Precision of printing (hence of all evaluations). */
int DEFAULT_PRINT_PRECISION=8;
	/* Defaults for instex, insplot, etc. */
char *DEFAULT_INS_FORMAT="gif";
char *DEFAULT_ANIM_FORMAT="gif";
char *DEFAULT_INS_DENSITY="100x100";
char *DEFAULT_TEXSIZE="0";
char *DEFAULT_INSPLOT_FONT="small";

	/* gnuplot intermediate graphics format */
char *gnuplot_format="jpeg";

  /* electronic address of site manager. */
char *site_manager="wims@$httpd_HTTP_HOST";
  /* Main configure file, this name cannot be configured! */
char *config_file="wims.conf";
  /* directory settings */
char PATH[2048];
#ifdef MACOSX
 char *commonpath="/usr/local/bin:/usr/bin:/usr/games:/bin:/sw/bin:/usr/bin/X11:/usr/X11R6/bin";
#else
 char *commonpath="/usr/local/bin:/usr/bin:/usr/games:/bin:/usr/bin/X11:/usr/X11R6/bin:/opt/teTeX/bin";
#endif
char *gap_command="gap.sh -T";
char *maxima_command="maxima";
char *mupad_command="/usr/local/lib/mupad/share/bin/mupad";
char *pari_command="gp -f -q -p 150000";

  /* default languages */
char *site_languages="en fr cn es it";
  /* Statistics shows up? */
char *show_stat="no";
  /* directory of session files */	
char *session_dir="../sessions";
  /* root directory of modules */
char *module_dir="modules";
  /* standardised header model for modules' output. Will be stored
   * into the variable $wims_html_header. */
char *html_header="html/header.phtml";
  /* standardised about table for modules */
char *module_about_file="html/module_about";
  /* title definition page */
char *title_page="title.phtml";
  /* stardardised header menu bar, to be included in module pages
   * via command !headmenu */
char *header_menu="headmenu.phtml";
char *header_menu_user="headmenu_user.phtml";
char *header_menu_supervisor="headmenu_supervisor.phtml";
  /* standardised referer to wims home, to be included in 
   * module pages via command !homeref */
char *home_referer="homeref.phtml";
char *home_referer_user="homeref_user.phtml";
char *home_referer_supervisor="homeref_supervisor.phtml";
  /* background color in standard reference tables */
char *ref_bgcolor="#d0c080";
  /* module log disabled by default */
int modlog=0;
  /* name of the variable definition file for every module. 
   * It is this file which defines the presence of the module.
   * Better do not make it configurable. */
char *var_def_file="var.def";
  /* name of variable init file. Processed only when cmd=new or renew. */
char *var_init_file="var.init";
  /* name of variable calculation file. Parsed at each call. */
char *main_var_proc_file="var.proc";
  /* name of the main (programmable) html file. */
char *html_file="main.phtml";
  /* Introduction page name */
char *intro_file="intro.phtml";
  /* script to process different inserts.
   * The two consecutive points in the name prohibits ordinary
   * user execution of the script. */
char *insdraw_processor="insdraw..processor";
char *insplot_processor="insplot..processor";
char *tex2gif="bin/tex..gif";
char *priority="";		/* IPs of priority sites */
char *texgif_fontdir="mathfonts/texgif";
char *texgif_texheader="mathfonts/header";
char *bgcolor="#E8E8E8";	/* page background color */
char *bgimg="";			/* page background image file */
char *pagecss="justify";		/* style sheet file */
char *usecookie="no";		/* whether to send cookies to anon requests */
int mathalign_base=1;		/* user <sup> for middle alignment */

  /* keywords destinated to robots */
char *site_keywords="interactive mathematics, interactive math, server side interactivity";
char *site_description="interactive exercises, online calculators and plotters, mathematical recreation and games";

  /* site manager definition */
char *manager_site="127.0.0.1";
int   manager_https=0;

  /* class and document authorization */
int class_quota=64;
int doc_quota=32;
char *class_regpass="email";
char *doc_regpass="";

  /* wims.conf file stat */
struct stat confstat;

  /* Definition for encyclopedia links */
char *pedia_address="http://wims.unice.fr/wims/wims.cgi";
int  pedia_type=1; /* Now defaults to internal */

  /* Where to find programs; if your httpd sets /bin:/usr/bin in PATH,
   * this should be OK. */
char *sed_prog="sed";
char *tr_prog="tr";
char *awk_prog="awk";

  /* myname */
char *cgi_name="wims.cgi";
char *aliased_cgi="no";

  /* Limits for classes and participants */
int class_limit=100; /* limit of number of classes */
int user_limit=3000; /* limit of total number of registered users */
int class_user_limit=300; /* limit of users in one class */
int forum_limit=100;  /* Limit of message boards */

typedef struct {
    char *name;
    int is_integer;
    void  *address;
} CONFIG_DATA;

CONFIG_DATA main_config[]={
      {"PATH",			0, &commonpath},
      {"aliased_cgi",		0, &aliased_cgi},
      {"cgi_name",		0, &cgi_name},
      {"class_limit",		1, &class_limit},
      {"class_quota",		1, &class_quota},
      {"class_regpass",		0, &class_regpass},
      {"class_user_limit",	1, &class_user_limit},
      {"css",			0, &pagecss},
      {"default_anim_format",	0, &DEFAULT_ANIM_FORMAT},
      {"default_ins_format",	0, &DEFAULT_INS_FORMAT},
      {"default_insplot_font",	0, &DEFAULT_INSPLOT_FONT},
      {"default_texsize",	0, &DEFAULT_TEXSIZE},
      {"doc_quota",		1, &doc_quota},
      {"doc_regpass",		0, &doc_regpass},
      {"encyclopedia_address",	0, &pedia_address},
      {"encyclopedia_type",	1, &pedia_type},
      {"forum_limit",		1, &forum_limit},
      {"gap_command",		2, &gap_command},
      {"general_log_limit",	1, &GEN_LOG_LIMIT},
      {"gnuplot_format",	0, &gnuplot_format},
      {"home_module",		0, &home_module},
      {"idle_time",		1, &idle_time},
      {"insdraw_processor",	0, &insdraw_processor},
      {"manager_https",		1, &manager_https},
      {"manager_site",		0, &manager_site},
      {"maxima_command",	2, &maxima_command},
      {"module_log",		1, &modlog},
      {"module_log_limit",	1, &MODULE_LOG_LIMIT},
      {"mupad_command",		2, &mupad_command},
      {"old_log_files",		1, &OLD_LOG_FILES},
      {"page_bgcolor",		0, &bgcolor},
      {"page_bgimg",		0, &bgimg},
      {"pari_command",		2, &pari_command},
      {"priority",		0, &priority},
      {"rafale_level",		1, &rafalvl},
      {"ref_bgcolor",		0, &ref_bgcolor},
      {"rlimit_cpu",		1, &rlimit_cpu},
      {"show_stat",		0, &show_stat},
      {"site_description",	0, &site_description},
      {"site_keywords",		0, &site_keywords},
      {"site_languages",	0, &site_languages},
      {"site_manager",		0, &site_manager},
      {"texbasesize",		1, &texbasesize},
      {"threshold1",		1, &threshold1},
      {"threshold2",		1, &threshold2},
      {"tmp_debug",		0, &tmp_debug},
      {"trusted_modules",	0, &trusted_modules},
      {"usecookie",		0, &usecookie},
      {"user_limit",		1, &user_limit},
      {"var_def_length_limit",	1, &VAR_DEF_LENGTH_LIMIT},
      {"workfile_limit",	1, &WORKFILE_LIMIT}
};
#define MAIN_CONFIG_NO (sizeof(main_config)/sizeof(main_config[0]))

	/* processes the list of languages supported on the site */
void language_list(void)
{
    int i;
    char *l,lbuf[MAX_LANGUAGES*4];
    for(i=0,l=find_word_start(site_languages);
	i<MAX_LANGUAGES && *l!=0 && *(l+1)!=0;i++) {
	if(!isalpha(*l) || !isalpha(*(l+1)) || isalpha(*(l+2))) break;
	memmove(available_lang[i],l,2);
	available_lang[i][2]=0;
	for(l+=2;*l!=0 && !isalpha(*l); l++);
    }
    if(i>0) available_lang_no=i;
    for(i=0,lbuf[0]=0;i<available_lang_no;i++) {
	strcat(lbuf,available_lang[i]);
	if(i<available_lang_no-1) strcat(lbuf," ");
    }
    setvar("wims_site_languages",lbuf);
    if(i>0) {
	memmove(lang,lbuf,2); lang[2]=0;
    }
}

char hostname[1024];
int html_call=0;

	/* determine the http reference name of the server */
void determine_ref_name(void)
{
    char *s1, *s2, *p;
    char buf[MAX_LINELEN+1];
    
    s1=getenv("HTTP_HOST");s2=getenv("SCRIPT_NAME");
    if((s1==NULL || *s1==0) 
       && gethostname(hostname,sizeof(hostname))==0) s1=hostname;
    hostname[sizeof(hostname)-1]=0; ref_base[0]=0;
    if(s2!=NULL) snprintf(buf,sizeof(buf),"%s",s2);
    else buf[0]=0; 
    if(s1!=NULL && *buf=='/') {
	p=strrchr(buf,'/'); if(p==NULL) p=buf; else *p++=0;
	if(strcmp(p,cgi_name)!=0 && strlen(p)>4 &&
	   p[2]=='_' && islower(p[0]) && islower(p[1])) {
	    pre_language[0]=p[0];pre_language[1]=p[1];pre_language[2]=0;
	    p[2]=0; setenv("HTTP_ACCEPT_LANGUAGE",p,1); p+=3;
	    s2=strrchr(p,'.'); if(s2!=NULL) {
		*s2=0; if(strcasecmp(s2+1,"cgi")!=0) html_call=1;
	    }
	    s2=p; while((s2=strpbrk(s2,"@~"))!=NULL) *s2='/';
	    setvar(ro_name[ro_module],p); module_defined=1;
	}
	snprintf(ref_name,sizeof(ref_name)-1,"http://%s%s/%s",s1,buf,cgi_name);
	strcpy(ref_base,ref_name);
	p=strrchr(ref_base,'/');
	if(p!=NULL) *(p+1)=0;
    }
    else snprintf(ref_name,sizeof(ref_name)-1,"%s",cgi_name);
    setvar("wims_ref_name",ref_name);
}

	/* Read and interprete wims configuration file. */
void main_configure(void)
{
    int conf_len,conf_read_len;
    int i,l;
    char *conf_buf,*e,*p,*p2;
    FILE *conf;

    if(stat(config_file,&confstat)!=0) goto fileend;
    conf=fopen(config_file,"r");
    if(conf==NULL) goto fileend;
    fseek(conf,0,SEEK_END);
    conf_len=ftell(conf);
    if(conf_len<=0) goto fileend;
    conf_buf=xmalloc(conf_len+2);
    fseek(conf,0,SEEK_SET);
    conf_read_len=fread(conf_buf,1,conf_len,conf);
    fclose(conf);
    if(conf_read_len>conf_len || conf_read_len<=0) goto fileend;
    *(conf_buf+conf_read_len)=0;
    e=conf_buf-1;
    for(l=0; e<conf_buf+conf_read_len && e!=NULL ;l++) {
	p=e+1;
rep:    e=strchr(p,'\n');
	if(e!=NULL && e>p && *(e-1)=='\\') {  /* escaped new-line */
	    *(e-1)=' '; l++; goto rep;
	}
	if(e!=NULL) *e=0;   /* make string out of a line */
	strip_trailing_spaces(p); p=find_word_start(p);
	if(*p==0 || *p==comment_prefix_char) continue; /* empty or comment line */
	p2=strchr(p,'=');
	if(p2==NULL) continue; /* syntax error */
	*p2=0; *find_word_end(p)=0; p2=find_word_start(p2+1);
	i=search_list(main_config,MAIN_CONFIG_NO,sizeof(main_config[0]),p);
	if(i<0) continue; /* name non-defined */
	if(main_config[i].is_integer==1) {
	    int *ip;
	    ip=main_config[i].address;
	    *ip=atoi(p2); if(*ip<0) *ip=0;
	}
	else {
	    char **cp;
	    cp=main_config[i].address;
	    *cp=p2;
	}
    }
    fileend:
    setenv("session_base_dir",session_dir,1);
    determine_ref_name();
    language_list();
    for(i=0;i<MAIN_CONFIG_NO;i++) {
	char **pp;
	if(main_config[i].is_integer==2) {
	    pp=main_config[i].address;
	    setenv(main_config[i].name,*pp,1);
	}
    }
    	/* check priority */
    p=getenv("REMOTE_ADDR"); if(p!=NULL) remote_addr=p;
    p=getenv("REMOTE_HOST"); if(p!=NULL) remote_host=p;
    if(priority[0] && checkhost(priority)>0) ispriority=1;
    getcwd(cwdbuf,sizeof(cwdbuf)); setvar("httpd_PWD",cwdbuf);
    setenv("wims_server_base",cwdbuf,1);
    p=strrchr(cwdbuf,'/');
    if(p!=NULL && strcmp(p,"/public_html")==0) {
	*p=0; snprintf(PATH,sizeof(PATH),"%s/other/bin:%s",cwdbuf,commonpath);
	*p='/';
    }
    else snprintf(PATH,sizeof(PATH),"%s/../other/bin:%s",cwdbuf,commonpath);
    setenv("PATH",PATH,1);
}

struct {
    int rname;
    int *rval;
} resource_table[]={
      {RLIMIT_CPU,	&rlimit_cpu},
      {RLIMIT_FSIZE, 	&rlimit_fsize},
      {RLIMIT_DATA,	&rlimit_data},
      {RLIMIT_STACK,	&rlimit_stack},
      {RLIMIT_CORE,	&rlimit_core},
      {RLIMIT_RSS,	&rlimit_rss},
      {RLIMIT_NPROC,	&rlimit_nproc},
      {RLIMIT_NOFILE,	&rlimit_nofile},
      {RLIMIT_MEMLOCK,	&rlimit_memlock}
};
#define RESOURCE_NO (sizeof(resource_table)/sizeof(resource_table[0]))

	/* set system resource limits */
void set_rlimits(void)
{
    int i;
    struct rlimit rlim;
    
    for(i=0;i<RESOURCE_NO;i++) {
	rlim.rlim_cur=rlim.rlim_max=*(resource_table[i].rval);
	setrlimit(resource_table[i].rname,&rlim);
	if(resource_table[i].rname==RLIMIT_CPU) {
	    char buf[256];
	    snprintf(buf,sizeof(buf),"%u",(int) rlim.rlim_max);
	    setvar("wims_cpu_limit",buf);
	    initalarm();
	}
    }
}

struct {
    char *name;
    int is_integer;
    void *default_value;
} module_default[]={
      {"anim_format",		0, &DEFAULT_ANIM_FORMAT},
      {"gnuplot_format",	0, &gnuplot_format},
      {"ins_anim_limit",	1, &ANIM_LIMIT},
      {"ins_density",		0, &DEFAULT_INS_DENSITY},
      {"ins_format",		0, &DEFAULT_INS_FORMAT},
      {"insplot_font",		0, &DEFAULT_INSPLOT_FONT},
      {"wims_class_limit",	1, &class_limit},
      {"wims_class_quota",	1, &class_quota},
      {"wims_class_regpass",	0, &class_regpass},
      {"wims_class_user_limit",	1, &class_user_limit},
      {"wims_compare_precision",1, &DEFAULT_COMPARE_PRECISION},
      {"wims_doc_quota",	1, &doc_quota},
      {"wims_doc_regpass",	0, &doc_regpass},
      {"wims_forum_limit",	1, &forum_limit},
      {"wims_bgcolor",		0, &bgcolor},
      {"wims_bgimg",		0, &bgimg},
      {"wims_css",		0, &pagecss},
      {"wims_pedia_address",	0, &pedia_address},
      {"wims_pedia_type",	1, &pedia_type},
      {"wims_print_precision", 	1, &DEFAULT_PRINT_PRECISION},
      {"wims_ref_bgcolor",	0, &ref_bgcolor},
      {"wims_show_stat",	0, &show_stat},
      {"wims_site_description",	0, &site_description},
      {"wims_site_keywords",	0, &site_keywords},
      {"wims_site_manager",	0, &site_manager},
      {"wims_tmp_debug",	0, &tmp_debug},
      {"wims_texsize",		0, &DEFAULT_TEXSIZE},
      {"wims_usecookie",	0, &usecookie},
      {"wims_user_limit",	1, &user_limit}
};
#define MODULE_DEFAULT_NO (sizeof(module_default)/sizeof(module_default[0]))

	/* Set defaults for module, and set corresponding variables. */
void module_configure(void)
{
    int i;
    confset=1;
    for(i=0;i<MODULE_DEFAULT_NO;i++) {
	if(module_default[i].is_integer) {
	    int j, *jp;
	    char buf[256];
	    jp=module_default[i].default_value;
	    j=*jp; if(j<0) j=0;
	    snprintf(buf,sizeof(buf),"%d",j);
	    setvar(module_default[i].name,buf);
	}
	else {
	    char **cp;
	    cp=module_default[i].default_value;
	    setvar(module_default[i].name,*cp);
	}
    }
    setenv("texgif_fontdir",texgif_fontdir,1);
    setenv("texgif_texheader",texgif_texheader,1);
    confset=0;
}

char *modindex[]={
      "title", "description", 
      "author", "address", "copyright",
      "translator","translator_address",
      "version", "wims_version", "language", "mode",
      "category", "level", "domain", "keywords", "scoring",
      "require", "help"
};
#define MODINDEX_NO (sizeof(modindex)/sizeof(modindex[0]))
char *module_special_file[]={
    "intro","help"
};
#define MODSPEC_NO (sizeof(module_special_file)/sizeof(module_special_file[0]))

#ifdef WEBMATH

	/* read and treat module's INDEX file */
void module_index(void)
{
    char buf[MAX_LINELEN+1];
    char *ind_buf, *e, *p, *p2;
    int i,l;
    FILE *indf, *tf;
    long indf_len, indf_read_len;
    
    snprintf(buf,sizeof(buf),"%s/INDEX",module_prefix);
    indf=fopen(buf,"r");
    if(indf==NULL) {
	snprintf(buf,sizeof(buf),"%s/index",module_prefix);
	indf=fopen(buf,"r");
    }
    if(indf==NULL) return;
    fseek(indf,0,SEEK_END);
    indf_len=ftell(indf);
    if(indf_len<=0) return;
    ind_buf=xmalloc(indf_len+2);
    fseek(indf,0,SEEK_SET);
    indf_read_len=fread(ind_buf,1,indf_len,indf);
    fclose(indf);    
    if(indf_read_len>indf_len || indf_read_len<=0) return;
    *(ind_buf+indf_read_len)=0;
    e=ind_buf-1;
    for(l=0; e<ind_buf+indf_read_len && e!=NULL ;l++) {
	p=e+1;
rep:    e=strchr(p,'\n');
	if(e!=NULL && e>p && *(e-1)=='\\') {  /* escaped new-line */
	    *(e-1)=' '; l++; goto rep;
	}
	if(e!=NULL) *e=0;   /* make string out of a line */
	strip_trailing_spaces(p); p=find_word_start(p);
	if(*p==0 || *p==comment_prefix_char) continue; /* empty or comment line */
	p2=strchr(p,'=');
	if(p2==NULL) continue; /* syntax error */
	*p2=0; *find_word_end(p)=0; p2=find_word_start(p2+1);
	for(i=0;i<MODINDEX_NO && strcasecmp(p,modindex[i])!=0;i++);
	if(i>=MODINDEX_NO) continue; /* name not in list */
	snprintf(buf,sizeof(buf),"module_%s",p);
	setvar(buf,p2);
    }
    free(ind_buf);
    if(mode!=mode_default) {
	char *s;
	s=getvar("module_mode");
	if(s==NULL) {
	    nomode: mode=mode_default; force_setvar("wims_mode","");
	}
	else switch(mode) {
	    case mode_popup: {
		if(strstr(s,"popup")==NULL) goto nomode;
		else break;
	    }
	    case mode_raw: {
		if(strstr(s,"raw")==NULL) goto nomode;
		else break;
	    }
	    default: break;
	}
    }
    	/* test for existence of some special files in module's directory */
    for(i=0;i<MODSPEC_NO;i++) {
	snprintf(buf,sizeof(buf),"%s/%s.phtml",module_prefix,module_special_file[i]);
	tf=fopen(buf,"r");
	if(tf!=NULL) {
	    fclose(tf);
	    snprintf(buf,sizeof(buf),"module_has_%s",module_special_file[i]);
	    setvar(buf,"yes");
	}
    }
    setvar("module_has_about","yes"); /* now we have default about.phtml */
}

#endif

	/* Set up a unique job identity */
unsigned long create_job_ident(void)
{
    unsigned long it;
    	/* Is this enough to guarantee uniqueness? */
    
    it=(nowtime<<16)+(getpid()&0xffff);
    	/* The encryption is very simple. */
    it=it^0x5a3c9671;
    return it;
}

	/* Setup a job identifier */
void set_job_ident(void)
{
    unsigned long l,r;
    
    l=create_job_ident();
    /* the last 4 bits always make 0xA. A bug of glibc random()? */
    r=random()>>4;
    snprintf(job_identifier,sizeof(job_identifier),"%lX%08lX",r,l);
    setvar("job_identifier",job_identifier);
}

	/* define the variable $wims_html_header */
void define_html_header(void)
{
    char *expir, *sp, *cp, *mp;
    char buf[MAX_LINELEN+1];
    char *nocache="<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">\n\
<META HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\">\n";
    FILE *f;
    int i, noc;
    time_t t;

    noc=0; 
    cp=getvar("wims_expire"); if(cp!=NULL) goto css;
    if(!robot_access && cmd_type==cmd_intro && isclassmodule) {
	sp=getvar("special_parm"); if(sp==NULL) sp="";
	if(strcmp(sp,".nocache.")==0) {
	    force_setvar("special_parm",""); noc=1;
	}
	if(!noc) {
	    mp=getvar(ro_name[ro_module]);
	    if(mp!=NULL && strncmp(mp,"devel/",strlen("devel/"))==0) noc=1;
	}
    }
    if(mode==mode_default) {
	if(!robot_access && (cmd_type!=cmd_intro || noc)) {
	    if(html_call) {
		/* expiration in 1 day for html call. */
		t=nowtime+(long) 24*3600; expir=ctime(&t);
		nocache="";
	    }
	    else expir="1 Jan 1990";
	}
	else {
	    /* expiration in 10 days for robot access or intro page. */
	    t=nowtime+(long) 10*24*3600; expir=ctime(&t); nocache="";
	}
	snprintf(buf,sizeof(buf),
		 "<META HTTP-EQUIV=\"expires\" CONTENT=\"%s\">\n%s",expir,nocache);
	setvar("wims_expire",buf);
    }
    css: setvar("wims_CSS","");
    cp=getvar("wims_css"); 
    if(!robot_access && cp!=NULL && *cp!=0 && strstr(cp,"---")==NULL) {
	char nbuf[MAX_LINELEN+1];
	cp=find_word_start(cp);
	if(strchr(cp,'/')==NULL) {
	    char *pc;
	    pc=getvar("wims_class");
	    if(pc!=NULL && *pc!=0 && strcmp(cp,"class")==0) 
	      snprintf(nbuf,sizeof(nbuf),"../log/classes/%s/css",pc);
	    else snprintf(nbuf,sizeof(nbuf),"html/css/%s/%s.css",lang,cp);
	    f=fopen(nbuf,"r");
	    if(f!=NULL) {
		i=fread(nbuf,1,MAX_LINELEN,f);
		if(i>0 && i<MAX_LINELEN) {
		    nbuf[i]=0;
		    snprintf(buf,sizeof(buf),"<STYLE TYPE=\"text/css\"><!--\n\
%s\n\
--></STYLE>",nbuf);
		    setvar("wims_CSS",buf);
		}
		fclose(f);
	    }
	    else {
		
		
	    }
	}
    }
    f=fopen(html_header,"r");
    if(f==NULL) return; /* Silent if header file not found. */
    i=fread(buf,1,MAX_LINELEN,f);
    if(i<=0 || i>MAX_LINELEN) return;
    buf[i]=0;fclose(f);
    setvar("wims_html_header",buf);
}

char log_date[32],log_time[32];

	/* get date string in yyyymmdd */
void log_date_time(void)
{
    snprintf(log_date,sizeof(log_date),"%04d%02d%02d",
	     (now->tm_year)+1900, (now->tm_mon)+1, now->tm_mday);
    snprintf(log_time,sizeof(log_time),"%02d:%02d:%02d",
	     now->tm_hour, now->tm_min, now->tm_sec);
}

