/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.LimitedLineReader;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;

public class Resolver {
    private static final String classBase = "org.jmol.adapter.readers.";
    private static final String[] readerSets = new String[]{"cifpdb.", "Cif;Pdb;", "molxyz.", "Mol;Xyz;", "xml.", "Xml;"};
    private static final String CML_NAMESPACE_URI = "http://www.xml-cml.org/schema";
    private static final int SPECIAL_JME = 0;
    private static final int SPECIAL_MOPACGRAPHF = 1;
    private static final int SPECIAL_V3000 = 2;
    private static final int SPECIAL_ODYSSEY = 3;
    private static final int SPECIAL_MOL = 4;
    private static final int SPECIAL_XYZ = 5;
    private static final int SPECIAL_FOLDINGXYZ = 6;
    private static final int SPECIAL_CUBE = 7;
    private static final int SPECIAL_ALCHEMY = 8;
    public static final int SPECIAL_ARGUS_XML = 9;
    public static final int SPECIAL_CML_XML = 10;
    public static final int SPECIAL_CHEM3D_XML = 11;
    public static final int SPECIAL_MOLPRO_XML = 12;
    public static final int SPECIAL_ODYSSEY_XML = 13;
    public static final int SPECIAL_ARGUS_DOM = 14;
    public static final int SPECIAL_CML_DOM = 15;
    public static final int SPECIAL_CHEM3D_DOM = 16;
    public static final int SPECIAL_MOLPRO_DOM = 17;
    public static final int SPECIAL_ODYSSEY_DOM = 18;
    public static final String[][] specialTags = new String[][]{{"Jme"}, {"MopacGraphf"}, {"V3000"}, {"Odyssey"}, {"Mol"}, {"Xyz"}, {"FoldingXyz"}, {"Cube"}, {"Alchemy"}, {"argus(xml)"}, {"cml(xml)"}, {"chem3d(xml)"}, {"molpro(xml)"}, {"odyssey(xml)"}, {"argus(DOM)"}, {"cml(DOM)"}, {"chem3d(DOM)"}, {"molpro(DOM)"}, {"odyssey(DOM)"}, {"MdCrd"}};
    private static final int LEADER_CHAR_MAX = 20;
    private static final String[] cubeFileStartRecords = new String[]{"Cube", "JVXL", "#JVXL"};
    private static final String[] mol2Records = new String[]{"Mol2", "mol2", "@<TRIPOS>"};
    private static final String[] webmoFileStartRecords = new String[]{"WebMO", "[HEADER]"};
    private static final String[] moldenFileStartRecords = new String[]{"Molden", "[Molden"};
    private static final String[][] fileStartsWithRecords = new String[][]{cubeFileStartRecords, mol2Records, webmoFileStartRecords, moldenFileStartRecords};
    private static final String[] pqrLineStartRecords = new String[]{"Pqr", "REMARK   1 PQR"};
    private static final String[] pdbLineStartRecords = new String[]{"Pdb", "HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL "};
    private static final String[] shelxLineStartRecords = new String[]{"Shelx", "TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    private static final String[] cifLineStartRecords = new String[]{"Cif", "data_", "_publ"};
    private static final String[] ghemicalMMLineStartRecords = new String[]{"GhemicalMM", "!Header mm1gp", "!Header gpr"};
    private static final String[] jaguarLineStartRecords = new String[]{"Jaguar", "  |  Jaguar version"};
    private static final String[] hinLineStartRecords = new String[]{"Hin", "mol "};
    private static final String[] mdlLineStartRecords = new String[]{"Mol", "$MDL "};
    private static final String[] spartanSmolLineStartRecords = new String[]{"SpartanSmol", "INPUT="};
    private static final String[] csfLineStartRecords = new String[]{"Csf", "local_transform"};
    private static final String[] mdTopLineStartRecords = new String[]{"MdTop", "%FLAG TITLE"};
    private static final String[][] lineStartsWithRecords = new String[][]{cifLineStartRecords, pqrLineStartRecords, pdbLineStartRecords, shelxLineStartRecords, ghemicalMMLineStartRecords, jaguarLineStartRecords, hinLineStartRecords, mdlLineStartRecords, spartanSmolLineStartRecords, csfLineStartRecords, mol2Records, mdTopLineStartRecords};
    private static final String[] xmlContainsRecords = new String[]{"Xml", "<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    private static final String[] gaussianContainsRecords = new String[]{"Gaussian", "Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    private static final String[] mopacContainsRecords = new String[]{"Mopac", "MOPAC 93 (c) Fujitsu", "MOPAC2002 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)"};
    private static final String[] qchemContainsRecords = new String[]{"Qchem", "Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    private static final String[] gamessUKContainsRecords = new String[]{"GamessUK", "GAMESS-UK", "G A M E S S - U K"};
    private static final String[] gamessUSContainsRecords = new String[]{"GamessUS", "GAMESS"};
    private static final String[] spartanBinaryContainsRecords = new String[]{"SpartanSmol", "|PropertyArchive", "_spartan", "spardir"};
    private static final String[] spartanContainsRecords = new String[]{"Spartan", "Spartan"};
    private static final String[] adfContainsRecords = new String[]{"Adf", "Amsterdam Density Functional"};
    private static final String[] psiContainsRecords = new String[]{"Psi", "    PSI  3"};
    private static final String[] nwchemContainsRecords = new String[]{"NWChem", " argument  1 = "};
    private static final String[][] containsRecords = new String[][]{xmlContainsRecords, gaussianContainsRecords, mopacContainsRecords, qchemContainsRecords, gamessUKContainsRecords, gamessUSContainsRecords, spartanBinaryContainsRecords, spartanContainsRecords, mol2Records, adfContainsRecords, psiContainsRecords, nwchemContainsRecords};

    static String getFileType(BufferedReader bufferedReader) {
        try {
            return Resolver.determineAtomSetCollectionReader(bufferedReader, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String[] specialLoad(String string, String string2) {
        int n = string.lastIndexOf(".spardir");
        boolean bl = string2.equals("filesNeeded?");
        if (bl) {
            if (string.endsWith(".spt")) {
                return new String[]{null, null, null};
            }
            if (string.endsWith(".spardir.zip")) {
                return new String[]{"SpartanSmol", "Directory Entry ", "?|output"};
            }
            if (!(string = string.replace('\\', '/')).endsWith(".spardir") && string.indexOf(".spardir/") < 0) {
                return null;
            }
            if (n < 0) {
                return null;
            }
            if (string.lastIndexOf("/") > n) {
                return new String[]{"SpartanSmol", "Directory Entry ", string + "/input", string + "/archive", string + "/Molecule:asBinaryString", string + "/proparc"};
            }
            return new String[]{"SpartanSmol", "Directory Entry ", string + "/output"};
        }
        String[] stringArray = Resolver.getSpartanDirs(string2);
        if (stringArray.length == 0 && string.endsWith(".spardir.zip") && string2.indexOf(".zip|output") >= 0) {
            String string3 = string.replace('\\', '/');
            n = string3.lastIndexOf("/");
            string3 = string + "|" + string.substring(n + 1, string.length() - 4);
            return new String[]{"SpartanSmol", string3, string3 + "/output"};
        }
        return Resolver.getSpartanFileList(string, stringArray);
    }

    static String[] checkSpecialInZip(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 2) {
            stringArray2 = null;
        } else {
            String string = stringArray[1];
            if (string.endsWith(".spardir/") || stringArray.length == 2) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            } else {
                stringArray2 = null;
            }
        }
        return stringArray2;
    }

    static StringBuffer checkSpecialData(InputStream inputStream, String[] stringArray) {
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Zip File Directory: ").append("\n").append(Escape.escape(stringArray)).append("\n");
        Hashtable hashtable = new Hashtable();
        ZipUtil.getAllData(inputStream, new String[0], "", "Molecule", hashtable);
        String string = "|";
        String string2 = (String)hashtable.get(string + "output");
        if (string2 == null) {
            string = "|" + stringArray[1];
            string2 = (String)hashtable.get(string + "output");
        }
        stringBuffer.append(string2);
        String[] stringArray2 = Resolver.getSpartanFileList(string, Resolver.getSpartanDirs(string2));
        for (int i = 2; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (hashtable.containsKey(string3)) {
                stringBuffer.append(hashtable.get(string3));
                continue;
            }
            stringBuffer.append(string3 + "\n");
        }
        return stringBuffer;
    }

    static Object getAtomCollectionAndCloseReader(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable, int n) throws Exception {
        String string3;
        AtomSetCollectionReader atomSetCollectionReader = null;
        String string4 = null;
        if (string2 != null) {
            string3 = Resolver.getReaderFromType(string2);
            if (string3 == null) {
                string4 = "unrecognized file format type " + string2;
            } else {
                Logger.info("The Resolver assumes " + string3);
            }
        } else {
            string3 = Resolver.determineAtomSetCollectionReader(bufferedReader, true);
            if (string3.indexOf("\n") >= 0) {
                string4 = "unrecognized file format for file " + string + "\n" + string3;
            } else if (string3.equals("spt")) {
                string4 = "NOTE: file recognized as a script file: " + string + "\n";
            } else {
                Logger.info("The Resolver thinks " + string3);
            }
        }
        if (string4 != null) {
            bufferedReader.close();
            return string4;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, Integer>();
        }
        hashtable.put("ptFile", new Integer(n));
        if (n <= 0) {
            hashtable.put("readerName", (Integer)((Object)string3));
        }
        if (string3.indexOf("(xml)") >= 0) {
            string3 = "Xml";
        }
        String string5 = null;
        String string6 = null;
        try {
            string5 = Resolver.getReaderClassBase(string3);
            Class<?> clazz = Class.forName(string5);
            atomSetCollectionReader = (AtomSetCollectionReader)clazz.newInstance();
        }
        catch (Exception exception) {
            string6 = "File reader was not found:" + string5;
            Logger.error(string6);
            return string6;
        }
        atomSetCollectionReader.initialize(hashtable);
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollection(bufferedReader);
        if (!hashtable.containsKey("templateAtomCount")) {
            hashtable.put("templateAtomCount", new Integer(atomSetCollection.getAtomCount()));
        }
        if (hashtable.containsKey("bsFilter")) {
            hashtable.put("filteredAtomCount", new Integer(BitSetUtil.cardinalityOf((BitSet)hashtable.get("bsFilter"))));
        }
        bufferedReader.close();
        bufferedReader = null;
        return Resolver.finalize(atomSetCollection, string);
    }

    static Object DOMResolve(Object object) throws Exception {
        AtomSetCollectionReader atomSetCollectionReader;
        String string = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = Resolver.getXmlType((JSObject)object);
        if (Logger.debugging) {
            Logger.debug("The Resolver thinks " + string2);
        }
        hashtable.put("readerName", string2);
        try {
            string = "org.jmol.adapter.readers.xml.XmlReader";
            Class<?> clazz = Class.forName(string);
            atomSetCollectionReader = (AtomSetCollectionReader)clazz.newInstance();
        }
        catch (Exception exception) {
            String string3 = "File reader was not found:" + string;
            Logger.error(string3, exception);
            return string3;
        }
        atomSetCollectionReader.initialize(hashtable);
        AtomSetCollection atomSetCollection = atomSetCollectionReader.readAtomSetCollectionFromDOM(object);
        return Resolver.finalize(atomSetCollection, "DOM node");
    }

    private static final String getReaderClassBase(String string) {
        String string2 = "more.";
        for (int i = 1; i < readerSets.length; i += 2) {
            if (readerSets[i].indexOf(string + ";") < 0) continue;
            string2 = readerSets[i - 1];
            break;
        }
        return classBase + string2 + string + "Reader";
    }

    private static String[] getSpartanFileList(String string, String[] stringArray) {
        String[] stringArray2 = new String[2 + stringArray.length * 5];
        stringArray2[0] = "SpartanSmol";
        stringArray2[1] = "Directory Entry ";
        int n = 2;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + (Character.isDigit(stringArray[i].charAt(0)) ? "/Profile." + stringArray[i] : "/" + stringArray[i]);
            stringArray2[n++] = string2 + "/#JMOL_MODEL " + stringArray[i];
            stringArray2[n++] = string2 + "/input";
            stringArray2[n++] = string2 + "/archive";
            stringArray2[n++] = string2 + "/Molecule:asBinaryString";
            stringArray2[n++] = string2 + "/proparc";
        }
        return stringArray2;
    }

    private static String[] getSpartanDirs(String string) {
        String[] stringArray;
        if (string == null) {
            return new String[0];
        }
        if (string.startsWith("java.io.FileNotFoundException") || string.startsWith("FILE NOT FOUND") || string.indexOf("<html") >= 0) {
            return new String[]{"M0001"};
        }
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        try {
            stringArray = new StringTokenizer(string, " \t\r\n");
            while (stringArray.hasMoreTokens()) {
                String string3 = stringArray.nextToken();
                if (string3.equals(")")) {
                    vector.add(string2);
                } else if (string3.equals("Start-") && stringArray.nextToken().equals("Molecule")) {
                    vector.add(TextFormat.split(stringArray.nextToken(), '\"')[1]);
                }
                string2 = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    private static String getXmlType(JSObject jSObject) {
        String string = (String)jSObject.getMember("namespaceURI");
        String string2 = (String)jSObject.getMember("localName");
        if (string.startsWith("http://www.molpro.net/")) {
            return specialTags[17][0];
        }
        if ("odyssey_simulation".equals(string2)) {
            return specialTags[18][0];
        }
        if ("arguslab".equals(string2)) {
            return specialTags[14][0];
        }
        if (string.startsWith(CML_NAMESPACE_URI) || "cml".equals(string2)) {
            return specialTags[15][0];
        }
        return "unidentified " + specialTags[15][0];
    }

    private static Object finalize(AtomSetCollection atomSetCollection, String string) {
        String string2 = atomSetCollection.fileTypeName;
        if (string2.indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            atomSetCollection.setAtomSetAuxiliaryInfo("fileName", string, n);
            atomSetCollection.setAtomSetAuxiliaryInfo("fileType", string2, n);
        }
        atomSetCollection.freeze();
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage + "\nfor file " + string + "\ntype " + atomSetCollection.fileTypeName;
        }
        if (atomSetCollection.atomCount == 0) {
            return "No atoms found\nfor file " + string + "\ntype " + atomSetCollection.fileTypeName;
        }
        return atomSetCollection;
    }

    private static String determineAtomSetCollectionReader(BufferedReader bufferedReader, boolean bl) throws Exception {
        int n;
        String[] stringArray;
        int n2;
        Object object;
        int n3;
        String[] stringArray2 = new String[16];
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 16384);
        int n4 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = limitedLineReader.readLineWithNewline();
            if (stringArray2[i].length() <= 0) continue;
            ++n4;
        }
        String string = Resolver.checkSpecial(n4, stringArray2);
        if (string != null) {
            return string;
        }
        String string2 = limitedLineReader.getHeader(20);
        for (n3 = 0; n3 < fileStartsWithRecords.length; ++n3) {
            object = fileStartsWithRecords[n3];
            for (n2 = 1; n2 < ((String[])object).length; ++n2) {
                stringArray = object[n2];
                if (!string2.startsWith((String)stringArray)) continue;
                return object[0];
            }
        }
        for (n3 = 0; n3 < lineStartsWithRecords.length; ++n3) {
            object = lineStartsWithRecords[n3];
            for (n2 = 1; n2 < ((String[])object).length; ++n2) {
                stringArray = object[n2];
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!stringArray2[n].startsWith((String)stringArray)) continue;
                    return object[0];
                }
            }
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            if (stringArray2[n3].indexOf("# Jmol state") < 0) continue;
            return "spt";
        }
        String string3 = limitedLineReader.getHeader(0);
        object = null;
        block7: for (n2 = 0; n2 < containsRecords.length; ++n2) {
            stringArray = containsRecords[n2];
            for (n = 1; n < stringArray.length; ++n) {
                String string4 = stringArray[n];
                if (string3.indexOf(string4) == -1) continue;
                object = stringArray[0];
                if (((String)object).equals("Xml")) {
                    if (string3.indexOf("XHTML") >= 0 || string3.indexOf("xhtml") >= 0) continue block7;
                    object = Resolver.getXmlType(string3);
                }
                return object;
            }
        }
        return bl ? "\n" + stringArray2[0] + "\n" + stringArray2[1] + "\n" + stringArray2[2] + "\n" : null;
    }

    private static String getXmlType(String string) throws Exception {
        if (string.indexOf("http://www.molpro.net/") >= 0) {
            return specialTags[12][0];
        }
        if (string.indexOf("odyssey") >= 0) {
            return specialTags[13][0];
        }
        if (string.indexOf("C3XML") >= 0) {
            return specialTags[11][0];
        }
        if (string.indexOf("arguslab") >= 0) {
            return specialTags[9][0];
        }
        if (string.indexOf(CML_NAMESPACE_URI) >= 0 || string.indexOf("cml:") >= 0) {
            return specialTags[10][0];
        }
        return "unidentified " + specialTags[10][0];
    }

    private static final String checkSpecial(int n, String[] stringArray) {
        if (n == 1 && stringArray[0].length() > 0 && Character.isDigit(stringArray[0].charAt(0))) {
            return specialTags[0][0];
        }
        if (Resolver.checkMopacGraphf(stringArray)) {
            return specialTags[1][0];
        }
        if (Resolver.checkV3000(stringArray)) {
            return specialTags[2][0];
        }
        if (Resolver.checkOdyssey(stringArray)) {
            return specialTags[3][0];
        }
        if (Resolver.checkMol(stringArray)) {
            return specialTags[4][0];
        }
        if (Resolver.checkXyz(stringArray)) {
            return specialTags[5][0];
        }
        if (Resolver.checkAlchemy(stringArray[0])) {
            return specialTags[8][0];
        }
        if (Resolver.checkFoldingXyz(stringArray)) {
            return specialTags[6][0];
        }
        if (Resolver.checkCube(stringArray)) {
            return specialTags[7][0];
        }
        return null;
    }

    private static final String getReaderFromType(String string) {
        string = string.toLowerCase();
        String string2 = null;
        string2 = Resolver.checkType(specialTags, string);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkType(fileStartsWithRecords, string);
        if (string2 != null) {
            return string2;
        }
        string2 = Resolver.checkType(lineStartsWithRecords, string);
        if (string2 != null) {
            return string2;
        }
        return Resolver.checkType(containsRecords, string);
    }

    private static final String checkType(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i][0].toLowerCase().equals(string)) continue;
            return stringArray[i][0];
        }
        return null;
    }

    private static boolean checkOdyssey(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && (stringArray[n].startsWith("C ") || stringArray[n].length() == 0); ++n) {
        }
        if (n >= stringArray.length || stringArray[n].charAt(0) != ' ' || (n += 2) + 1 >= stringArray.length) {
            return false;
        }
        try {
            int n2 = Integer.parseInt(stringArray[n].substring(2).trim());
            int n3 = Integer.parseInt(stringArray[n].substring(0, 2).trim());
            int n4 = Integer.parseInt(stringArray[++n].substring(0, 2).trim());
            if (n2 < 0 || n2 > 5 || n4 <= 0 || n3 > 5) {
                return false;
            }
            float[] fArray = new float[5];
            AtomSetCollectionReader.getTokensFloat(stringArray[n], fArray, 5);
            return !Float.isNaN(fArray[1]) && !Float.isNaN(fArray[2]) && !Float.isNaN(fArray[3]) && Float.isNaN(fArray[4]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkV3000(String[] stringArray) {
        String string;
        return stringArray[3].length() >= 6 && (string = stringArray[3].trim()).endsWith("V3000");
    }

    private static boolean checkMol(String[] stringArray) {
        if (stringArray[3].length() >= 6) {
            String string = stringArray[3].trim();
            if (string.endsWith("V2000") || string.endsWith("v2000")) {
                return true;
            }
            try {
                Integer.parseInt(stringArray[3].substring(0, 3).trim());
                Integer.parseInt(stringArray[3].substring(3, 6).trim());
                return stringArray[0].indexOf("@<TRIPOS>") != 0 && stringArray[1].indexOf("@<TRIPOS>") != 0 && stringArray[2].indexOf("@<TRIPOS>") != 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkAlchemy(String string) {
        int n = string.indexOf("ATOMS");
        if (n >= 0 && string.indexOf("BONDS") > n) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n).trim());
                return n2 > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkXyz(String[] stringArray) {
        try {
            Integer.parseInt(stringArray[0].trim());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean checkFoldingXyz(String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0].trim(), " \t");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        String string = stringArray[1].trim();
        if (string.length() == 0) {
            string = stringArray[2].trim();
        }
        if ((stringTokenizer = new StringTokenizer(string, " \t")).countTokens() == 0) {
            return false;
        }
        try {
            Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean checkMopacGraphf(String[] stringArray) {
        return stringArray[0].indexOf("MOPAC-Graphical data") > 2;
    }

    private static boolean checkCube(String[] stringArray) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[2]);
            if (stringTokenizer == null || stringTokenizer.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(stringTokenizer.nextToken());
            int n = 3;
            while (--n >= 0) {
                new Float(stringTokenizer.nextToken());
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[3]);
            if (stringTokenizer2 == null || stringTokenizer2.countTokens() != 4) {
                return false;
            }
            Integer.parseInt(stringTokenizer2.nextToken());
            int n2 = 3;
            while (--n2 >= 0) {
                Float f = new Float(stringTokenizer2.nextToken());
                if (!(f.floatValue() < 0.0f)) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

