/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolViewer;
import org.jmol.applet.GuiMap;
import org.jmol.applet.Jvm12;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;

class Console
implements ActionListener,
WindowListener {
    private final JTextArea input = new ControlEnterTextArea();
    private final JTextPane output = new JTextPane();
    private final Document outputDocument = this.output.getDocument();
    private JFrame jf;
    private JButton runButton;
    private JButton clearOutButton;
    private JButton clearInButton;
    private JButton historyButton;
    private JButton stateButton;
    private JButton loadButton;
    private final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    private final JmolViewer viewer;
    private GuiMap guimap = new GuiMap();
    private final Jvm12 jvm12;
    private JMenuBar menubar;

    JmolViewer getViewer() {
        return this.viewer;
    }

    public Object getMyMenuBar() {
        return this.menubar;
    }

    Console(Component component, JmolViewer jmolViewer, Jvm12 jvm12) {
        this.viewer = jmolViewer;
        this.jvm12 = jvm12;
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(true);
        this.jf = new JFrame(GT._("Jmol Script Console"));
        this.jf.setSize(600, 400);
        this.runButton = new JButton(GT._("Execute"));
        this.clearOutButton = new JButton(GT._("Clear Output"));
        this.clearInButton = new JButton(GT._("Clear Input"));
        this.historyButton = new JButton(GT._("History"));
        this.stateButton = new JButton(GT._("State"));
        this.loadButton = new JButton(GT._("Load"));
        this.setupInput();
        this.setupOutput();
        JScrollPane jScrollPane = new JScrollPane(this.input);
        jScrollPane.setMinimumSize(new Dimension(2, 100));
        JScrollPane jScrollPane2 = new JScrollPane(this.output);
        jScrollPane2.setMinimumSize(new Dimension(2, 100));
        Container container = this.jf.getContentPane();
        this.menubar = this.createMenubar();
        this.jf.setJMenuBar(this.menubar);
        container.setLayout(new BoxLayout(container, 1));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setAlignmentX(0.5f);
        container.add(jSplitPane);
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 0));
        container2.add(Box.createGlue());
        container2.add(this.runButton);
        container2.add(this.loadButton);
        container2.add(this.clearInButton);
        container2.add(this.clearOutButton);
        container2.add(this.historyButton);
        container2.add(this.stateButton);
        container2.add(Box.createGlue());
        container.add(container2);
        JLabel jLabel = new JLabel(GT._("press CTRL-ENTER for new line or paste model data and press Load"), 0);
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        this.runButton.addActionListener(this);
        this.clearInButton.addActionListener(this);
        this.clearOutButton.addActionListener(this);
        this.historyButton.addActionListener(this);
        this.stateButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.jf.addWindowListener(this);
        GT.setDoTranslate(bl);
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.guimap.newJMenu("help");
        JMenuItem jMenuItem = this.guimap.newJMenuItem("search");
        jMenuItem.addActionListener(this);
        jMenuItem.setName("help ?search=?");
        jMenu.add(jMenuItem);
        if (jMenu == null) {
            return;
        }
        this.addHelpItems(jMenu, "commands", "command");
        this.addHelpItems(jMenu, "functions", "mathfunc");
        this.addHelpItems(jMenu, "parameters", "setparam");
        this.addHelpItems(jMenu, "more", "misc");
        jMenuBar.add(jMenu);
    }

    private void addHelpItems(JMenu jMenu, String string, String string2) {
        JMenu jMenu2 = this.guimap.newJMenu(string);
        String[] stringArray = (String[])this.viewer.getProperty(null, "tokenList", string2);
        jMenu.add(jMenu2);
        JMenu jMenu3 = null;
        String string3 = null;
        int n = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!Character.isLetter(string4.charAt(0))) continue;
            JMenuItem jMenuItem = new JMenuItem(string4);
            jMenuItem.addActionListener(this);
            jMenuItem.setName("help " + string4);
            if (jMenu3 == null) {
                jMenu3 = new JMenu();
                string3 = string4;
                jMenu3.add(jMenuItem);
                jMenu3.setText(string3);
                continue;
            }
            if (i % n + 1 == n) {
                jMenu3.add(jMenuItem);
                jMenu3.setText(string3 + " - " + string4);
                jMenu2.add(jMenu3);
                jMenu3 = null;
                continue;
            }
            jMenu3.add(jMenuItem);
            if (i + 1 != stringArray.length || jMenu3 == null) continue;
            jMenu3.setText(string3 + " - " + string4);
            jMenu2.add(jMenu3);
        }
    }

    protected JMenuItem createMenuItem(String string) {
        return this.guimap.newJMenuItem(string);
    }

    private void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        this.input.setDragEnabled(true);
        Keymap keymap = this.input.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 1);
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    private void setupOutput() {
        this.output.setEditable(false);
        this.output.setDragEnabled(true);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    void setVisible(boolean bl) {
        if (Logger.debugging) {
            Logger.debug("Console.setVisible(" + bl + ")");
        }
        this.jf.setVisible(bl);
        this.input.requestFocus();
    }

    void output(String string) {
        this.output(string, null);
    }

    private void output(String string, AttributeSet attributeSet) {
        if (string == null || string.length() == 0) {
            this.output.setText("");
            return;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    String getText() {
        return this.output.getText();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            this.execute(null);
        }
        if (object == this.clearInButton) {
            this.input.setText("");
        }
        if (object == this.clearOutButton) {
            this.output.setText("");
        }
        if (object == this.historyButton) {
            this.output.setText(this.viewer.getSetHistory(Integer.MAX_VALUE));
        }
        if (object == this.stateButton) {
            this.output.setText(this.viewer.getStateInfo());
        }
        if (object == this.loadButton) {
            this.viewer.loadInline(this.input.getText(), false);
        }
        if (object instanceof JMenuItem) {
            this.execute(((JMenuItem)object).getName());
        }
    }

    void execute(String string) {
        String string2;
        String string3;
        String string4 = string3 = string == null ? this.input.getText() : string;
        if (string == null) {
            this.input.setText(null);
        }
        if ((string2 = this.viewer.script(string3)) != null && !string2.equals("pending")) {
            this.output(string2);
        }
        if (string == null) {
            this.input.requestFocus();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.jvm12.console = null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.jvm12.console = null;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (keyEvent.getKeyCode() == 10 && !keyEvent.isControlDown()) {
                        Console.this.execute(null);
                        return;
                    }
                    if (keyEvent.getKeyCode() == 38) {
                        this.recallCommand(true);
                        return;
                    }
                    if (keyEvent.getKeyCode() != 40) break;
                    this.recallCommand(false);
                    return;
                }
                case 402: {
                    if (keyEvent.getKeyCode() != 10 || keyEvent.isControlDown()) break;
                    return;
                }
            }
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.setModifiers(0);
            }
            super.processComponentKeyEvent(keyEvent);
        }

        private void recallCommand(boolean bl) {
            String string = Console.this.getViewer().getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            this.setText(string);
        }
    }
}

