/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.jmol.i18n.GT;

class GuiMap {
    Hashtable map = new Hashtable();
    private Hashtable labels = null;

    GuiMap() {
    }

    private Hashtable setupLabels() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("help", GT._("&Help"));
        hashtable.put("search", GT._("&Search..."));
        hashtable.put("commands", GT._("&Commands"));
        hashtable.put("functions", GT._("Math &Functions"));
        hashtable.put("parameters", GT._("Set &Parameters"));
        hashtable.put("more", GT._("&More"));
        return hashtable;
    }

    String getLabel(String string) {
        if (this.labels == null) {
            this.labels = this.setupLabels();
        }
        return (String)this.labels.get(string);
    }

    JMenu newJMenu(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenu(string, GuiMap.getLabelWithoutMnemonic(string2), GuiMap.getMnemonic(string2));
    }

    JMenuItem newJMenuItem(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenuItem(string, GuiMap.getLabelWithoutMnemonic(string2), GuiMap.getMnemonic(string2));
    }

    Object get(String string) {
        return this.map.get(string);
    }

    static String getKey(Object object) {
        return ((GetKey)object).getKey();
    }

    static String getLabelWithoutMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + (n < string.length() - 1 ? string.substring(n + 1) : "");
    }

    static char getMnemonic(String string) {
        if (string == null) {
            return ' ';
        }
        int n = string.indexOf(38);
        if (n == -1 || n == string.length() - 1) {
            return ' ';
        }
        return string.charAt(n + 1);
    }

    void setSelected(String string, boolean bl) {
        ((AbstractButton)this.get(string)).setSelected(bl);
    }

    boolean isSelected(String string) {
        return ((AbstractButton)this.get(string)).isSelected();
    }

    class KeyJMenuItem
    extends JMenuItem
    implements GetKey {
        String key;

        KeyJMenuItem(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJMenu
    extends JMenu
    implements GetKey {
        String key;

        KeyJMenu(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    static interface GetKey {
        public String getKey();
    }
}

