/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.awt.Rectangle;
import java.util.BitSet;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.bspt.Bspf;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

public abstract class AtomCollection {
    public Viewer viewer;
    protected Graphics3D g3d;
    public Atom[] atoms;
    int atomCount;
    String[] atomNames;
    String[] atomTypes;
    int[] atomSerials;
    byte[] specialAtomIDs;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    protected Object[][] ellipsoids;
    protected int[] surfaceDistance100s;
    private BitSet bsHidden = new BitSet();
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private int surfaceDistanceMax;
    private BitSet bsSurface;
    private int nSurfaceAtoms;
    protected Bspf bspf;
    public static final byte TAINT_ATOMNAME = 0;
    public static final byte TAINT_ATOMTYPE = 1;
    public static final byte TAINT_COORD = 2;
    private static final byte TAINT_ELEMENT = 3;
    private static final byte TAINT_FORMALCHARGE = 4;
    private static final byte TAINT_OCCUPANCY = 5;
    private static final byte TAINT_PARTIALCHARGE = 6;
    private static final byte TAINT_TEMPERATURE = 7;
    private static final byte TAINT_VALENCE = 8;
    private static final byte TAINT_VANDERWAALS = 9;
    private static final byte TAINT_VIBRATION = 10;
    public static final byte TAINT_MAX = 11;
    private static final String[] userSettableValues = new String[]{"atomName", "atomType", "coord", "element", "formalCharge", "occupany", "partialCharge", "temperature", "valence", "vanderWaals", "vibrationVector"};
    protected BitSet[] tainted;
    private static final int minimumPixelSelectionRadius = 6;
    private final BitSet bsEmpty = new BitSet();
    private final BitSet bsFoundRectangle = new BitSet();

    protected void releaseModelSet() {
        this.atoms = null;
        this.viewer = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomTypes = null;
        this.atomSerials = null;
        this.clientAtomReferences = null;
        this.vibrationVectors = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.partialCharges = null;
        this.specialAtomIDs = null;
        this.ellipsoids = null;
    }

    protected void merge(AtomCollection atomCollection) {
        this.tainted = atomCollection.tainted;
        this.atomNames = atomCollection.atomNames;
        this.atomTypes = atomCollection.atomTypes;
        this.atomSerials = atomCollection.atomSerials;
        this.clientAtomReferences = atomCollection.clientAtomReferences;
        this.vibrationVectors = atomCollection.vibrationVectors;
        this.occupancies = atomCollection.occupancies;
        this.bfactor100s = atomCollection.bfactor100s;
        this.partialCharges = atomCollection.partialCharges;
        this.ellipsoids = atomCollection.ellipsoids;
        this.specialAtomIDs = atomCollection.specialAtomIDs;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtomAt(int n) {
        return this.atoms[n];
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrationVectors != null;
    }

    public String[] getAtomNames() {
        return this.atomNames;
    }

    public String[] getAtomTypes() {
        return this.atomTypes;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public void setBsHidden(BitSet bitSet) {
        this.bsHidden = bitSet;
    }

    public boolean isAtomHidden(int n) {
        return this.bsHidden.get(n);
    }

    public String getAtomInfo(int n, String string) {
        return string == null ? this.atoms[n].getInfo() : this.atoms[n].formatLabel(string);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.atoms[n].getInfoXYZ(bl);
    }

    public String getElementSymbol(int n) {
        return this.atoms[n].getElementSymbol();
    }

    public int getElementNumber(int n) {
        return this.atoms[n].getElementNumber();
    }

    String getElementName(int n) {
        return JmolConstants.elementNameFromNumber(this.atoms[n].getAtomicAndIsotopeNumber());
    }

    public String getAtomName(int n) {
        return this.atoms[n].getAtomName();
    }

    public int getAtomNumber(int n) {
        return this.atoms[n].getAtomNumber();
    }

    public float getAtomX(int n) {
        return this.atoms[n].x;
    }

    public float getAtomY(int n) {
        return this.atoms[n].y;
    }

    public float getAtomZ(int n) {
        return this.atoms[n].z;
    }

    public Point3f getAtomPoint3f(int n) {
        return this.atoms[n];
    }

    public float getAtomRadius(int n) {
        return this.atoms[n].getRadius();
    }

    public float getAtomVdwRadius(int n) {
        return this.atoms[n].getVanderwaalsRadiusFloat();
    }

    public short getAtomColix(int n) {
        return this.atoms[n].getColix();
    }

    public String getAtomChain(int n) {
        return "" + this.atoms[n].getChainID();
    }

    public String getAtomSequenceCode(int n) {
        return this.atoms[n].getSeqcodeString();
    }

    public int getAtomModelIndex(int n) {
        return this.atoms[n].getModelIndex();
    }

    public Object[] getEllipsoid(int n) {
        return n < 0 || this.ellipsoids == null || n >= this.ellipsoids.length ? null : this.ellipsoids[n];
    }

    public Quaternion getQuaternion(int n, char c) {
        return this.atoms[n].group.getQuaternion(c);
    }

    protected int getAtomCountInModel(int n) {
        int n2 = 0;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            if (this.atoms[n3].modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getAtomIndexFromAtomNumber(int n, BitSet bitSet) {
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.atoms[i];
            if (atom.getAtomNumber() != n || !bitSet.get(atom.modelIndex)) continue;
            return i;
        }
        return -1;
    }

    public void setFormalCharges(BitSet bitSet, int n) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.atoms[i].setFormalCharge(n);
            this.taint(i, (byte)4);
        }
    }

    public float[] getAtomicCharges() {
        float[] fArray = new float[this.atomCount];
        int n = this.atomCount;
        while (--n >= 0) {
            fArray[n] = this.atoms[n].getElementNumber();
        }
        return fArray;
    }

    protected float getRadiusVdwJmol(Atom atom) {
        return (float)JmolConstants.getVanderwaalsMar(atom.getElementNumber(), 0) / 1000.0f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int n = this.atomCount;
        while (--n >= 0) {
            float f;
            Atom atom = this.atoms[n];
            float f2 = atom.getBondingRadiusFloat();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = f2;
            }
            if (!((f = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = f;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BitSet bitSet) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int n = this.atomCount;
            while (--n > 0) {
                if (bitSet != null && !bitSet.get(n)) continue;
                int n2 = this.atoms[n].getBfactor100();
                if (n2 < this.bfactor100Lo) {
                    this.bfactor100Lo = n2;
                    continue;
                }
                if (n2 <= this.bfactor100Hi) continue;
                this.bfactor100Hi = n2;
            }
            this.hasBfactorRange = true;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    int getSurfaceDistance100(int n) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[n];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public Point3f[] calculateSurface(BitSet bitSet, float f) {
        if (f < 0.0f) {
            f = 3.0f;
        }
        EnvelopeCalculation envelopeCalculation = new EnvelopeCalculation(this.viewer, this.atomCount, null);
        envelopeCalculation.calculate(Float.MAX_VALUE, f, 1.0f, Float.MAX_VALUE, bitSet, BitSetUtil.copyInvert(bitSet, this.atomCount), true, false, false, false, true);
        Point3f[] point3fArray = envelopeCalculation.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = envelopeCalculation.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.atomCount];
        this.nSurfaceAtoms = BitSetUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || point3fArray == null || point3fArray.length == 0) {
            return point3fArray;
        }
        float f2 = f == Float.MAX_VALUE ? 0.0f : f;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float f3 = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int n = point3fArray.length;
            while (--n >= 0) {
                float f4 = Math.abs(point3fArray[n].distance(atom) - f2);
                if (f4 < 0.0f && Logger.debugging) {
                    Logger.debug("draw d" + n + " " + Escape.escape(point3fArray[n]) + " \"" + f4 + " ? " + atom.getInfo() + "\"");
                }
                f3 = Math.min(f4, f3);
            }
            n = this.surfaceDistance100s[i] = (int)(f3 * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, n);
        }
        return point3fArray;
    }

    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        Point3f point3f = null;
        Point3f[] point3fArray = null;
        if (object instanceof Point3f) {
            point3f = (Point3f)object;
        } else {
            point3fArray = (Point3f[])object;
        }
        if (point3f == null && (point3fArray == null || point3fArray.length == 0)) {
            return;
        }
        int n2 = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (point3fArray != null) {
                if (n2 >= point3fArray.length) {
                    return;
                }
                point3f = point3fArray[n2++];
            }
            switch (n) {
                case 7340297: {
                    this.setAtomCoord(i, point3f.x, point3f.y, point3f.z);
                    continue block5;
                }
                case 7340298: {
                    this.atoms[i].setFractionalCoord(point3f);
                    this.taint(i, (byte)2);
                    continue block5;
                }
                case 7340299: {
                    this.setAtomVibrationVector(i, point3f.x, point3f.y, point3f.z);
                }
            }
        }
    }

    private void setAtomVibrationVector(int n, float f, float f2, float f3) {
        this.setVibrationVector(n, f, f2, f3);
        this.taint(n, (byte)10);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[n].x = f;
        this.atoms[n].y = f2;
        this.atoms[n].z = f3;
        this.taint(n, (byte)2);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        this.atoms[n].x += f;
        this.atoms[n].y += f2;
        this.atoms[n].z += f3;
        this.taint(n, (byte)2);
    }

    protected void setAtomCoordRelative(BitSet bitSet, float f, float f2, float f3) {
        this.bspf = null;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            this.setAtomCoordRelative(n, f, f2, f3);
        }
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        int n3 = 0;
        if (fArray != null && fArray.length == 0) {
            return;
        }
        block16: for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (fArray != null) {
                if (n3 >= fArray.length) {
                    return;
                }
                f = fArray[n3++];
                n2 = (int)f;
            } else if (stringArray != null) {
                if (n3 >= fArray.length) {
                    return;
                }
                string = stringArray[n3++];
            }
            Atom atom = this.atoms[i];
            switch (n) {
                case 3145990: {
                    this.taint(i, (byte)0);
                    this.setAtomName(i, string);
                    continue block16;
                }
                case 3145986: {
                    this.taint(i, (byte)1);
                    this.setAtomType(i, string);
                    continue block16;
                }
                case 3146112: {
                    this.setAtomCoord(i, f, atom.y, atom.z);
                    continue block16;
                }
                case 3146113: {
                    this.setAtomCoord(i, atom.x, f, atom.z);
                    continue block16;
                }
                case 3146114: {
                    this.setAtomCoord(i, atom.x, atom.y, f);
                    continue block16;
                }
                case 3146124: 
                case 3146125: 
                case 3146126: {
                    this.setVibrationVector(i, n, f);
                    continue block16;
                }
                case 3146115: 
                case 3146116: 
                case 3146117: {
                    atom.setFractionalCoord(n, f);
                    this.taint(i, (byte)2);
                    continue block16;
                }
                case 3145992: {
                    this.taint(i, (byte)3);
                    atom.setAtomicAndIsotopeNumber(n2);
                    atom.setPaletteID((byte)1);
                    atom.setColixAtom(this.viewer.getColixAtomPalette(atom, (byte)1));
                    continue block16;
                }
                case 137363722: {
                    atom.setFormalCharge(n2);
                    this.taint(i, (byte)4);
                    continue block16;
                }
                case 3145998: {
                    this.setOccupancy(i, n2);
                    this.taint(i, (byte)5);
                    continue block16;
                }
                case 3146118: {
                    this.setPartialCharge(i, f);
                    this.taint(i, (byte)6);
                    continue block16;
                }
                case 3146123: {
                    this.setBFactor(i, f);
                    this.taint(i, (byte)7);
                    continue block16;
                }
                case 3146005: {
                    atom.setValence(n2);
                    this.taint(i, (byte)8);
                    continue block16;
                }
                case 3146004: {
                    if (atom.setRadius(f)) {
                        this.taint(i, (byte)9);
                        continue block16;
                    }
                    this.untaint(i, (byte)9);
                    continue block16;
                }
                default: {
                    Logger.error("unsettable atom property: " + Token.nameOf(n));
                }
            }
        }
    }

    public float getVibrationCoord(int n, char c) {
        if (this.vibrationVectors == null || this.vibrationVectors[n] == null) {
            return 0.0f;
        }
        switch (c) {
            case 'x': {
                return this.vibrationVectors[n].x;
            }
            case 'y': {
                return this.vibrationVectors[n].y;
            }
        }
        return this.vibrationVectors[n].z;
    }

    public Vector3f getVibrationVector(int n) {
        return this.vibrationVectors == null ? null : this.vibrationVectors[n];
    }

    protected void setVibrationVector(int n, float f, float f2, float f3) {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            return;
        }
        if (this.vibrationVectors == null) {
            this.vibrationVectors = new Vector3f[this.atoms.length];
        }
        this.vibrationVectors[n] = new Vector3f(f, f2, f3);
        this.atoms[n].setVibrationVector();
    }

    private void setVibrationVector(int n, int n2, float f) {
        Vector3f vector3f = this.getVibrationVector(n);
        if (vector3f == null) {
            vector3f = new Vector3f();
        }
        switch (n2) {
            case 3146124: {
                vector3f.x = f;
                break;
            }
            case 3146125: {
                vector3f.y = f;
                break;
            }
            case 3146126: {
                vector3f.z = f;
            }
        }
        this.setAtomVibrationVector(n, vector3f.x, vector3f.y, vector3f.z);
    }

    protected void setAtomName(int n, String string) {
        if (this.atomNames == null) {
            this.atomNames = new String[this.atoms.length];
        }
        this.atomNames[n] = string;
    }

    protected void setAtomType(int n, String string) {
        if (this.atomTypes == null) {
            this.atomTypes = new String[this.atoms.length];
        }
        this.atomTypes[n] = string;
    }

    protected void setOccupancy(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 100) {
            n2 = 100;
        }
        if (this.occupancies == null) {
            this.occupancies = new byte[this.atoms.length];
        }
        this.occupancies[n] = (byte)n2;
    }

    protected void setPartialCharge(int n, float f) {
        if (Float.isNaN(f)) {
            return;
        }
        if (this.partialCharges == null) {
            this.partialCharges = new float[this.atoms.length];
        }
        this.partialCharges[n] = f;
    }

    protected void setEllipsoid(int n, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        if (this.ellipsoids == null) {
            this.ellipsoids = new Object[this.atoms.length][];
        }
        this.ellipsoids[n] = objectArray;
    }

    protected void setBFactor(int n, float f) {
        if (Float.isNaN(f) || f == 0.0f) {
            return;
        }
        if (this.bfactor100s == null) {
            this.bfactor100s = new short[this.atoms.length];
        }
        this.bfactor100s[n] = (short)(f * 100.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAtomData(int n, String string, String string2) {
        float[] fArray = null;
        BitSet bitSet = null;
        switch (n) {
            case 2: {
                this.loadCoordinates(string2, false);
                return;
            }
            case 10: {
                this.loadCoordinates(string2, true);
                return;
            }
            case 11: {
                fArray = new float[this.atomCount];
                bitSet = new BitSet(this.atomCount);
                break;
            }
        }
        int[] nArray = Parser.markLines(string2, ';');
        int n2 = 0;
        try {
            int n3 = Parser.parseInt(string2.substring(0, nArray[0] - 1));
            int n4 = 1;
            while (true) {
                block21: {
                    if (n4 > n3) {
                        if (n != 11) return;
                        if (n2 <= 0) return;
                        this.viewer.setData(string, new Object[]{string, fArray, bitSet}, 0, 0, 0, 0, 0);
                        return;
                    }
                    String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string2.substring(nArray[n4], nArray[n4 + 1] - 1)));
                    int n5 = Parser.parseInt(stringArray[0]) - 1;
                    if (n5 >= 0 && n5 < this.atomCount) {
                        Atom atom = this.atoms[n5];
                        ++n2;
                        int n6 = stringArray.length - 1;
                        float f = Parser.parseFloat(stringArray[n6]);
                        switch (n) {
                            case 11: {
                                fArray[n5] = f;
                                bitSet.set(n5);
                                break block21;
                            }
                            case 0: {
                                this.setAtomName(n5, stringArray[n6]);
                                break;
                            }
                            case 1: {
                                this.setAtomType(n5, stringArray[n6]);
                                break;
                            }
                            case 3: {
                                atom.setAtomicAndIsotopeNumber((int)f);
                                atom.setPaletteID((byte)1);
                                atom.setColixAtom(this.viewer.getColixAtomPalette(atom, (byte)1));
                                break;
                            }
                            case 4: {
                                atom.setFormalCharge((int)f);
                                break;
                            }
                            case 6: {
                                this.setPartialCharge(n5, f);
                                break;
                            }
                            case 7: {
                                this.setBFactor(n5, f);
                                break;
                            }
                            case 8: {
                                atom.setValence((int)f);
                                break;
                            }
                            case 9: {
                                atom.setRadius(f);
                            }
                        }
                        this.taint(n5, (byte)n);
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            Logger.error("AtomCollection.loadData error: " + exception);
        }
    }

    private void loadCoordinates(String string, boolean bl) {
        if (!bl) {
            this.bspf = null;
        }
        int[] nArray = Parser.markLines(string, ';');
        try {
            int n = Parser.parseInt(string.substring(0, nArray[0] - 1));
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string.substring(nArray[i], nArray[i + 1])));
                int n2 = Parser.parseInt(stringArray[0]) - 1;
                float f = Parser.parseFloat(stringArray[3]);
                float f2 = Parser.parseFloat(stringArray[4]);
                float f3 = Parser.parseFloat(stringArray[5]);
                if (bl) {
                    this.setAtomVibrationVector(n2, f, f2, f3);
                    continue;
                }
                this.setAtomCoord(n2, f, f2, f3);
            }
        }
        catch (Exception exception) {
            Logger.error("Frame.loadCoordinate error: " + exception);
        }
    }

    public static int getUserSettableType(String string) {
        boolean bl = string.indexOf("property_") == 0;
        String string2 = bl ? string.substring(9) : string;
        for (int i = 0; i < 11; ++i) {
            if (!userSettableValues[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return bl ? 11 : -1;
    }

    public BitSet getTaintedAtoms(byte by) {
        return this.tainted == null ? null : this.tainted[by];
    }

    protected void taint(int n, byte by) {
        if (this.tainted == null) {
            this.tainted = new BitSet[11];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = new BitSet(this.atomCount);
        }
        this.tainted[by].set(n);
    }

    private void untaint(int n, byte by) {
        if (this.tainted == null || this.tainted[by] == null) {
            return;
        }
        this.tainted[by].clear(n);
    }

    public void setTaintedAtoms(BitSet bitSet, byte by) {
        if (bitSet == null) {
            if (this.tainted == null) {
                return;
            }
            this.tainted[by] = null;
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BitSet[11];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = new BitSet(this.atomCount);
        }
        BitSetUtil.copy(bitSet, this.tainted[by]);
    }

    public String getAtomicPropertyState(int n, BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by = 0; by < 11; by = (byte)(by + 1)) {
            BitSet bitSet2;
            if (n >= 0 && by != n || (bitSet2 = bitSet != null ? bitSet : this.getTaintedAtoms(by)) == null) continue;
            AtomCollection.getAtomicPropertyState(stringBuffer, this.atoms, this.atomCount, by, bitSet2, null, null);
        }
        return stringBuffer.toString();
    }

    public static void getAtomicPropertyState(StringBuffer stringBuffer, Atom[] atomArray, int n, byte by, BitSet bitSet, String string, float[] fArray) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        String string2 = (string == null ? userSettableValues[by] : string) + " set";
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer2.append(i + 1).append(" ").append(atomArray[i].getElementSymbol()).append(" ").append(atomArray[i].getInfo().replace(' ', '_')).append(" ");
            switch (by) {
                case 11: {
                    stringBuffer2.append(fArray[i]);
                    break;
                }
                case 0: {
                    stringBuffer2.append(atomArray[i].getAtomName());
                    break;
                }
                case 1: {
                    stringBuffer2.append(atomArray[i].getAtomType());
                    break;
                }
                case 2: {
                    stringBuffer2.append(atomArray[i].x).append(" ").append(atomArray[i].y).append(" ").append(atomArray[i].z);
                    break;
                }
                case 10: {
                    Vector3f vector3f = atomArray[i].getVibrationVector();
                    if (vector3f == null) {
                        vector3f = new Vector3f();
                    }
                    stringBuffer2.append(vector3f.x).append(" ").append(vector3f.y).append(" ").append(vector3f.z);
                }
                case 3: {
                    stringBuffer2.append(atomArray[i].getAtomicAndIsotopeNumber());
                    break;
                }
                case 4: {
                    stringBuffer2.append(atomArray[i].getFormalCharge());
                    break;
                }
                case 5: {
                    stringBuffer2.append(atomArray[i].getOccupancy());
                    break;
                }
                case 6: {
                    stringBuffer2.append(atomArray[i].getPartialCharge());
                    break;
                }
                case 7: {
                    stringBuffer2.append((float)atomArray[i].getBfactor100() / 100.0f);
                    break;
                }
                case 8: {
                    stringBuffer2.append(atomArray[i].getValence());
                    break;
                }
                case 9: {
                    stringBuffer2.append(atomArray[i].getVanderwaalsRadiusFloat());
                }
            }
            stringBuffer2.append(" ;\n");
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        stringBuffer.append("\n  DATA \"" + string2 + "\"\n").append(n2).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append("  end \"" + string2 + "\";\n");
    }

    protected void findNearestAtomIndex(int n, int n2, Atom[] atomArray) {
        Atom atom = null;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            Atom atom2 = this.atoms[n3];
            if (!atom2.isClickable() || !this.isCursorOnTopOf(atom2, n, n2, 6, atom)) continue;
            atom = atom2;
        }
        atomArray[0] = atom;
    }

    boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return atom.screenZ > 1 && !this.g3d.isClippedZ(atom.screenZ) && this.g3d.isInDisplayRange(atom.screenX, atom.screenY) && atom.isCursorOnTopOf(n, n2, n3, atom2);
    }

    public BitSet findAtomsInRectangle(Rectangle rectangle, BitSet bitSet) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (!bitSet.get(atom.modelIndex) || !atom.isVisible() || !rectangle.contains(atom.screenX, atom.screenY)) continue;
            this.bsFoundRectangle.set(n);
        }
        return this.bsFoundRectangle;
    }

    protected void fillAtomData(AtomData atomData, int n) {
        boolean bl;
        atomData.atomXyz = this.atoms;
        atomData.atomCount = this.atomCount;
        atomData.atomicNumber = new int[this.atomCount];
        boolean bl2 = bl = n == 2;
        if (bl) {
            atomData.atomRadius = new float[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomData.modelIndex >= 0 && this.atoms[i].modelIndex != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BitSet();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = this.atoms[i].getElementNumber();
            atomData.lastModelIndex = this.atoms[i].modelIndex;
            if (!bl) continue;
            atomData.atomRadius[i] = atomData.adpMode == 1 ? this.atoms[i].getADPMinMax(true) : (atomData.adpMode == -1 ? this.atoms[i].getADPMinMax(false) : (atomData.useIonic ? this.atoms[i].getBondingRadiusFloat() : this.atoms[i].getVanderwaalsRadiusFloat()));
        }
    }

    protected Point3f[][] getAdditionalHydrogens(BitSet bitSet, int[] nArray) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f[][] point3fArray = new Point3f[this.atomCount][];
        int n = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            String string;
            int n2;
            if (!bitSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            int n3 = 0;
            Atom atom = this.atoms[i];
            int n4 = n2 = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            if (!(n2 != 3 && n2 != 2 || (string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true)) != null && !string.equals("sp"))) {
                n2 = 0;
            }
            if (n2 > 0 && n2 <= 4) {
                n3 += 4 - n2;
            }
            point3fArray[i] = new Point3f[n3];
            n += n3;
            n3 = 0;
            switch (n2) {
                case 1: {
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3a", false);
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3b", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3c", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    continue block5;
                }
                case 2: {
                    string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true);
                    if (string == null || string.equals("sp")) continue block5;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpa", false);
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpb", false);
                    point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                    continue block5;
                }
                case 3: {
                    if (this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true) == null) continue block5;
                    Point3f point3f = new Point3f(vector3f);
                    point3f.scaleAdd(1.1f, atom);
                    point3fArray[i][n3++] = point3f;
                }
            }
        }
        nArray[0] = n;
        return point3fArray;
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        String string2 = string.length() > 0 && string.charAt(0) == '-' ? string.substring(1) : string;
        Atom atom = this.atoms[n];
        String string3 = "";
        vector3f.set(0.0f, 0.0f, 0.0f);
        vector3f2.set(0.0f, 0.0f, 0.0f);
        Atom atom2 = atom;
        Atom atom3 = atom;
        int n2 = 0;
        float f = 2.984513f;
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Vector3f vector3f8 = new Vector3f();
        if (atom.bonds != null) {
            int n3 = atom.bonds.length;
            block11: while (--n3 >= 0) {
                if (!atom.bonds[n3].isCovalent()) continue;
                atom2 = atom.bonds[n3].getOtherAtom(atom);
                vector3f3.sub(atom, atom2);
                vector3f3.normalize();
                vector3f.add(vector3f3);
                switch (++n2) {
                    case 1: {
                        vector3f2.set(vector3f3);
                        atom3 = atom2;
                        continue block11;
                    }
                    case 2: {
                        vector3f4.set(vector3f3);
                        continue block11;
                    }
                    case 3: {
                        vector3f5.set(vector3f3);
                        vector3f6.set(-vector3f.x, -vector3f.y, -vector3f.z);
                        continue block11;
                    }
                    case 4: {
                        vector3f6.set(vector3f3);
                        continue block11;
                    }
                }
                n3 = -1;
            }
        }
        switch (n2) {
            case 0: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                vector3f2.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (string2.indexOf("sp3") == 0) {
                    string3 = "sp3";
                    vector3f2.cross(vector3f5, vector3f);
                    vector3f7.cross(vector3f, vector3f2);
                    vector3f2.normalize();
                    vector3f7.normalize();
                    vector3f8.set(vector3f2);
                    vector3f.normalize();
                    vector3f2.scaleAdd(2.828f, vector3f2, vector3f);
                    if (!string2.equals("sp3a") && !string2.equals("sp3")) {
                        vector3f2.normalize();
                        AxisAngle4f axisAngle4f = new AxisAngle4f(vector3f.x, vector3f.y, vector3f.z, (float)(string2.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f matrix3f = new Matrix3f();
                        matrix3f.setIdentity();
                        matrix3f.set(axisAngle4f);
                        matrix3f.transform(vector3f2);
                    }
                    vector3f.set(vector3f2);
                    vector3f2.cross(vector3f7, vector3f);
                    break;
                }
                string3 = "sp";
                if (atom2.getCovalentBondCount() == 3) {
                    this.getHybridizationAndAxes(atom2.atomIndex, vector3f, vector3f5, string2, false);
                    vector3f5.set(vector3f2);
                    if (string2.indexOf("sp2") == 0) {
                        string3 = "sp2";
                        vector3f.scale(-1.0f);
                    }
                }
                vector3f2.cross(vector3f5, vector3f);
                break;
            }
            case 2: {
                if ((double)vector3f.length() < 0.1) {
                    string3 = "sp";
                    if (!string2.equals("pz")) {
                        if (atom2.getCovalentBondCount() != 3) {
                            atom2 = atom3;
                        }
                        if (atom2.getCovalentBondCount() == 3) {
                            this.getHybridizationAndAxes(atom2.atomIndex, vector3f2, vector3f, "pz", false);
                            if (string2.equals("px")) {
                                vector3f2.scale(-1.0f);
                            }
                            vector3f.set(vector3f4);
                            break;
                        }
                    }
                    vector3f.set(vector3f2);
                    vector3f2.cross(vector3f5, vector3f);
                    break;
                }
                string3 = string2.indexOf("sp3") == 0 ? "sp3" : "sp2";
                vector3f5.cross(vector3f, vector3f2);
                if (string2.indexOf("sp") == 0) {
                    if (string2.equals("sp2a") || string2.equals("sp2b")) {
                        vector3f.set(string2.indexOf("b") >= 0 ? vector3f4 : vector3f2);
                        vector3f.scale(-1.0f);
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                if (string2.indexOf("lp") == 0) {
                    string3 = "lp";
                    vector3f5.normalize();
                    vector3f.normalize();
                    vector3f7.scaleAdd(1.2f, vector3f5, vector3f);
                    vector3f8.scaleAdd(-1.2f, vector3f5, vector3f);
                    if (!string2.equals("lp")) {
                        vector3f.set(string2.indexOf("b") >= 0 ? vector3f8 : vector3f7);
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                string3 = string2;
                vector3f2.cross(vector3f, vector3f5);
                vector3f.set(vector3f5);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
                break;
            }
            default: {
                if (vector3f2.angle(vector3f4) < f) {
                    vector3f7.cross(vector3f2, vector3f4);
                } else {
                    vector3f7.cross(vector3f2, vector3f5);
                }
                vector3f7.normalize();
                if (vector3f4.angle(vector3f5) < f) {
                    vector3f8.cross(vector3f4, vector3f5);
                } else {
                    vector3f8.cross(vector3f2, vector3f5);
                }
                vector3f8.normalize();
                if (Math.abs(vector3f8.dot(vector3f7)) < 0.95f) {
                    string3 = "sp3";
                    if (string2.indexOf("sp") == 0) {
                        vector3f.set(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2)));
                        vector3f.scale(-1.0f);
                        vector3f2.set(vector3f7);
                        break;
                    }
                    if (string2.indexOf("lp") == 0 && n2 == 3) {
                        string3 = "lp";
                    }
                    vector3f2.cross(vector3f, vector3f2);
                    break;
                }
                string3 = "sp2";
                if (string2.indexOf("sp") == 0) {
                    vector3f.set(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2)));
                    vector3f.scale(-1.0f);
                    vector3f2.set(vector3f7);
                    break;
                }
                vector3f.set(vector3f7);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
            }
        }
        vector3f2.normalize();
        vector3f.normalize();
        if (Logger.debugging) {
            Logger.debug(atom.getInfo() + " nBonds=" + n2 + " " + string3);
        }
        if (bl) {
            if (string3 == "") {
                return null;
            }
            if (string2.indexOf("p") == 0 ? string3 == "sp3" : string2.indexOf(string3) < 0) {
                return null;
            }
        }
        return string3;
    }

    protected String getChimeInfo(int n, BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        String string = "";
        Chain chain = null;
        Group group = null;
        int n2 = -1;
        int n3 = 0;
        block8: for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            char c = this.atoms[i].getChainID();
            string = c == '\u0000' ? " " : "" + c;
            switch (n) {
                case 0x100006: {
                    break;
                }
                case 34603018: {
                    string = this.atoms[i].getInfo();
                    break;
                }
                case 0x700001: {
                    string = "" + this.atoms[i].getAtomNumber();
                    break;
                }
                case 0x10000B: {
                    string = this.atoms[i].getGroup3();
                    break;
                }
                case 67108910: {
                    string = "[" + this.atoms[i].getGroup3() + "]" + this.atoms[i].getSeqcodeString() + ":" + string;
                    break;
                }
                case 0x100014: {
                    Group group2;
                    if (this.atoms[i].getModelIndex() != n2) {
                        stringBuffer.append('\n');
                        n3 = 0;
                        n2 = this.atoms[i].getModelIndex();
                        stringBuffer.append("Model " + this.atoms[i].getModelNumber());
                        group = null;
                        chain = null;
                    }
                    if (this.atoms[i].getChain() != chain) {
                        stringBuffer.append('\n');
                        n3 = 0;
                        chain = this.atoms[i].getChain();
                        stringBuffer.append("Chain " + string + ":\n");
                        group = null;
                    }
                    if ((group2 = this.atoms[i].getGroup()) == group) continue block8;
                    if (n3++ % 5 == 0 && n3 > 1) {
                        stringBuffer.append('\n');
                    }
                    TextFormat.lFill(stringBuffer, "          ", "[" + this.atoms[i].getGroup3() + "]" + this.atoms[i].getResno() + " ");
                    group = group2;
                    continue block8;
                }
                default: {
                    return "";
                }
            }
            if (stringBuffer.indexOf("\n" + string + "\n") >= 0) continue;
            stringBuffer.append(string).append('\n');
        }
        if (n == 0x100014) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString().substring(1);
    }

    protected BitSet getAtomBits(int n, Object object) {
        BitSet bitSet = new BitSet();
        switch (n) {
            case 0x300001: {
                int n2 = (Integer)object;
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    if (this.atoms[n3].getAtomNumber() != n2) continue;
                    bitSet.set(n3);
                }
                return bitSet;
            }
            case 3145990: {
                String string = "," + object + ",";
                int n4 = this.atomCount;
                while (--n4 >= 0) {
                    String string2 = this.atoms[n4].getAtomName();
                    if (string.indexOf(string2) < 0 || string.indexOf("," + string2 + ",") < 0) continue;
                    bitSet.set(n4);
                }
                return bitSet;
            }
            case 3145986: {
                String string = "," + object + ",";
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    String string3 = this.atoms[n5].getAtomType();
                    if (string.indexOf(string3) < 0 || string.indexOf("," + string3 + ",") < 0) continue;
                    bitSet.set(n5);
                }
                return bitSet;
            }
            case 1048613: {
                int n6 = (Integer)object;
                int n7 = this.atomCount;
                while (--n7 >= 0) {
                    if (this.atoms[n7].getGroupID() != n6) continue;
                    bitSet.set(n7);
                }
                return bitSet;
            }
            case 0x100021: {
                return this.getChainBits((char)((Integer)object).intValue());
            }
            case 1048614: {
                return this.getSeqcodeBits((Integer)object, true);
            }
            case 168820739: {
                int n8 = this.atomCount;
                while (--n8 >= 0) {
                    if (!this.atoms[n8].isHetero()) continue;
                    bitSet.set(n8);
                }
                return bitSet;
            }
            case 168820740: {
                int n9 = this.atomCount;
                while (--n9 >= 0) {
                    if (this.atoms[n9].getElementNumber() != 1) continue;
                    bitSet.set(n9);
                }
                return bitSet;
            }
            case 34603014: {
                int n10 = this.atomCount;
                while (--n10 >= 0) {
                    if (!this.atoms[n10].isProtein()) continue;
                    bitSet.set(n10);
                }
                return bitSet;
            }
            case 34603029: {
                int n11 = this.atomCount;
                while (--n11 >= 0) {
                    if (!this.atoms[n11].isCarbohydrate()) continue;
                    bitSet.set(n11);
                }
                return bitSet;
            }
            case 34603013: {
                int n12 = this.atomCount;
                while (--n12 >= 0) {
                    if (!this.atoms[n12].isNucleic()) continue;
                    bitSet.set(n12);
                }
                return bitSet;
            }
            case 0x2100002: {
                int n13 = this.atomCount;
                while (--n13 >= 0) {
                    if (!this.atoms[n13].isDna()) continue;
                    bitSet.set(n13);
                }
                return bitSet;
            }
            case 34603017: {
                int n14 = this.atomCount;
                while (--n14 >= 0) {
                    if (!this.atoms[n14].isRna()) continue;
                    bitSet.set(n14);
                }
                return bitSet;
            }
            case 34603015: {
                int n15 = this.atomCount;
                while (--n15 >= 0) {
                    if (!this.atoms[n15].isPurine()) continue;
                    bitSet.set(n15);
                }
                return bitSet;
            }
            case 34603016: {
                int n16 = this.atomCount;
                while (--n16 >= 0) {
                    if (!this.atoms[n16].isPyrimidine()) continue;
                    bitSet.set(n16);
                }
                return bitSet;
            }
            case 0x300007: {
                int[] nArray = (int[])object;
                Point3f point3f = new Point3f((float)nArray[0] / 1000.0f, (float)nArray[1] / 1000.0f, (float)nArray[2] / 1000.0f);
                int n17 = this.atomCount;
                while (--n17 >= 0) {
                    if (!this.isInLatticeCell(n17, point3f)) continue;
                    bitSet.set(n17);
                }
                return bitSet;
            }
            case 0x10000B: {
                BitSet bitSet2 = (BitSet)object;
                Group group = null;
                int n18 = this.atomCount;
                while (--n18 >= 0) {
                    Atom atom;
                    Group group2;
                    if (!bitSet2.get(n18) || (group2 = (atom = this.atoms[n18]).getGroup()) == group) continue;
                    group2.selectAtoms(bitSet);
                    group = group2;
                }
                return bitSet;
            }
            case 0x100006: {
                BitSet bitSet3 = (BitSet)object;
                Chain chain = null;
                int n19 = this.atomCount;
                while (--n19 >= 0) {
                    Chain chain2;
                    if (!bitSet3.get(n19) || (chain2 = this.atoms[n19].getChain()) == chain) continue;
                    int n20 = this.atomCount;
                    while (--n20 >= 0) {
                        if (this.atoms[n20].getChain() != chain2) continue;
                        bitSet.set(n20);
                    }
                    chain = chain2;
                }
                return bitSet;
            }
            case 0x301013: {
                BitSet bitSet4 = (BitSet)object;
                Object object2 = null;
                int n21 = this.atomCount;
                while (--n21 >= 0) {
                    Object object3;
                    if (!bitSet4.get(n21) || (object3 = this.atoms[n21].getGroup().getStructure()) == null || object3 == object2) continue;
                    int n22 = this.atomCount;
                    while (--n22 >= 0) {
                        if (this.atoms[n22].getGroup().getStructure() != object3) continue;
                        bitSet.set(n22);
                    }
                    object2 = object3;
                }
                return bitSet;
            }
            case 3149836: {
                BitSet bitSet5 = (BitSet)object;
                BitSet bitSet6 = new BitSet();
                int n23 = this.atomCount;
                while (--n23 >= 0) {
                    if (!bitSet5.get(n23)) continue;
                    bitSet6.set(this.atoms[n23].modelIndex);
                }
                n23 = this.atomCount;
                while (--n23 >= 0) {
                    if (!bitSet6.get(this.atoms[n23].modelIndex)) continue;
                    bitSet.set(n23);
                }
                return bitSet;
            }
            case 3145992: {
                BitSet bitSet7 = (BitSet)object;
                BitSet bitSet8 = new BitSet();
                int n24 = this.atomCount;
                while (--n24 >= 0) {
                    if (!bitSet7.get(n24)) continue;
                    bitSet8.set(this.getElementNumber(n24));
                }
                n24 = this.atomCount;
                while (--n24 >= 0) {
                    if (!bitSet8.get(this.getElementNumber(n24))) continue;
                    bitSet.set(n24);
                }
                return bitSet;
            }
            case 3145746: {
                BitSet bitSet9 = (BitSet)object;
                BitSet bitSet10 = new BitSet();
                int n25 = this.atomCount;
                while (--n25 >= 0) {
                    if (!bitSet9.get(n25)) continue;
                    bitSet10.set(this.atoms[n25].atomSite);
                }
                n25 = this.atomCount;
                while (--n25 >= 0) {
                    if (!bitSet10.get(this.atoms[n25].atomSite)) continue;
                    bitSet.set(n25);
                }
                return bitSet;
            }
            case 1: {
                return this.getIdentifierOrNull((String)object);
            }
            case 0x100020: {
                String string = ((String)object).toUpperCase();
                int n26 = this.atomCount;
                while (--n26 >= 0) {
                    if (!this.isAtomNameMatch(this.atoms[n26], string, false)) continue;
                    bitSet.set(n26);
                }
                return bitSet;
            }
            case 0x10001F: {
                String string = (String)object;
                int n27 = this.atomCount;
                while (--n27 >= 0) {
                    if (!this.atoms[n27].isAlternateLocationMatch(string)) continue;
                    bitSet.set(n27);
                }
                return bitSet;
            }
            case 1048612: {
                return this.getSpecName((String)object);
            }
        }
        Logger.error("MISSING getAtomBits entry for " + Token.nameOf(n));
        return null;
    }

    protected boolean isInLatticeCell(int n, Point3f point3f) {
        Point3f point3f2 = this.atoms[n].getFractionalCoord();
        float f = 0.02f;
        if (point3f2.x < point3f.x - 1.0f - f || point3f2.x > point3f.x + f) {
            return false;
        }
        if (point3f2.y < point3f.y - 1.0f - f || point3f2.y > point3f.y + f) {
            return false;
        }
        return !(point3f2.z < point3f.z - 1.0f - f) && !(point3f2.z > point3f.z + f);
    }

    public BitSet getModelBitSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            bitSet2.set(this.atoms[i].modelIndex);
        }
        return bitSet2;
    }

    private BitSet getIdentifierOrNull(String string) {
        int n;
        BitSet bitSet;
        int n2;
        BitSet bitSet2 = this.getSpecNameOrNull(string, false);
        if (bitSet2 != null || string.indexOf("?") > 0) {
            return bitSet2;
        }
        if (string.indexOf("*") > 0) {
            return this.getSpecNameOrNull(string, true);
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isLetter(string.charAt(n2)); ++n2) {
        }
        bitSet2 = this.getSpecNameOrNull(string.substring(0, n2), false);
        if (n2 == n3) {
            return bitSet2;
        }
        if (bitSet2 == null) {
            bitSet2 = new BitSet();
        }
        int n4 = n2;
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n2 < n3 && string.charAt(n2) == '^' && ++n2 < n3) {
            c = string.charAt(n2);
        }
        if ((bitSet = this.getSeqcodeBits(n = Group.getSeqcode(n5, c), false)) == null) {
            if (c != ' ') {
                bitSet = this.getSeqcodeBits(Character.toUpperCase(string.charAt(n2)), false);
            }
            if (bitSet == null) {
                return null;
            }
            ++n2;
        }
        bitSet2.and(bitSet);
        if (n2 >= n3) {
            return bitSet2;
        }
        char c2 = string.charAt(n2++);
        bitSet2.and(this.getChainBits(c2));
        if (n2 == n3) {
            return bitSet2;
        }
        return null;
    }

    private BitSet getSpecName(String string) {
        BitSet bitSet = this.getSpecNameOrNull(string, false);
        if (bitSet != null) {
            return bitSet;
        }
        if (string.indexOf("*") > 0) {
            bitSet = this.getSpecNameOrNull(string, true);
        }
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet getSpecNameOrNull(String string, boolean bl) {
        BitSet bitSet = null;
        string = string.toUpperCase();
        int n = this.atomCount;
        while (--n >= 0) {
            String string2 = this.atoms[n].getGroup3();
            if (string2.length() > 0) {
                if (!TextFormat.isMatch(string2, string, bl, true)) continue;
                if (bitSet == null) {
                    bitSet = new BitSet(n + 1);
                }
                bitSet.set(n);
                while (--n >= 0 && this.atoms[n].getGroup3().equals(string2)) {
                    bitSet.set(n);
                }
                ++n;
                continue;
            }
            if (!this.isAtomNameMatch(this.atoms[n], string, bl)) continue;
            if (bitSet == null) {
                bitSet = new BitSet(n + 1);
            }
            bitSet.set(n);
        }
        return bitSet;
    }

    private boolean isAtomNameMatch(Atom atom, String string, boolean bl) {
        return TextFormat.isMatch(atom.getAtomName().toUpperCase(), string, bl, false);
    }

    protected BitSet getSeqcodeBits(int n, boolean bl) {
        BitSet bitSet = new BitSet();
        int n2 = Group.getSequenceNumber(n);
        boolean bl2 = n2 != Integer.MAX_VALUE;
        boolean bl3 = true;
        char c = Group.getInsertionCode(n);
        switch (c) {
            case '?': {
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    int n4 = this.atoms[n3].getSeqcode();
                    if (bl2 && (n2 != Group.getSequenceNumber(n4) || Group.getInsertionCodeValue(n4) == 0)) continue;
                    bitSet.set(n3);
                    bl3 = false;
                }
                break;
            }
            default: {
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    int n6 = this.atoms[n5].getSeqcode();
                    if (n != n6 && (bl2 || n != Group.getInsertionCodeValue(n6)) && (c != '*' || n2 != Group.getSequenceNumber(n6))) continue;
                    bitSet.set(n5);
                    bl3 = false;
                }
                break block0;
            }
        }
        return !bl3 || bl ? bitSet : null;
    }

    protected BitSet getChainBits(char c) {
        boolean bl = this.viewer.getChainCaseSensitive();
        if (!bl) {
            c = Character.toUpperCase(c);
        }
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            char c2 = this.atoms[n].getChainID();
            if (!bl) {
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public int[] getAtomIndices(BitSet bitSet) {
        int n = bitSet.size();
        int n2 = 0;
        int[] nArray = new int[this.atomCount];
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[i] = ++n2;
        }
        return nArray;
    }

    public BitSet getAtomsWithin(float f, Point4f point4f) {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = Graphics3D.distanceToPlane(point4f, atom);
            if (!(f > 0.0f && (double)f2 >= -0.1 && f2 <= f || f < 0.0f && (double)f2 <= 0.1 && f2 >= f) && (f != 0.0f || !((double)Math.abs(f2) < 0.01))) continue;
            bitSet.set(atom.atomIndex);
        }
        return bitSet;
    }

    public BitSet getVisibleSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isVisible()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet getClickableSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isClickable()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    protected void deleteModelAtoms(int n, int n2, BitSet bitSet) {
        int n3;
        BitSetUtil.deleteBits(this.bsHidden, bitSet);
        BitSetUtil.deleteBits(this.viewer.getSelectionSet(), bitSet);
        BitSetUtil.deleteBits(this.viewer.getSelectionSubset(), bitSet);
        BitSetUtil.deleteBits(this.viewer.getFrameOffsets(), bitSet);
        this.viewer.setFrameOffsets(this.viewer.getFrameOffsets());
        this.atoms = (Atom[])ArrayUtil.deleteElements(this.atoms, n, n2);
        this.atomCount = this.atoms.length;
        for (n3 = n; n3 < this.atomCount; ++n3) {
            this.atoms[n3].atomIndex = n3;
            this.atoms[n3].modelIndex = (short)(this.atoms[n3].modelIndex - 1);
        }
        this.atomNames = (String[])ArrayUtil.deleteElements(this.atomNames, n, n2);
        this.atomTypes = (String[])ArrayUtil.deleteElements(this.atomTypes, n, n2);
        this.atomSerials = (int[])ArrayUtil.deleteElements(this.atomSerials, n, n2);
        this.bfactor100s = (short[])ArrayUtil.deleteElements(this.bfactor100s, n, n2);
        this.hasBfactorRange = false;
        this.occupancies = (byte[])ArrayUtil.deleteElements(this.occupancies, n, n2);
        this.partialCharges = (float[])ArrayUtil.deleteElements(this.partialCharges, n, n2);
        this.ellipsoids = (Object[][])ArrayUtil.deleteElements(this.ellipsoids, n, n2);
        this.specialAtomIDs = (byte[])ArrayUtil.deleteElements(this.specialAtomIDs, n, n2);
        this.vibrationVectors = (Vector3f[])ArrayUtil.deleteElements(this.vibrationVectors, n, n2);
        this.clientAtomReferences = (Object[])ArrayUtil.deleteElements(this.clientAtomReferences, n, n2);
        this.nSurfaceAtoms = 0;
        this.bsSurface = null;
        this.surfaceDistance100s = null;
        if (this.tainted != null) {
            for (n3 = 0; n3 < 11; ++n3) {
                BitSetUtil.deleteBits(this.tainted[n3], bitSet);
            }
        }
    }

    static {
        if (userSettableValues.length != 11) {
            Logger.error("AtomCollection.java userSettableValues is not length TAINT_MAX!");
        }
    }
}

