/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.modelset.MeasurementPending;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

class PickingManager {
    private Viewer viewer;
    private int pickingMode = 1;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private boolean drawHover;
    private int pickingStyle;
    private MeasurementPending measurementQueued;

    PickingManager(Viewer viewer) {
        this.viewer = viewer;
        this.clear();
    }

    void clear() {
        this.pickingMode = 1;
        this.drawHover = false;
    }

    void setPickingMode(int n) {
        this.pickingMode = n;
        this.resetMeasurement();
    }

    int getPickingMode() {
        return this.pickingMode;
    }

    private void resetMeasurement() {
        this.measurementQueued = new MeasurementPending(this.viewer.getModelSet());
    }

    void setPickingStyle(int n) {
        this.pickingStyle = n;
        if (n >= 4) {
            this.pickingStyleMeasure = n;
            this.resetMeasurement();
        } else {
            this.pickingStyleSelect = n;
        }
    }

    int getPickingStyle() {
        return this.pickingStyle;
    }

    void setDrawHover(boolean bl) {
        this.drawHover = bl;
    }

    boolean getDrawHover() {
        return this.drawHover;
    }

    void atomsPicked(BitSet bitSet, int n) {
        if (BitSetUtil.firstSetBit(bitSet) < 0) {
            return;
        }
        this.pickSelected(Escape.escape(bitSet), n, false);
    }

    private void pickSelected(String string, int n, boolean bl) {
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 8) != 0;
        switch (this.pickingMode) {
            case 2: {
                this.viewer.script("set labeltoggle " + string);
                return;
            }
            case 1: 
            case 8: {
                this.applyMouseStyle(string, bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 9: {
                this.applyMouseStyle("within(group, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 10: {
                this.applyMouseStyle("within(chain, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 11: {
                this.applyMouseStyle("visible and within(molecule, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 12: {
                this.applyMouseStyle("visible and within(site, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 13: {
                this.applyMouseStyle("within(model, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
            case 14: {
                this.applyMouseStyle("visible and within(element, " + string + ")", bl2, bl3, bl);
                this.viewer.clearClickCount();
                return;
            }
        }
    }

    void atomPicked(int n, Point3f point3f, int n2, boolean bl) {
        boolean bl2;
        boolean bl3 = (n2 & 1) != 0;
        boolean bl4 = bl2 = (n2 & 8) != 0;
        if (n < 0) {
            if (bl) {
                return;
            }
            if (this.pickingStyleSelect == 2 && !bl3 && !bl2) {
                this.viewer.script("select none");
            }
            this.resetMeasurement();
            if (this.pickingMode != 5) {
                return;
            }
        }
        int n3 = 2;
        switch (this.pickingMode) {
            case 0: {
                return;
            }
            case 18: {
                ++n3;
            }
            case 17: {
                ++n3;
            }
            case 15: 
            case 16: {
                if (bl) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.getCount() >= n3) {
                    this.resetMeasurement();
                }
                if (this.queueAtom(n, point3f) < n3) {
                    return;
                }
                this.viewer.setStatusMeasuring("measurePicked", n3, this.measurementQueued.getStringDetail());
                if (this.pickingMode == 15 || this.pickingStyleMeasure == 4) {
                    this.viewer.script("measure " + this.measurementQueued.getMeasurementScript(" "));
                }
                return;
            }
            case 3: {
                if (bl) {
                    return;
                }
                if (point3f == null) {
                    this.viewer.script("zoomTo (atomindex=" + n + ")");
                } else {
                    this.viewer.script("zoomTo " + Escape.escape(point3f));
                }
                return;
            }
            case 5: {
                int n4;
                if (bl) {
                    return;
                }
                if (this.viewer.getSpinOn() || this.viewer.getPendingMeasurement() != null) {
                    this.resetMeasurement();
                    this.viewer.script("spin off");
                    return;
                }
                if (this.measurementQueued.getCount() >= 2) {
                    this.resetMeasurement();
                }
                if ((n4 = this.measurementQueued.getCount()) == 1 && (point3f == null ? this.measurementQueued.getAtomIndex(1) == n : this.measurementQueued.getAtom(1).distance(point3f) == 0.0f)) {
                    return;
                }
                if (n >= 0 || point3f != null) {
                    n4 = this.queueAtom(n, point3f);
                }
                if (n4 < 2) {
                    this.viewer.scriptStatus(n4 == 1 ? GT._("pick one more atom in order to spin the model around an axis") : GT._("pick two atoms in order to spin the model around an axis"));
                    return;
                }
                this.viewer.script("spin" + this.measurementQueued.getMeasurementScript(" ") + " " + this.viewer.getPickingSpinRate());
            }
        }
        if (point3f != null) {
            return;
        }
        switch (this.pickingMode) {
            case 1: {
                if (bl) {
                    return;
                }
                this.viewer.setStatusAtomPicked(n, null);
                return;
            }
            case 2: {
                if (bl) {
                    return;
                }
                this.viewer.script("set labeltoggle {atomindex=" + n + "}");
                return;
            }
        }
        this.pickSelected("atomindex=" + n, n2, bl);
    }

    private int queueAtom(int n, Point3f point3f) {
        int n2 = this.measurementQueued.addPoint(n, point3f, true);
        if (n >= 0) {
            this.viewer.setStatusAtomPicked(n, "Atom #" + n2 + ":" + this.viewer.getAtomInfo(n));
        }
        return n2;
    }

    private void applyMouseStyle(String string, boolean bl, boolean bl2, boolean bl3) {
        string = "(" + string + ")";
        if (bl3) {
            this.viewer.script("select " + string);
        } else if (this.pickingStyleSelect == 2 || this.pickingStyleSelect == 3) {
            if (bl && bl2) {
                this.viewer.script("select selected and not " + string);
            } else if (bl) {
                this.viewer.script("select selected tog " + string);
            } else if (bl2) {
                this.viewer.script("select selected or " + string);
            } else {
                this.viewer.script("select " + string);
            }
        } else if (bl || this.pickingStyleSelect == 0) {
            this.viewer.script("select selected tog " + string);
        } else {
            this.viewer.script("select " + string);
        }
    }
}

