/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class DrawBorder
extends Drawable {
    protected Color color;
    protected int width;

    public DrawBorder() {
        this(Color.black, 1);
    }

    public DrawBorder(Color color, int n) {
        this.color = color == null ? Color.black : color;
        this.width = n >= 0 ? n : 1;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null && !color.equals(this.color)) {
            this.color = color;
            this.needsRedraw();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        if (n >= 0 && this.width != this.width) {
            this.width = n;
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        if (this.coords == null || this.width == 0) {
            return;
        }
        graphics.setColor(this.color);
        int n = 0;
        while (n < this.width) {
            graphics.drawRect(this.coords.getLeft() + n, this.coords.getTop() + n, this.coords.getWidth() - 2 * n - 1, this.coords.getHeight() - 2 * n - 1);
            ++n;
        }
    }
}

