/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class DrawString
extends Drawable
implements Computable {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER_CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int BOTTOM_LEFT = 8;
    public static final int BOTTOM_CENTER = 9;
    public static final int BOTTOM_RIGHT = 10;
    public static final int CENTER = 5;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    protected int position;
    protected String baseString;
    protected String[] strings;
    protected Value[] values;
    protected Value xPos;
    protected Value yPos;
    protected Color color;
    protected Font font;
    protected int offset = 3;
    protected boolean clamp = true;
    protected int justification = 0;
    protected int numSize = 10;
    protected Color backgroundColor;
    protected int frameWidth;
    protected Color frameColor;
    private double xRef;
    private double yRef;
    private boolean changed = true;

    public DrawString() {
        this(null, 0, null);
    }

    public DrawString(String string) {
        this(string, 0, null);
    }

    public DrawString(String string, int n) {
        this(string, n, null);
    }

    public DrawString(String string, int n, Value[] valueArray) {
        this.position = n;
        this.values = valueArray;
        this.setString(string);
    }

    public DrawString(String string, int n, Value value, Value value2, Value[] valueArray) {
        this.setReferencePoint(value, value2);
        this.position = n;
        this.values = valueArray;
        this.setString(string);
    }

    public void setColor(Color color) {
        this.color = color;
        this.needsRedraw();
    }

    public Color getColor() {
        return this.color == null ? Color.black : this.color;
    }

    public void setFont(Font font) {
        this.font = font;
        this.needsRedraw();
    }

    public Font getFont() {
        return this.font;
    }

    public void setValues(Value[] valueArray) {
        this.values = valueArray;
        this.changed = true;
        this.needsRedraw();
    }

    public Value[] getValues() {
        return this.values;
    }

    public void setPositioning(int n) {
        this.position = n;
        this.needsRedraw();
    }

    public int getPositioning() {
        return this.position;
    }

    public void setReferencePoint(Value value, Value value2) {
        this.xPos = value;
        this.yPos = value2;
        try {
            if (this.xPos != null) {
                this.xRef = this.xPos.getVal();
            }
            if (this.yPos != null) {
                this.yRef = this.yPos.getVal();
            }
        }
        catch (RuntimeException runtimeException) {}
        this.needsRedraw();
    }

    public Value getXPos() {
        return this.xPos;
    }

    public Value getYPos() {
        return this.yPos;
    }

    public void setString(String string) {
        this.baseString = string;
        this.strings = null;
        this.changed = true;
        this.needsRedraw();
    }

    public String getString() {
        return this.baseString;
    }

    public void setOffset(int n) {
        this.offset = n;
        this.needsRedraw();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setClamp(boolean bl) {
        this.clamp = bl;
        this.needsRedraw();
    }

    public boolean getClamp() {
        return this.clamp;
    }

    public void setJustification(int n) {
        this.justification = n == 2 || n == 5 ? n : 0;
        this.needsRedraw();
    }

    public int getJustification() {
        return this.justification;
    }

    public void setNumSize(int n) {
        this.numSize = Math.min(Math.max(n, 6), 25);
        this.changed = true;
        this.needsRedraw();
    }

    public int getNumSize() {
        return this.numSize;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.needsRedraw();
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color color) {
        this.frameColor = color;
        this.needsRedraw();
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(int n) {
        this.frameWidth = n < 0 ? 0 : (n > 25 ? 25 : n);
        this.needsRedraw();
    }

    public void compute() {
        this.changed = true;
        this.needsRedraw();
    }

    private void getSubstitutedText() {
        this.changed = false;
        if (this.xPos != null) {
            this.xRef = this.xPos.getVal();
        }
        if (this.yPos != null) {
            this.yRef = this.yPos.getVal();
        }
        if (this.values == null && this.strings != null) {
            return;
        }
        if (this.baseString == null || this.baseString.trim().length() == 0) {
            this.strings = null;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.baseString, "\n");
        int n = stringTokenizer.countTokens();
        this.strings = new String[n];
        if (this.values == null) {
            int n2 = 0;
            while (n2 < n) {
                this.strings[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            String string = stringTokenizer.nextToken();
            int n5 = 0;
            while (n5 < string.length()) {
                if (string.charAt(n5) == '#') {
                    if (n5 != string.length() - 1 && string.charAt(n5 + 1) == '#') {
                        stringBuffer.append('#');
                        ++n5;
                    } else if (n3 < this.values.length) {
                        try {
                            stringBuffer.append(NumUtils.realToString(this.values[n3].getVal(), this.numSize));
                        }
                        catch (RuntimeException runtimeException) {
                            stringBuffer.append("(error)");
                        }
                        ++n3;
                    } else {
                        stringBuffer.append("undefined");
                    }
                } else {
                    stringBuffer.append(string.charAt(n5));
                }
                ++n5;
            }
            this.strings[n4] = stringBuffer.toString();
            stringBuffer.setLength(0);
            ++n4;
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        int n;
        FontMetrics fontMetrics;
        if (this.changed) {
            this.getSubstitutedText();
        }
        if (this.strings == null) {
            return;
        }
        if (this.xPos != null && (Double.isNaN(this.xRef) || Double.isInfinite(this.xRef))) {
            return;
        }
        if (this.yPos != null && (Double.isNaN(this.yRef) || Double.isInfinite(this.yRef))) {
            return;
        }
        int n2 = this.offset;
        if (this.backgroundColor != null || this.frameWidth > 0) {
            n2 += 3;
        }
        n2 += this.frameWidth;
        Font font = null;
        if (this.font != null) {
            font = graphics.getFont();
            graphics.setFont(this.font);
            fontMetrics = graphics.getFontMetrics(this.font);
        } else {
            fontMetrics = graphics.getFontMetrics(graphics.getFont());
        }
        int n3 = fontMetrics.getHeight();
        int n4 = this.coords.getLeft();
        int n5 = this.coords.getWidth();
        int n6 = this.coords.getTop();
        int n7 = this.coords.getHeight();
        int n8 = n4 + n5;
        int n9 = n6 + n7;
        int n10 = 0;
        int n11 = 0;
        while (n11 < this.strings.length) {
            n10 = Math.max(n10, fontMetrics.stringWidth(this.strings[n11]));
            ++n11;
        }
        int n12 = this.strings.length * n3;
        if (this.backgroundColor == null && this.frameWidth <= 0) {
            n12 = n12 - fontMetrics.getLeading() - fontMetrics.getDescent();
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = this.position % 4;
        int n16 = this.position / 4;
        if (this.position < 0 || n15 > 2 || n16 > 2) {
            n15 = 0;
            n16 = 0;
        }
        n13 = this.xPos == null ? (n15 == 0 ? n4 + n2 : (n15 == 1 ? (n4 + n8 - n10) / 2 : n8 - n10 - n2)) : (n15 == 0 ? this.coords.xToPixel(this.xRef) + n2 : (n15 == 1 ? this.coords.xToPixel(this.xRef) - n10 / 2 : this.coords.xToPixel(this.xRef) - n10 - n2));
        n14 = this.yPos == null ? (n16 == 0 ? n6 + n2 : (n16 == 1 ? (n6 + n9 - n12) / 2 : n9 - n12 - n2)) : (n16 == 0 ? this.coords.yToPixel(this.yRef) + n2 : (n16 == 1 ? this.coords.yToPixel(this.yRef) - n12 / 2 : this.coords.yToPixel(this.yRef) - n12 - n2));
        if (this.clamp) {
            if (n13 + n10 > n8) {
                n13 = n8 - n10;
            }
            if (n13 < n4) {
                n13 = n4;
            }
            if (n14 + n12 > n9) {
                n14 = n9 - n12;
            }
            if (n14 < n6) {
                n14 = n6;
            }
        }
        if (this.backgroundColor != null) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(n13 - 3, n14 - 3, n10 + 6, n12 + 6);
        }
        if (this.frameWidth > 0) {
            if (this.frameColor != null) {
                graphics.setColor(this.frameColor);
            } else if (this.color != null) {
                graphics.setColor(this.color);
            } else {
                graphics.setColor(Color.black);
            }
            n = 1;
            while (n <= this.frameWidth) {
                graphics.drawRect(n13 - 3 - n, n14 - 3 - n, n10 + 5 + 2 * n, n12 + 5 + 2 * n);
                ++n;
            }
        }
        if (this.color != null) {
            graphics.setColor(this.color);
        } else {
            graphics.setColor(Color.black);
        }
        n14 += fontMetrics.getAscent();
        n = 0;
        while (n < this.strings.length) {
            int n17 = n13;
            if (this.justification == 5) {
                n17 += (n10 - fontMetrics.stringWidth(this.strings[n])) / 2;
            } else if (this.justification == 2) {
                n17 = n17 + n10 - fontMetrics.stringWidth(this.strings[n]);
            }
            graphics.drawString(this.strings[n], n17, n14);
            n14 += n3;
            ++n;
        }
        if (font != null) {
            graphics.setFont(font);
        }
    }
}

