/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class Graph1D
extends Drawable
implements Computable {
    private Function func;
    private Color graphColor = Color.magenta;
    private boolean changed;
    private transient int[] xcoord;
    private transient int[] ycoord;
    private double absoluteYmax;
    private double onscreenymax;
    private double absoluteYmin;
    private double onscreenymin;
    private static final int UNDEFINED = 0;
    private static final int ABOVE = 1;
    private static final int BELOW = 2;
    private static final int ONSCREEN = 3;
    private double[] v = new double[1];
    private Cases case1 = new Cases();
    private Cases case2 = new Cases();
    private static final int MAX_DEPTH = 10;

    public Graph1D() {
    }

    public Graph1D(Function function) {
        this.setFunction(function);
    }

    public void setColor(Color color) {
        if (color != null & (color.equals(this.graphColor) ^ true)) {
            this.graphColor = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.graphColor;
    }

    public synchronized void setFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  Graph1D can only graph a function of one variable.");
        }
        if (function != this.func) {
            this.func = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public Function getFunction() {
        return this.func;
    }

    public synchronized void compute() {
        this.setup(this.coords);
        this.needsRedraw();
    }

    public synchronized void draw(Graphics graphics, boolean bl) {
        if (this.changed || bl || this.xcoord == null || this.ycoord == null) {
            this.setup(this.coords);
            this.changed = false;
        }
        if (this.xcoord.length == 0) {
            return;
        }
        graphics.setColor(this.graphColor);
        int n = this.xcoord[0];
        int n2 = this.ycoord[0];
        int n3 = 1;
        while (n3 < this.xcoord.length) {
            if (this.xcoord[n3] == Integer.MIN_VALUE) {
                while (++n3 < this.xcoord.length && this.xcoord[n3] == Integer.MIN_VALUE) {
                }
                if (n3 < this.xcoord.length) {
                    n = this.xcoord[n3];
                    n2 = this.ycoord[n3];
                }
            } else {
                int n4 = this.xcoord[n3];
                int n5 = this.ycoord[n3];
                graphics.drawLine(n, n2, n4, n5);
                n = n4;
                n2 = n5;
            }
            ++n3;
        }
    }

    private double eval(double d, Cases cases) {
        double d2;
        this.v[0] = d;
        if (cases != null) {
            cases.clear();
        }
        if (Double.isInfinite(d2 = this.func.getValueWithCases(this.v, cases)) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 > this.absoluteYmax) {
            return this.absoluteYmax;
        }
        if (d2 < this.absoluteYmin) {
            return this.absoluteYmin;
        }
        return d2;
    }

    private int getStatus(double d) {
        if (Double.isNaN(d)) {
            return 0;
        }
        if (d > this.onscreenymax) {
            return 1;
        }
        if (d < this.onscreenymin) {
            return 2;
        }
        return 3;
    }

    private void setup(CoordinateRect coordinateRect) {
        if (this.func == null || coordinateRect == null) {
            this.ycoord = new int[0];
            this.xcoord = this.ycoord;
            return;
        }
        Vector<Point> vector = new Vector<Point>();
        double d = (coordinateRect.getXmax() - coordinateRect.getXmin()) / (double)(coordinateRect.getWidth() - 2 * coordinateRect.getGap() - 1);
        this.onscreenymax = coordinateRect.getYmax() + (double)(100 + coordinateRect.getGap()) * d;
        this.onscreenymin = coordinateRect.getYmin() - (double)(100 + coordinateRect.getGap()) * d;
        this.absoluteYmax = coordinateRect.getYmax() + 5000.0 * d;
        this.absoluteYmin = coordinateRect.getYmin() - 5000.0 * d;
        int n = coordinateRect.getLeft();
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = 0;
        double d2 = coordinateRect.pixelToX(n);
        double d3 = this.eval(d2, this.case1);
        int n5 = this.getStatus(d3);
        if (n5 == 3) {
            vector.addElement(new Point(n, coordinateRect.yToPixel(d3)));
        } else if (n5 != 0) {
            n2 = n;
            n3 = coordinateRect.yToPixel(d3);
            n4 = n5;
        }
        int n6 = coordinateRect.getLeft() + coordinateRect.getWidth() - 1;
        while (n < n6) {
            double d4 = d2;
            double d5 = d3;
            int n7 = n5;
            if ((n += 3) > n6) {
                n = n6;
            }
            if ((n5 = this.getStatus(d3 = this.eval(d2 = coordinateRect.pixelToX(n), this.case2))) == 0) {
                if (n7 != 0) {
                    if (n7 == 3) {
                        this.domainEndpoint(coordinateRect, vector, d4, d2, d5, d3, n7, n5, 1);
                    } else if (n2 != Integer.MIN_VALUE) {
                        vector.addElement(new Point(n2, n3));
                    }
                    n2 = Integer.MIN_VALUE;
                    vector.addElement(new Point(Integer.MIN_VALUE, 0));
                }
            } else if (n7 == 0) {
                if (n5 == 3) {
                    this.domainEndpoint(coordinateRect, vector, d4, d2, d5, d3, n7, n5, 1);
                    vector.addElement(new Point(n, coordinateRect.yToPixel(d3)));
                    n2 = Integer.MIN_VALUE;
                } else {
                    n2 = n;
                    n3 = coordinateRect.yToPixel(d3);
                    n4 = n5;
                }
            } else if (this.case1.equals(this.case2)) {
                if (n5 == 3) {
                    if (n2 != Integer.MIN_VALUE) {
                        vector.addElement(new Point(n2, n3));
                        n2 = Integer.MIN_VALUE;
                    }
                    vector.addElement(new Point(n, coordinateRect.yToPixel(d3)));
                } else {
                    int n8 = coordinateRect.yToPixel(d3);
                    if (n2 != Integer.MIN_VALUE) {
                        if (n5 != n4) {
                            vector.addElement(new Point(n2, n3));
                            vector.addElement(new Point(n, n8));
                            vector.addElement(new Point(Integer.MIN_VALUE, 0));
                        }
                    } else {
                        vector.addElement(new Point(n, n8));
                    }
                    n2 = n;
                    n3 = n8;
                    n4 = n5;
                }
            } else if (n7 == 1 || n7 == 2) {
                if (n5 == n7) {
                    if (n2 != Integer.MIN_VALUE) {
                        vector.addElement(new Point(n2, n3));
                        vector.addElement(new Point(Integer.MIN_VALUE, 0));
                    }
                    n2 = n;
                    n3 = coordinateRect.yToPixel(d3);
                    n4 = n5;
                } else if (n5 == 3) {
                    if (n2 != Integer.MIN_VALUE) {
                        vector.addElement(new Point(n2, n3));
                        n2 = Integer.MIN_VALUE;
                    }
                    this.discontinuity(coordinateRect, vector, d4, d2, d5, d3, n7, n5, 1);
                    d3 = this.eval(d2, this.case2);
                    vector.addElement(new Point(n, coordinateRect.yToPixel(d3)));
                } else {
                    if (n2 != Integer.MIN_VALUE) {
                        vector.addElement(new Point(n2, n3));
                    }
                    vector.addElement(new Point(Integer.MIN_VALUE, 0));
                    n2 = n;
                    n3 = coordinateRect.yToPixel(d3);
                    n4 = n5;
                }
            } else {
                this.discontinuity(coordinateRect, vector, d4, d2, d5, d3, n7, n5, 1);
                d3 = this.eval(d2, this.case2);
                if (n5 == 3) {
                    vector.addElement(new Point(n, coordinateRect.yToPixel(d3)));
                    n2 = Integer.MIN_VALUE;
                } else {
                    n2 = n;
                    n3 = coordinateRect.yToPixel(d3);
                    n4 = n5;
                }
            }
            Cases cases = this.case2;
            this.case2 = this.case1;
            this.case1 = cases;
        }
        this.xcoord = new int[vector.size()];
        this.ycoord = new int[vector.size()];
        int n9 = 0;
        while (n9 < this.ycoord.length) {
            Point point = (Point)vector.elementAt(n9);
            this.xcoord[n9] = point.x;
            this.ycoord[n9] = point.y;
            ++n9;
        }
    }

    private void discontinuity(CoordinateRect coordinateRect, Vector vector, double d, double d2, double d3, double d4, int n, int n2, int n3) {
        if (n3 == 10) {
            vector.addElement(new Point(coordinateRect.xToPixel(d), coordinateRect.yToPixel(d3)));
            vector.addElement(new Point(Integer.MIN_VALUE, 0));
            vector.addElement(new Point(coordinateRect.xToPixel(d2), coordinateRect.yToPixel(d4)));
        } else {
            double d5 = (d + d2) / 2.0;
            d3 = this.eval(d, this.case1);
            double d6 = this.eval(d5, this.case2);
            boolean bl = this.case1.equals(this.case2);
            d4 = this.eval(d2, this.case1);
            boolean bl2 = this.case1.equals(this.case2);
            int n4 = this.getStatus(d6);
            if (n4 == 0) {
                if (n == 3) {
                    this.domainEndpoint(coordinateRect, vector, d, d5, d3, d6, n, n4, 1);
                }
                vector.addElement(new Point(Integer.MIN_VALUE, 0));
                if (n2 == 3) {
                    this.domainEndpoint(coordinateRect, vector, d5, d2, d6, d4, n4, n2, 1);
                }
            } else if (!bl) {
                this.discontinuity(coordinateRect, vector, d, d5, d3, d6, n, n4, n3 + 1);
                if (!bl2) {
                    this.discontinuity(coordinateRect, vector, d5, d2, d6, d4, n4, n2, n3 + 1);
                }
            } else if (!bl2) {
                this.discontinuity(coordinateRect, vector, d5, d2, d6, d4, n4, n2, n3 + 1);
            } else {
                System.out.println("Impossible error?  no discontinuity found in discontinuity for " + d + ',' + d2);
            }
        }
    }

    private void domainEndpoint(CoordinateRect coordinateRect, Vector vector, double d, double d2, double d3, double d4, int n, int n2, int n3) {
        if (n3 == 20) {
            if (n == 3) {
                vector.addElement(new Point(coordinateRect.xToPixel(d), coordinateRect.yToPixel(d3)));
            } else {
                vector.addElement(new Point(coordinateRect.xToPixel(d2), coordinateRect.yToPixel(d4)));
            }
        } else {
            double d5 = (d + d2) / 2.0;
            double d6 = this.eval(d5, null);
            int n4 = this.getStatus(d6);
            if (n4 == 1 || n4 == 2) {
                vector.addElement(new Point(coordinateRect.xToPixel(d5), coordinateRect.yToPixel(d6)));
            } else if (n4 == n) {
                this.domainEndpoint(coordinateRect, vector, d5, d2, d6, d4, n4, n2, n3 + 1);
            } else {
                this.domainEndpoint(coordinateRect, vector, d, d5, d3, d6, n, n4, n3 + 1);
            }
        }
    }
}

