/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class ParametricCurve
extends Drawable
implements Computable {
    private Function xFunc;
    private Function yFunc;
    private Color graphColor = Color.magenta;
    private boolean changed;
    private transient int[] xcoord;
    private transient int[] ycoord;
    private Value tmin;
    private Value tmax;
    private Value intervals;
    private double tmin_val;
    private double tmax_val;
    private int intervals_val;
    private double[] v = new double[1];
    private Cases case1x = new Cases();
    private Cases case2x = new Cases();
    private Cases case1y = new Cases();
    private Cases case2y = new Cases();
    private Cases case3x = new Cases();
    private Cases case3y = new Cases();
    private Vector points = new Vector(250);
    private static int MAXDEPTH = 10;

    public ParametricCurve() {
        this(null, null, null, null, null);
    }

    public ParametricCurve(Function function, Function function2) {
        this(function, function2, null, null, null);
    }

    public ParametricCurve(Function function, Function function2, Value value, Value value2, Value value3) {
        if (function != null && function.getArity() != 1 || function2 != null && function2.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  The functions that define a parametric curve must be functions of one variable.");
        }
        this.xFunc = function;
        this.yFunc = function2;
        this.tmin = value;
        this.tmax = value2;
        this.intervals = this.intervals;
        this.changed = true;
    }

    public void setColor(Color color) {
        if (color != null & (color.equals(this.graphColor) ^ true)) {
            this.graphColor = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.graphColor;
    }

    public synchronized void setFunctions(Function function, Function function2) {
        this.setXFunction(function);
        this.setYFunction(function2);
    }

    public synchronized void setXFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  ParametricCurve can only graph functions of one variable.");
        }
        if (function != this.xFunc) {
            this.xFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public synchronized void setYFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  ParametricCurve can only graph functions of one variable.");
        }
        if (function != this.yFunc) {
            this.yFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public Function getXFunction() {
        return this.xFunc;
    }

    public Function getYFunction() {
        return this.yFunc;
    }

    public void setIntervals(Value value) {
        this.intervals = value;
        this.changed = true;
    }

    public Value getIntervals() {
        return this.intervals;
    }

    public void setLimits(Value value, Value value2) {
        this.setTMin(value);
        this.setTMax(value2);
    }

    public Value getTMin() {
        return this.tmin;
    }

    public Value getTMax() {
        return this.tmax;
    }

    public void setTMin(Value value) {
        this.tmin = value;
        this.changed = true;
    }

    public void setTMax(Value value) {
        this.tmax = value;
        this.changed = false;
    }

    public synchronized void compute() {
        this.setup();
        this.needsRedraw();
        this.changed = false;
    }

    public synchronized void draw(Graphics graphics, boolean bl) {
        if (this.changed || bl || this.xcoord == null || this.ycoord == null) {
            this.setup();
            this.changed = false;
        }
        if (this.xcoord == null || this.xcoord.length == 0) {
            return;
        }
        graphics.setColor(this.graphColor);
        int n = this.xcoord[0];
        int n2 = this.ycoord[0];
        int n3 = 1;
        while (n3 < this.xcoord.length) {
            if (this.xcoord[n3] == Integer.MIN_VALUE) {
                while (++n3 < this.xcoord.length && this.xcoord[n3] == Integer.MIN_VALUE) {
                }
                if (n3 < this.xcoord.length) {
                    n = this.xcoord[n3];
                    n2 = this.ycoord[n3];
                }
            } else {
                int n4 = this.xcoord[n3];
                int n5 = this.ycoord[n3];
                graphics.drawLine(n, n2, n4, n5);
                n = n4;
                n2 = n5;
            }
            ++n3;
        }
    }

    private Point eval(double d, Cases cases, Cases cases2) {
        this.v[0] = d;
        if (cases != null) {
            cases.clear();
        }
        if (cases2 != null) {
            cases2.clear();
        }
        double d2 = this.xFunc.getValueWithCases(this.v, cases);
        double d3 = this.yFunc.getValueWithCases(this.v, cases2);
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return null;
        }
        int n = this.coords.xToPixel(d2);
        int n2 = this.coords.yToPixel(d3);
        if (Math.abs(n) > 10000 || Math.abs(n2) > 10000) {
            return null;
        }
        return new Point(n, n2);
    }

    private void setup() {
        if (this.xFunc == null || this.yFunc == null || this.coords == null) {
            this.ycoord = new int[0];
            this.xcoord = this.ycoord;
            return;
        }
        this.tmin_val = this.tmin == null ? -5.0 : this.tmin.getVal();
        this.tmax_val = this.tmax == null ? 5.0 : this.tmax.getVal();
        double d = this.intervals == null ? 200.0 : this.intervals.getVal();
        if (Double.isInfinite(this.tmin_val) || Double.isInfinite(this.tmax_val) || Double.isInfinite(d) || Double.isNaN(this.tmax_val) || Double.isNaN(d)) {
            this.tmin_val = Double.NaN;
        }
        this.intervals_val = d < 1.0 ? 1 : (this.intervals_val > 10000 ? 10000 : (int)Math.round(d));
        if (Double.isNaN(this.tmin_val)) {
            this.ycoord = new int[0];
            this.xcoord = this.ycoord;
            return;
        }
        this.points.setSize(0);
        double d2 = (this.tmax_val - this.tmin_val) / (double)this.intervals_val;
        double d3 = this.tmin_val;
        Point point = this.eval(d3, this.case1x, this.case1y);
        if (point != null) {
            this.points.addElement(point);
        }
        int n = 1;
        while (n <= this.intervals_val) {
            d3 = this.tmin_val + (double)n * d2;
            Point point2 = this.eval(d3, this.case2x, this.case2y);
            if (point2 != null && point != null) {
                if (!this.case1x.equals(this.case2x) || !this.case1y.equals(this.case2y)) {
                    this.discontinuity(point, this.tmin_val + (double)(n - 1) * d2, point2, d3, 0);
                } else {
                    this.points.addElement(point2);
                }
            } else if (point == null && point2 != null) {
                this.becomesDefined(point, this.tmin_val + (double)(n - 1) * d2, point2, d3, 0);
            } else if (point != null && point2 == null) {
                this.becomesUndefined(point, this.tmin_val + (double)(n - 1) * d2, point2, d3, 0);
            }
            point = point2;
            Cases cases = this.case1x;
            this.case1x = this.case2x;
            this.case2x = cases;
            cases = this.case1y;
            this.case1y = this.case2y;
            this.case2y = cases;
            ++n;
        }
        this.xcoord = new int[this.points.size()];
        this.ycoord = new int[this.points.size()];
        int n2 = 0;
        while (n2 < this.ycoord.length) {
            Point point3 = (Point)this.points.elementAt(n2);
            this.xcoord[n2] = point3.x;
            this.ycoord[n2] = point3.y;
            ++n2;
        }
    }

    void discontinuity(Point point, double d, Point point2, double d2, int n) {
        if (n >= MAXDEPTH || Math.abs(point.x - point2.x) < 2 && Math.abs(point.y - point2.y) < 2) {
            if (this.points.elementAt(this.points.size() - 1) != point) {
                this.points.addElement(point);
            }
            if (n >= MAXDEPTH) {
                this.points.addElement(new Point(Integer.MIN_VALUE, 0));
            }
            this.points.addElement(point2);
            return;
        }
        double d3 = (d + d2) / 2.0;
        Point point3 = this.eval(d3, this.case3x, this.case3y);
        if (point3 == null) {
            this.becomesUndefined(point, d, point3, d3, n + 1);
            this.becomesDefined(point3, d3, point2, d2, n + 1);
        } else if (this.case3x.equals(this.case1x) && this.case3y.equals(this.case1y)) {
            this.discontinuity(point3, d3, point2, d2, n + 1);
        } else if (this.case3x.equals(this.case2x) && this.case3y.equals(this.case2y)) {
            this.discontinuity(point, d, point3, d3, n + 1);
        } else {
            this.discontinuity(point, d, point3, d3, n + 2);
            this.discontinuity(point3, d3, point2, d2, n + 2);
        }
    }

    void becomesUndefined(Point point, double d, Point point2, double d2, int n) {
        if (n >= MAXDEPTH) {
            if (this.points.elementAt(this.points.size() - 1) != point) {
                this.points.addElement(point);
            }
            this.points.addElement(new Point(Integer.MIN_VALUE, 0));
            return;
        }
        double d3 = (d + d2) / 2.0;
        Point point3 = this.eval(d3, null, null);
        if (point3 == null) {
            this.becomesUndefined(point, d, point3, d3, n + 1);
        } else {
            this.becomesUndefined(point3, d3, point2, d2, n + 1);
        }
    }

    void becomesDefined(Point point, double d, Point point2, double d2, int n) {
        if (n >= MAXDEPTH) {
            if (this.points.size() > 0) {
                this.points.addElement(new Point(Integer.MIN_VALUE, 0));
            }
            this.points.addElement(point2);
            return;
        }
        double d3 = (d + d2) / 2.0;
        Point point3 = this.eval(d3, null, null);
        if (point3 != null) {
            this.becomesDefined(point, d, point3, d3, n + 1);
        } else {
            this.becomesDefined(point3, d3, point2, d2, n + 1);
        }
    }
}

