/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.ExpressionCommand;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.ParserContext;
import edu.hws.jcm.data.ParserExtension;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;

public abstract class FunctionParserExtension
implements Function,
ParserExtension,
ExpressionCommand {
    protected String name;
    private boolean parensCanBeOptional;

    public void setParensCanBeOptional(boolean bl) {
        this.parensCanBeOptional = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void doParse(Parser parser, ParserContext parserContext) {
        int n = parserContext.next();
        String string = parserContext.tokenString;
        if (n == 4 && (string.equals("(") || string.equals("[") && (parserContext.options & 8) != 0 || string.equals("{") && (parserContext.options & 0x10) != 0)) {
            String string2 = string.equals("(") ? ")" : (string.equals("[") ? "]" : "}");
            int n2 = 0;
            while (n2 < this.getArity()) {
                if (parser.parseExpression(parserContext)) {
                    throw new ParseError("An argument of a function cannot be a logical-valued expression.", parserContext);
                }
                n = parserContext.next();
                if (n2 == this.getArity() - 1) {
                    if (n == 4 && parserContext.tokenString.equals(",")) {
                        throw new ParseError("Too many parameters for function \"" + this.getName() + "\".", parserContext);
                    }
                    if (n != 4 || !parserContext.tokenString.equals(string2)) {
                        throw new ParseError("Expected a \"" + string2 + "\" at the end of the paramter list for function \"" + this.getName() + "\".", parserContext);
                    }
                } else if (n != 4 || !parserContext.tokenString.equals(",")) {
                    throw new ParseError("Exprected a comma followed by another argument for function \"" + this.getName() + "\".", parserContext);
                }
                ++n2;
            }
        } else if (this.getArity() == 1 && (parserContext.options & 0x200) != 0 && this.parensCanBeOptional) {
            if (parser.parseTerm(parserContext)) {
                throw new ParseError("The argument of a function must be a numerical expression.", parserContext);
            }
        } else {
            throw new ParseError("Parentheses required around parameter list of function \"" + this.getName() + "\".", parserContext);
        }
        parserContext.prog.addCommandObject(this);
    }

    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        double[] dArray = new double[this.getArity()];
        int n = this.getArity() - 1;
        while (n >= 0) {
            dArray[n] = stackOfDouble.pop();
            --n;
        }
        stackOfDouble.push(this.getVal(dArray));
    }

    public void compileDerivative(ExpressionProgram expressionProgram, int n, ExpressionProgram expressionProgram2, Variable variable) {
        int n2;
        int[] nArray = new int[this.getArity()];
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.getArity()) {
            nArray[this.getArity() - n4 - 1] = n - n3;
            if (n4 < this.getArity() - 1) {
                n3 += expressionProgram.extent(n - n3);
            }
            ++n4;
        }
        boolean bl = false;
        if (this.dependsOn(variable)) {
            bl = true;
            n2 = 0;
            while (n2 < nArray.length) {
                expressionProgram.copyExpression(nArray[n2], expressionProgram2);
                ++n2;
            }
            expressionProgram2.addCommandObject((FunctionParserExtension)this.derivative(variable));
        }
        n2 = 0;
        while (n2 < this.getArity()) {
            if (expressionProgram.dependsOn(nArray[n2], variable)) {
                int n5 = 0;
                while (n5 < nArray.length) {
                    expressionProgram.copyExpression(nArray[n5], expressionProgram2);
                    ++n5;
                }
                expressionProgram2.addCommandObject((FunctionParserExtension)this.derivative(n2 + 1));
                expressionProgram.compileDerivative(nArray[n2], expressionProgram2, variable);
                expressionProgram2.addCommand(-3);
                if (bl) {
                    expressionProgram2.addCommand(-1);
                }
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            expressionProgram.addConstant(0.0);
        }
    }

    public int extent(ExpressionProgram expressionProgram, int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.getArity()) {
            n2 += expressionProgram.extent(n - n2);
            ++n3;
        }
        return n2;
    }

    public void appendOutputString(ExpressionProgram expressionProgram, int n, StringBuffer stringBuffer) {
        int[] nArray = new int[this.getArity()];
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.getArity()) {
            nArray[this.getArity() - n3 - 1] = n - n2;
            if (n3 < this.getArity() - 1) {
                n2 += expressionProgram.extent(n - n2);
            }
            ++n3;
        }
        String string = this.getName();
        stringBuffer.append(string == null ? "(unnamed function)" : string);
        stringBuffer.append('(');
        int n4 = 0;
        while (n4 < this.getArity()) {
            expressionProgram.appendOutputString(nArray[n4], stringBuffer);
            if (n4 < this.getArity() - 1) {
                stringBuffer.append(", ");
            }
            ++n4;
        }
        stringBuffer.append(')');
    }

    public abstract Function derivative(int var1);

    public abstract Function derivative(Variable var1);

    public abstract int getArity();

    public abstract boolean dependsOn(Variable var1);

    public abstract double getValueWithCases(double[] var1, Cases var2);

    public abstract double getVal(double[] var1);
}

