/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.DoActionListener;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ExpressionObject;

class ExpressionEditDialog
extends ObjectEditDialog {
    TextFieldAction X;
    TextFieldAction Y;
    TextField Expression;
    TextField Prompt;
    TextField Min;
    TextField Max;
    Checkbox Fixed;
    Checkbox Slider;
    ZirkelCanvas ZC;

    public ExpressionEditDialog(Frame frame, ZirkelCanvas zirkelCanvas, ExpressionObject expressionObject) {
        super(frame, Zirkel.name("edit.expression.title"), expressionObject, "expression");
        this.ZC = zirkelCanvas;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.Expression.requestFocus();
    }

    public void addFirst(Panel panel) {
        ExpressionObject expressionObject = (ExpressionObject)this.O;
        this.X = new TextFieldAction((DoActionListener)this, "X", "" + expressionObject.round(expressionObject.getX()));
        panel.add(new MyLabel(Zirkel.name("edit.point.x")));
        panel.add(this.X);
        this.Y = new TextFieldAction((DoActionListener)this, "Y", "" + expressionObject.round(expressionObject.getY()));
        panel.add(new MyLabel(Zirkel.name("edit.point.y")));
        panel.add(this.Y);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(expressionObject.fixed());
        panel.add(new MyLabel(Zirkel.name("edit.fixed")));
        panel.add(this.Fixed);
        if (expressionObject.fixed()) {
            this.X.setText(expressionObject.getEX());
            this.Y.setText(expressionObject.getEY());
        }
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(1, 0));
        this.Slider = new Checkbox("");
        this.Slider.setState(expressionObject.isSlider());
        panel.add(new MyLabel(Zirkel.name("edit.expression.slider")));
        myPanel.add(this.Slider);
        this.Min = new TextFieldAction((DoActionListener)this, "Min", "" + expressionObject.getMin());
        this.Max = new TextFieldAction((DoActionListener)this, "Max", "" + expressionObject.getMax());
        myPanel.add(this.Min);
        myPanel.add(this.Max);
        panel.add(myPanel);
        this.Prompt = new MyTextField(expressionObject.getPrompt());
        panel.add(new MyLabel(Zirkel.name("edit.expression.prompt")));
        panel.add(this.Prompt);
        this.Expression = new TextFieldAction(this, "OK", expressionObject.getExpression(), 30);
        panel.add(new MyLabel(Zirkel.name("edit.expression")));
        panel.add(this.Expression);
    }

    public void doAction(String string) {
        if (string.equals("OK") && (this.Fixed != null && this.X.isChanged() || this.Y.isChanged())) {
            this.Fixed.setState(true);
        }
        super.doAction(string);
    }

    public void setAction() {
        double d2;
        ExpressionObject expressionObject = (ExpressionObject)this.O;
        if (this.Slider.getState()) {
            expressionObject.setSlider(this.Min.getText(), this.Max.getText());
            if (this.Expression.getText().equals("")) {
                this.Expression.setText(this.Min.getText());
            }
        } else {
            expressionObject.setSlider(false);
        }
        try {
            double d3 = new Double(this.X.getText());
            d2 = new Double(this.Y.getText());
            expressionObject.move(d3, d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            expressionObject.setExpression(this.Expression.getText(), this.ZC.getConstruction());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.Fixed.getState()) {
            expressionObject.setFixed(this.X.getText(), this.Y.getText());
        } else {
            try {
                double d4 = new Expression(this.X.getText(), expressionObject.getConstruction(), expressionObject).getValue();
                d2 = new Expression(this.Y.getText(), expressionObject.getConstruction(), expressionObject).getValue();
                expressionObject.move(d4, d2);
                expressionObject.setFixed(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        expressionObject.setPrompt(this.Prompt.getText());
    }
}

