/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.freehep.graphicsio.font.truetype.TTFFileInput;
import org.freehep.graphicsio.font.truetype.TTFFont;

public class TTFFile
extends TTFFont {
    private static final String mode = "r";
    private String fileName;
    private RandomAccessFile ttf;
    private int sfntMajorVersion;
    private int sfntMinorVersion;
    private int numberOfTables;
    private int searchRange;
    private int entrySelector;
    private int rangeShift;

    public TTFFile(String string) throws FileNotFoundException, IOException {
        this.fileName = string;
        this.ttf = new RandomAccessFile(string, mode);
        this.ttf.seek(0L);
        this.sfntMajorVersion = this.ttf.readUnsignedShort();
        this.sfntMinorVersion = this.ttf.readUnsignedShort();
        this.numberOfTables = this.ttf.readUnsignedShort();
        this.searchRange = this.ttf.readUnsignedShort();
        this.entrySelector = this.ttf.readUnsignedShort();
        this.rangeShift = this.ttf.readUnsignedShort();
        for (int i2 = 0; i2 < this.numberOfTables; ++i2) {
            this.ttf.seek(12 + i2 * 16);
            byte[] byArray = new byte[4];
            this.ttf.readFully(byArray);
            String string2 = new String(byArray);
            int n2 = this.ttf.readInt();
            int n3 = this.ttf.readInt();
            int n4 = this.ttf.readInt();
            TTFFileInput tTFFileInput = new TTFFileInput(this.ttf, n3, n4, n2);
            this.newTable(string2, tTFFileInput);
        }
    }

    public int getFontVersion() {
        return this.sfntMajorVersion;
    }

    public void close() throws IOException {
        super.close();
        this.ttf.close();
    }

    public void show() {
        super.show();
        System.out.println("Font: " + this.fileName);
        System.out.println("  sfnt: " + this.sfntMajorVersion + "." + this.sfntMinorVersion);
        System.out.println("  numTables: " + this.numberOfTables);
        System.out.println("  searchRange: " + this.searchRange);
        System.out.println("  entrySelector: " + this.entrySelector);
        System.out.println("  rangeShift: " + this.rangeShift);
    }
}

