/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.freehep.util.Service;
import org.freehep.util.export.ExportFileType;

public class ExportFileTypeRegistry {
    private static ExportFileTypeRegistry registry;
    private static ClassLoader loader;
    private ServiceRegistry service = new ServiceRegistry(categories.iterator());
    private List extraTypes = new ArrayList();
    private static final Collection categories;

    private ExportFileTypeRegistry() {
    }

    public static synchronized ExportFileTypeRegistry getDefaultInstance(ClassLoader classLoader) {
        if (classLoader != null && classLoader != loader) {
            if (loader != null) {
                throw new RuntimeException(ExportFileTypeRegistry.class.getName() + ": Different classloader was already used in getDefaultInstance");
            }
            loader = classLoader;
        }
        if (registry == null) {
            registry = new ExportFileTypeRegistry();
            ExportFileTypeRegistry.addApplicationClasspathExportFileTypes(registry);
        }
        return registry;
    }

    public List get() {
        return this.get(null);
    }

    public List get(String string) {
        ArrayList arrayList = new ArrayList();
        this.addExportFileTypeToList(arrayList, string, this.service.getServiceProviders(ExportFileType.class, true));
        this.addExportFileTypeToList(arrayList, string, this.extraTypes.iterator());
        return arrayList;
    }

    public void add(ExportFileType exportFileType) {
        this.extraTypes.add(exportFileType);
    }

    private void addExportFileTypeToList(List list, String string, Iterator iterator) {
        block0: while (iterator.hasNext()) {
            ExportFileType exportFileType = (ExportFileType)iterator.next();
            if (string == null) {
                if (list.contains(exportFileType)) continue;
                list.add(exportFileType);
                continue;
            }
            String[] stringArray = exportFileType.getExtensions();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].equalsIgnoreCase(string)) continue;
                if (list.contains(exportFileType)) continue block0;
                list.add(exportFileType);
                continue block0;
            }
        }
    }

    private static void addApplicationClasspathExportFileTypes(ExportFileTypeRegistry exportFileTypeRegistry) {
        ClassLoader classLoader = loader != null ? loader : Thread.currentThread().getContextClassLoader();
        Iterator iterator = categories.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Iterator iterator2 = Service.providers(clazz, classLoader).iterator();
            Object t2 = null;
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                exportFileTypeRegistry.service.registerServiceProvider(e2);
                if (t2 != null) {
                    exportFileTypeRegistry.service.setOrdering(clazz, t2, e2);
                }
                t2 = e2;
            }
        }
    }

    static {
        categories = new ArrayList(2);
        categories.add(ExportFileType.class);
        categories.add(RegisterableService.class);
    }
}

